package com.huawei.dli.jdbc;

import com.huawei.dli.sdk.util.DateFormatUtils;

import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.ParameterMetaData;
import java.sql.PreparedStatement;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLXML;
import java.sql.Time;
import java.sql.Timestamp;
import java.sql.Types;
import java.util.Calendar;
import java.util.HashMap;

public class DliPreparedStatement extends DliStatement implements PreparedStatement {
    private final String sql;

    private final HashMap<Integer, Object> parameters = new HashMap<>();

    public DliPreparedStatement(DliConnection conn, String sql) throws SQLException {
        super(conn);
        this.sql = sql;
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#addBatch()
     */

    public void addBatch() throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#clearParameters()
     */

    public void clearParameters() throws SQLException {
        this.parameters.clear();
    }

    /**
     * Invokes executeQuery(sql) using the sql provided to the constructor.
     *
     * @return boolean Returns true if a resultSet is created, false if not.
     * Note: If the result set is empty a true is returned.
     * @throws SQLException If fail to call the API, e.g. server error or other reason.
     */

    public boolean execute() throws SQLException {
        return super.execute(updateSql(sql, parameters));
    }

    /**
     * Invokes executeQuery(sql) using the sql provided to the constructor.
     *
     * @return ResultSet
     * @throws SQLException If fail to call the API, e.g. server error or other reason.
     */

    public ResultSet executeQuery() throws SQLException {
        return super.executeQuery(updateSql(sql, parameters));
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#executeUpdate()
     */

    public int executeUpdate() throws SQLException {
        super.executeUpdate(updateSql(sql, parameters));
        return 0;
    }

    /**
     * update the SQL string with parameters set by setXXX methods of {@link PreparedStatement}
     *
     * @param sql        the sql string
     * @param parameters parameters in map
     * @return updated SQL string
     * @throws SQLException If fail to call the API, e.g. server error or other reason.
     */
    private String updateSql(final String sql, HashMap<Integer, Object> parameters) throws SQLException {
        if (!sql.contains("?")) {
            return sql;
        }

        StringBuilder newSql = new StringBuilder(sql);

        int paramIndex = 1;
        int pos = 0;

        while (pos < newSql.length()) {
            if (newSql.charAt(pos) == '?') {
                if (parameters.containsKey(paramIndex)) {
                    newSql.deleteCharAt(pos);
                    String str = convertJavaTypeToSqlString(parameters.get(paramIndex));
                    newSql.insert(pos, str);
                    pos += str.length() - 1;
                }
                paramIndex++;
            } else {
                pos++;
            }
        }
        return newSql.toString();
    }

    private String convertJavaTypeToSqlString(Object x) throws SQLException {
        if (x instanceof Long) {
            return x.toString();
        } else if (x instanceof String) {
            return "'" + x.toString() + "'";
        } else if (x instanceof byte[]) {
            try {
                String charset = getConnection().getConnRes().getCharSet();
                if (charset != null) {
                    return "'" + new String((byte[]) x, charset) + "'";
                } else {
                    throw new SQLException("charset is null");
                }
            } catch (UnsupportedEncodingException e) {
                throw new SQLException(e);
            }
        } else if (x instanceof Double) {
            return x.toString();
        } else if (x instanceof java.util.Date) {
            return "cast('" + DateFormatUtils.getDateTimeString((java.util.Date) x) + "' as datetime)";
        } else if (x instanceof Boolean) {
            return x.toString();
        } else if (x instanceof BigDecimal) {
            return "cast('" + x + "' as decimal)";
        } else if (x == null) {
            return "NULL";
        } else {
            throw new SQLException("unrecognized Java class: " + x.getClass().getName());
        }
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#getMetaData()
     */

    public ResultSetMetaData getMetaData() throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#getParameterMetaData()
     */

    public ParameterMetaData getParameterMetaData() throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setArray(int, java.sql.Array)
     */

    public void setArray(int i, Array x) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setAsciiStream(int, java.io.InputStream)
     */

    public void setAsciiStream(int parameterIndex, InputStream x) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setAsciiStream(int, java.io.InputStream,
     * int)
     */

    public void setAsciiStream(int parameterIndex, InputStream x, int length) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setAsciiStream(int, java.io.InputStream,
     * long)
     */

    public void setAsciiStream(int parameterIndex, InputStream x, long length) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setBigDecimal(int, java.math.BigDecimal)
     */

    public void setBigDecimal(int parameterIndex, BigDecimal x) throws SQLException {
        this.parameters.put(parameterIndex, x.toString());
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setBinaryStream(int, java.io.InputStream)
     */

    public void setBinaryStream(int parameterIndex, InputStream x) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setBinaryStream(int, java.io.InputStream,
     * int)
     */

    public void setBinaryStream(int parameterIndex, InputStream x, int length) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setBinaryStream(int, java.io.InputStream,
     * long)
     */

    public void setBinaryStream(int parameterIndex, InputStream x, long length) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setBlob(int, java.sql.Blob)
     */

    public void setBlob(int i, Blob x) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setBlob(int, java.io.InputStream)
     */

    public void setBlob(int parameterIndex, InputStream inputStream) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setBlob(int, java.io.InputStream, long)
     */

    public void setBlob(int parameterIndex, InputStream inputStream, long length)
        throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setBoolean(int, boolean)
     */

    public void setBoolean(int parameterIndex, boolean x) throws SQLException {
        this.parameters.put(parameterIndex, x);
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setByte(int, byte)
     */

    public void setByte(int parameterIndex, byte x) throws SQLException {
        this.parameters.put(parameterIndex, (long) x);
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setBytes(int, byte[])
     */

    public void setBytes(int parameterIndex, byte[] x) throws SQLException {
        this.parameters.put(parameterIndex, x);
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setCharacterStream(int, java.io.Reader)
     */

    public void setCharacterStream(int parameterIndex, Reader reader) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setCharacterStream(int, java.io.Reader,
     * int)
     */

    public void setCharacterStream(int parameterIndex, Reader reader, int length)
        throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setCharacterStream(int, java.io.Reader,
     * long)
     */

    public void setCharacterStream(int parameterIndex, Reader reader, long length)
        throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setClob(int, java.sql.Clob)
     */

    public void setClob(int i, Clob x) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setClob(int, java.io.Reader)
     */

    public void setClob(int parameterIndex, Reader reader) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setClob(int, java.io.Reader, long)
     */

    public void setClob(int parameterIndex, Reader reader, long length) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setDate(int, java.sql.Date)
     */

    public void setDate(int parameterIndex, Date x) throws SQLException {
        this.parameters.put(parameterIndex, new java.util.Date(x.getTime()));
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setDate(int, java.sql.Date,
     * java.util.Calendar)
     */

    public void setDate(int parameterIndex, Date x, Calendar cal) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setDouble(int, double)
     */

    public void setDouble(int parameterIndex, double x) throws SQLException {
        this.parameters.put(parameterIndex, x);
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setFloat(int, float)
     */

    public void setFloat(int parameterIndex, float x) throws SQLException {
        this.parameters.put(parameterIndex, (double) x);
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setInt(int, int)
     */

    public void setInt(int parameterIndex, int x) throws SQLException {
        this.parameters.put(parameterIndex, (long) x);
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setLong(int, long)
     */

    public void setLong(int parameterIndex, long x) throws SQLException {
        this.parameters.put(parameterIndex, x);
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setNCharacterStream(int, java.io.Reader)
     */

    public void setNCharacterStream(int parameterIndex, Reader value) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setNCharacterStream(int, java.io.Reader,
     * long)
     */

    public void setNCharacterStream(int parameterIndex, Reader value, long length)
        throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setNClob(int, java.sql.NClob)
     */

    public void setNClob(int parameterIndex, NClob value) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setNClob(int, java.io.Reader)
     */

    public void setNClob(int parameterIndex, Reader reader) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setNClob(int, java.io.Reader, long)
     */

    public void setNClob(int parameterIndex, Reader reader, long length) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setNString(int, java.lang.String)
     */

    public void setNString(int parameterIndex, String value) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setNull(int, int)
     */

    public void setNull(int parameterIndex, int sqlType) throws SQLException {
        parameters.put(parameterIndex, null);
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setNull(int, int, java.lang.String)
     */

    public void setNull(int parameterIndex, int sqlType, String typeName) throws SQLException {
        this.parameters.put(parameterIndex, null);
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setObject(int, java.lang.Object)
     */

    public void setObject(int parameterIndex, Object x) throws SQLException {
        if (x == null) {
            setNull(parameterIndex, Types.NULL);
        } else if (x instanceof String) {
            setString(parameterIndex, (String) x);
        } else if (x instanceof byte[]) {
            setBytes(parameterIndex, (byte[]) x);
        } else if (x instanceof Short) {
            setShort(parameterIndex, (Short) x);
        } else if (x instanceof Integer) {
            setInt(parameterIndex, (Integer) x);
        } else if (x instanceof Long) {
            setLong(parameterIndex, (Long) x);
        } else if (x instanceof Float) {
            setFloat(parameterIndex, (Float) x);
        } else if (x instanceof Double) {
            setDouble(parameterIndex, (Double) x);
        } else if (x instanceof Boolean) {
            setBoolean(parameterIndex, (Boolean) x);
        } else if (x instanceof Byte) {
            setByte(parameterIndex, (Byte) x);
        } else if (x instanceof BigDecimal) {
            setBigDecimal(parameterIndex, (BigDecimal) x);
        } else if (x instanceof Timestamp) {
            setTimestamp(parameterIndex, (Timestamp) x);
        } else if (x instanceof Time) {
            setTime(parameterIndex, (Time) x);
        } else if (x instanceof Date) {
            setDate(parameterIndex, (Date) x);
        } else {
            throw new SQLException("can not set an object of type: " + x.getClass().getName());
        }
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setObject(int, java.lang.Object, int)
     */

    public void setObject(int parameterIndex, Object x, int targetSqlType)
        throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setObject(int, java.lang.Object, int, int)
     */

    public void setObject(int parameterIndex, Object x, int targetSqlType, int scale)
        throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setRef(int, java.sql.Ref)
     */

    public void setRef(int i, Ref x) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setRowId(int, java.sql.RowId)
     */

    public void setRowId(int parameterIndex, RowId x) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setSQLXML(int, java.sql.SQLXML)
     */

    public void setSQLXML(int parameterIndex, SQLXML xmlObject) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setShort(int, short)
     */

    public void setShort(int parameterIndex, short x) throws SQLException {
        this.parameters.put(parameterIndex, (long) x);
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setString(int, java.lang.String)
     */

    public void setString(int parameterIndex, String x) throws SQLException {
        if (x == null) {
            this.parameters.put(parameterIndex, null);
            return;
        }
        this.parameters.put(parameterIndex, x.getBytes());
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setTime(int, java.sql.Time)
     */

    public void setTime(int parameterIndex, Time x) throws SQLException {
        if (x == null) {
            parameters.put(parameterIndex, null);
            return;
        }
        parameters.put(parameterIndex, new java.util.Date(x.getTime()));
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setTime(int, java.sql.Time,
     * java.util.Calendar)
     */

    public void setTime(int parameterIndex, Time x, Calendar cal) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setTimestamp(int, java.sql.Timestamp)
     */

    public void setTimestamp(int parameterIndex, Timestamp x) throws SQLException {
        this.parameters.put(parameterIndex, "'" + x.toString() + "'");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setTimestamp(int, java.sql.Timestamp,
     * java.util.Calendar)
     */

    public void setTimestamp(int parameterIndex, Timestamp x, Calendar cal)
        throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setURL(int, java.net.URL)
     */

    public void setURL(int parameterIndex, URL x) throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    /*
     * (non-Javadoc)
     *
     * @see java.sql.PreparedStatement#setUnicodeStream(int, java.io.InputStream,
     * int)
     */

    @SuppressWarnings("deprecation")
    public void setUnicodeStream(int parameterIndex, InputStream x, int length)
        throws SQLException {
        // TODO Auto-generated method stub
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

}
