package com.huawei.dli.jdbc;

import com.huawei.dli.sdk.meta.types.Column;

import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class DliStaticResultSet extends DliResultSet {

    private Iterator<Object[]> iterator;

    Object[] row;

    /**
     * For some meta query (like procedures) we need to return an empty query result.
     */
    private final boolean isEmptyResultSet;

    public DliStaticResultSet(DliConnection conn, DliResultSetMetaData meta) throws SQLException {
        super(conn, null, meta);
        isEmptyResultSet = true;
    }

    public DliStaticResultSet(DliConnection conn, DliResultSetMetaData meta, Iterator<Object[]> iter)
        throws SQLException {
        super(conn, null, meta);
        iterator = iter;
        isEmptyResultSet = false;
    }

    public DliStaticResultSet(DliStatement statement, List<Column> resultSchema, Iterator<Object[]> iter)
        throws SQLException {
        super(statement.getConnection(), statement, new DliResultSetMetaData(resultSchema));
        iterator = iter;
        isEmptyResultSet = false;
    }

    @Override
    protected Object[] rowAtCursor() throws SQLException {
        return row;
    }

    @Override
    public boolean next() throws SQLException {
        if (isEmptyResultSet) {
            return false;
        }
        if (iterator.hasNext()) {
            row = iterator.next();
            return true;
        } else {
            return false;
        }
    }

    @Override
    public void close() throws SQLException {
        iterator = null;
    }
}
