package com.huawei.dli.jdbc.model;

import com.huawei.dli.jdbc.utils.type.DliType;

import java.sql.DatabaseMetaData;
import java.sql.SQLException;

import lombok.Getter;

public class DliColumn {
    @Getter
    private final String tableSchema;

    @Getter
    private final String tableName;

    @Getter
    private final String columnName;

    @Getter
    private final String comment;

    @Getter
    private final int ordinalPos;

    private final DliType type;

    @Getter
    private final String typeName;

    public DliColumn(String columnName, String tableName, String tableSchema, DliType type,
        String typeName, String comment, int ordinalPos) {
        this.columnName = columnName;
        this.tableName = tableName;
        this.tableSchema = tableSchema;
        this.type = type;
        this.typeName = typeName;
        this.comment = comment;
        this.ordinalPos = ordinalPos;
    }

    public int getType() throws SQLException {
        return type.getSqlType();
    }

    public int getNumPercRaidx() {
        return 10;
    }

    public int getDecimalDigits() {
        return 0;
    }

    public int getIsNullable() {
        return DatabaseMetaData.columnNullable;
    }

    public String getIsNullableString() {
        switch (getIsNullable()) {
            case (DatabaseMetaData.columnNoNulls):
                return "NO";
            case (DatabaseMetaData.columnNullable):
                return "YES";
            default:
                return null;
        }
    }
}
