package com.huawei.dli.jdbc.model;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum EnumSqlJobType {
    IMPORT("IMPORT"),
    EXPORT("EXPORT"),
    QUERY("QUERY"),
    INSERT("INSERT"),
    SQL_IMPORT("SQL_IMPORT"),
    SQL_EXPORT("SQL_EXPORT"),
    SQL_QUERY("SQL_QUERY"),
    SQL_INSERT("SQL_INSERT"),
    ANALYZE("ANALYZE"),
    UPDATE("UPDATE"),
    DELETE("DELETE"),
    LIFECYCLE_CLEAN("LIFECYCLE_CLEAN");

    EnumSqlJobType(String key) {
        this.key = key;
    }

    private String key;

    public static EnumSqlJobType of(String sqlType) {
        return Arrays.stream(EnumSqlJobType.values())
            .filter(p -> p.key.equalsIgnoreCase(sqlType)).findFirst().orElse(null);
    }

    public static boolean isInHasResultType(String sqlType) {
        EnumSqlJobType type = of(sqlType);
        List<EnumSqlJobType> types = new ArrayList<>();
        types.add(EnumSqlJobType.QUERY);
        types.add(EnumSqlJobType.SQL_QUERY);
        return types.contains(type);
    }

    public static boolean isInNoResultType(String sqlType) {
        EnumSqlJobType type = of(sqlType);
        List<EnumSqlJobType> types = new ArrayList<>();
        types.add(EnumSqlJobType.IMPORT);
        types.add(EnumSqlJobType.EXPORT);
        types.add(EnumSqlJobType.INSERT);
        types.add(EnumSqlJobType.SQL_IMPORT);
        types.add(EnumSqlJobType.SQL_EXPORT);
        types.add(EnumSqlJobType.SQL_INSERT);
        types.add(EnumSqlJobType.ANALYZE);
        types.add(EnumSqlJobType.UPDATE);
        types.add(EnumSqlJobType.DELETE);
        types.add(EnumSqlJobType.LIFECYCLE_CLEAN);
        return types.contains(type);
    }
}
