package com.huawei.dli.jdbc.utils;

import org.slf4j.Logger;

public class ExceptionReporter {

    public static final Logger log = LoggerFactory.getLogger(null, ExceptionReporter.class.getName());

    // Exception reporter that prints the exception
    // to the console (used as default)
    private static final Reporter PRINT_EXCEPTION = new Reporter() {
        @Override
        public void report(Throwable t) {
            log.error(t.getMessage());
        }
    };

    private static Reporter defaultReporter = PRINT_EXCEPTION;

    // Helps change the default reporter back to
    // PrintException in the future
    public static Reporter getPrintException() {
        return PRINT_EXCEPTION;
    }

    public static Reporter getExceptionReporter() {
        return defaultReporter;
    }

    public static void setExceptionReporter(Reporter repoter) {
        defaultReporter = repoter;
    }

}
