package com.huawei.dli.jdbc.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorUtils {
    private static volatile ExecutorService sqlSubmitExecutor = null;

    private static final Object SQL_SUBMIT_LOCKER = new Object();

    private ExecutorUtils() {
    }

    public static ExecutorService sqlSubmitExecutor(int threadNum) {
        if (sqlSubmitExecutor != null) {
            return sqlSubmitExecutor;
        }
        synchronized (SQL_SUBMIT_LOCKER) {
            if (sqlSubmitExecutor != null) {
                return sqlSubmitExecutor;
            }
            sqlSubmitExecutor = Executors.newFixedThreadPool(threadNum,
                new ThreadFactory() {
                    private final AtomicInteger threadNum = new AtomicInteger(0);

                    @Override
                    public Thread newThread(Runnable r) {
                        Thread thread = new Thread(r);
                        thread.setDaemon(true);
                        thread.setName("SqlSubmitThread_" + threadNum.getAndIncrement());
                        return thread;
                    }
                });
        }
        return sqlSubmitExecutor;
    }
}
