package com.huawei.dli.jdbc.utils;

import org.slf4j.Logger;

import java.io.File;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class LoggerFactory {

    private static Map<String, Logger> cache = new ConcurrentHashMap<String, Logger>();

    @SuppressWarnings({"rawtypes", "unchecked"})
    public static Logger getLogger(String logConfFile, String name) {
        if (cache.containsKey(name)) {
            return cache.get(name);
        }
        Logger logger = null;
        if (logConfFile != null) {
            try {
                Class loggerContextClazz = Class.forName("ch.qos.logback.classic.LoggerContext");
                Class contextInitializerClazz =
                    Class.forName("ch.qos.logback.classic.util.ContextInitializer");
                Object loggerContext = loggerContextClazz.newInstance();
                Object contextInitializer =
                    contextInitializerClazz.getConstructor(loggerContextClazz).newInstance(loggerContext);
                Method configureByResourceMethod =
                    contextInitializerClazz.getMethod("configureByResource", URL.class);
                URL url = new File(logConfFile).toURI().toURL();
                configureByResourceMethod.invoke(contextInitializer, url);
                Method getLoggerMethod = loggerContextClazz.getMethod("getLogger", String.class);
                logger = (Logger) getLoggerMethod.invoke(loggerContext, name);
                logger.debug("Configure logConf Successfully : {}", url);
            } catch (Throwable e) {
                org.slf4j.LoggerFactory.getLogger(name).error(
                    "Configure logConf failed: " + logConfFile
                        + " , replace with application's default conf ~ ", e);
                logger = org.slf4j.LoggerFactory.getLogger(name);
            }
        } else {
            logger = org.slf4j.LoggerFactory.getLogger(name);
        }
        cache.put(name, logger);
        return logger;
    }

}

