package com.huawei.dli.jdbc.utils.type;

import com.huawei.dli.sdk.meta.types.ArrayType;
import com.huawei.dli.sdk.meta.types.DataType;

import com.huaweicloud.sdk.core.utils.JsonUtils;

import java.sql.Array;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SimpleArray implements Array {
    protected ArrayType dataType;

    protected List<Object> values;

    protected Object objValue;

    public SimpleArray(ArrayType dataType, Object obj) {
        if (dataType == null) {
            throw new IllegalArgumentException("Illegal arguments for struct object.");
        }
        this.dataType = dataType;
        this.objValue = obj;
    }

    @Override
    public String toString() {
        if (objValue == null) {
            return "";
        }
        if (objValue instanceof String) {
            return objValue.toString();
        }
        return JsonUtils.toJSON(this.objValue);
    }

    @Override
    public String getBaseTypeName() throws SQLException {
        return DliType.ARRAY.name();
    }

    @Override
    public int getBaseType() throws SQLException {
        return java.sql.Types.ARRAY;
    }

    @Override
    public Object getArray() throws SQLException {
        if (values == null) {
            parseArray();
        }
        return values.toArray();
    }

    @SuppressWarnings({"unchecked"})
    private void parseArray() throws SQLException {
        assert objValue instanceof List;
        List<Object> objList = (List<Object>) objValue;
        DataType elemDataType = dataType.getElemType();
        this.values = new ArrayList<>();
        for (Object obj : objList) {
            this.values.add(TypeUtils.getField(obj, elemDataType));
        }
    }

    @Override
    public Object getArray(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getArray(long index, int count) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Object getArray(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getResultSet(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getResultSet(long index, int count) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public ResultSet getResultSet(long index, int count, Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void free() throws SQLException {
    }
}
