package com.huawei.dli.jdbc.utils.type;

import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.meta.types.DataType;
import com.huawei.dli.sdk.meta.types.StructType;

import com.huaweicloud.sdk.core.utils.JsonUtils;

import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SimpleStruct implements Struct {
    protected StructType dataType;

    protected List<Object> values;

    protected Object objValue;

    public SimpleStruct(StructType dataType, Object obj) {
        if (dataType == null) {
            throw new IllegalArgumentException("Illegal arguments for struct object.");
        }
        this.dataType = dataType;
        this.objValue = obj;
    }

    @SuppressWarnings({"unchecked"})
    private void parseStruct() throws SQLException {
        values = new ArrayList<>();
        if (objValue == null || objValue.toString().equalsIgnoreCase("null")) {
            values.add(null);
            return;
        }
        assert objValue instanceof Map;
        Map<String, Object> objMap = (Map<String, Object>) objValue;
        for (Column field : dataType.getFields()) {
            Object fieldObj = objMap.get(field.getName());
            DataType fieldDataType = field.getType();
            if (fieldObj == null || fieldObj.toString().equalsIgnoreCase("null")) {
                values.add(null);
                continue;
            }
            values.add(TypeUtils.getField(fieldObj, fieldDataType));
        }
    }

    @Override
    public String toString() {
        if (objValue == null) {
            return "";
        }
        if (objValue instanceof String) {
            return objValue.toString();
        }
        return JsonUtils.toJSON(this.objValue);
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return DliType.STRUCT.name();
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        if (values == null) {
            parseStruct();
        }
        return values.toArray();
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}
