/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.jdbc;

import com.huawei.dli.jdbc.DliDatabaseMetaData;
import com.huawei.dli.jdbc.DliPreparedStatement;
import com.huawei.dli.jdbc.DliStatement;
import com.huawei.dli.jdbc.model.DliException;
import com.huawei.dli.jdbc.utils.ConnectionResource;
import com.huawei.dli.jdbc.utils.ExceptionReporter;
import com.huawei.dli.jdbc.utils.LoggerFactory;
import com.huawei.dli.jdbc.utils.Reporter;
import com.huawei.dli.sdk.common.SqlDialect;
import com.huawei.dli.sdk.util.ApiTemplate;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.slf4j.Logger;

public class DliConnection
implements Connection {
    private static final String JDBC_VERSION = "dli-jdbc/2.1.3";
    private final ConnectionResource connRes;
    private final Map<String, String> sessConfMap = new LinkedHashMap<String, String>();
    private final List<Statement> stmtHandles;
    private boolean isClosed = false;
    protected final Logger log;

    public DliConnection(Properties info, String url) throws DliException {
        ApiTemplate.setVersion((String)JDBC_VERSION);
        this.connRes = ConnectionResource.constructConnectionResource(info, url);
        this.parseSqlProperties(info);
        this.stmtHandles = new ArrayList<Statement>();
        this.log = LoggerFactory.getLogger(this.connRes.getLogConfFile(), this.getClass().getName());
        this.log.info("DLI.JDBC driver, Version v1.0");
        this.log.info(String.format("endpoint=%s, project=%s", this.connRes.getEndpoint(), this.connRes.getProjectId()));
        Reporter logRepoter = new Reporter(){

            @Override
            public void report(Throwable t) {
                DliConnection.this.log.error(t.getMessage());
            }
        };
        ExceptionReporter.setExceptionReporter(logRepoter);
    }

    private void parseSqlProperties(Properties info) {
        String v2;
        if (info == null) {
            return;
        }
        String v1 = info.getProperty("spark.sql.forcePartitionPredicatesOnPartitionedTable.enabled");
        if (v1 != null && !v1.isEmpty()) {
            this.sessConfMap.put("spark.sql.forcePartitionPredicatesOnPartitionedTable.enabled", v1);
        }
        if ((v2 = info.getProperty("spark.sql.mergeSmallFiles.enabled")) != null && !v2.isEmpty()) {
            this.sessConfMap.put("spark.sql.mergeSmallFiles.enabled", v2);
        }
    }

    public ConnectionResource getConnRes() {
        return this.connRes;
    }

    public Map<String, String> getSessConfMap() {
        return this.sessConfMap;
    }

    @Override
    public Statement createStatement() throws SQLException {
        this.checkClosed();
        DliStatement stmt = new DliStatement(this, false);
        this.stmtHandles.add(stmt);
        return stmt;
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return new DliPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Connection is closed");
        }
        if (!autoCommit) {
            throw new SQLFeatureNotSupportedException("Enabling autocommit is not supported");
        }
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return true;
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void close() throws SQLException {
        if (!this.isClosed) {
            for (Statement stmt : this.stmtHandles) {
                if (stmt == null) continue;
                stmt.close();
            }
        }
        this.isClosed = true;
        this.log.info("connection closed");
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        String sqlEngine = SqlDialect.SPARK.getValue();
        if (this.connRes != null && SqlDialect.HETU_ENGINE.getValue().equalsIgnoreCase(this.connRes.getEngineType())) {
            sqlEngine = SqlDialect.HETU_ENGINE.getValue();
        }
        return new DliDatabaseMetaData(this, sqlEngine);
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
        if (readOnly) {
            throw new SQLFeatureNotSupportedException();
        }
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
    }

    @Override
    public String getCatalog() throws SQLException {
        return null;
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw new SQLException("Statement with resultset concurrency " + resultSetConcurrency + " is not supported");
        }
        if (resultSetType != 1003) {
            throw new SQLException("Statement with resultset type " + resultSetType + " is not supported");
        }
        return this.createStatement();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return new DliPreparedStatement(this, sql);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        return new DliPreparedStatement(this, sql);
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isValid(int timeout) throws SQLException {
        return true;
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return null;
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    @Override
    public void setSchema(String schema) throws SQLException {
    }

    @Override
    public String getSchema() throws SQLException {
        return null;
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Cannot unwrap to " + iface);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("The connection has already been closed");
        }
    }
}

