/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.jdbc;

import com.huawei.dli.jdbc.DliConnection;
import com.huawei.dli.jdbc.DliResultSetMetaData;
import com.huawei.dli.jdbc.DliStaticResultSet;
import com.huawei.dli.jdbc.model.DliColumn;
import com.huawei.dli.jdbc.model.DliException;
import com.huawei.dli.jdbc.utils.type.DliType;
import com.huawei.dli.sdk.DLIClient;
import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.meta.Table;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.meta.types.DataType;
import com.huawei.dli.sdk.meta.types.PrimitiveType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class DliDatabaseMetaData
implements DatabaseMetaData {
    private static final String PRODUCT_NAME = "Data Lake Insight";
    private static final String PRODUCT_VERSION = "1.1.1";
    private static final String DRIVER_NAME = "DLI";
    private static final int DRIVER_MAJOR_VERSION = 1;
    private static final int DRIVER_MINOR_VERSION = 1;
    private static final int MAX_TABLE_NAME_LENGTH = 128;
    private static final String CATALOG_SEPARATOR = ".";
    private static final char SEARCH_STRING_ESCAPE = '\\';
    private final DliConnection connection;
    private final String sqlEngine;
    private volatile DLIClient dliClient;

    public DliDatabaseMetaData(DliConnection connection, String sqlEngine) {
        this.connection = connection;
        this.sqlEngine = sqlEngine;
    }

    void setDliClient(DLIClient dliClient) {
        this.dliClient = dliClient;
        this.dliClient.setDialect(this.sqlEngine);
    }

    private synchronized DLIClient getDliClient() {
        if (this.dliClient == null) {
            this.dliClient = new DLIClient(this.connection.getConnRes().toDliInfo());
            this.dliClient.setDialect(this.sqlEngine);
        }
        return this.dliClient;
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        return true;
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean deletesAreDetected(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public ResultSet getAttributes(String catalog, String schemaPattern, String typeNamePattern, String attributeNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public ResultSet getBestRowIdentifier(String catalog, String schema, String table, int scope, boolean nullable) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        return CATALOG_SEPARATOR;
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        return "instance";
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultSet getCatalogs() throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public ResultSet getColumnPrivileges(String catalog, String schema, String table, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        DliResultSetMetaData rsMeta = new DliResultSetMetaData(Arrays.asList(new Column("TABLE_CAT", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("TABLE_SCHEM", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("TABLE_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("COLUMN_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("DATA_TYPE", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("TYPE_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("COLUMN_SIZE", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("BUFFER_LENGTH", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("DECIMAL_DIGITS", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("NUM_PERC_RADIX", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("NULLABLE", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("REMARKS", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("COLUMN_DEF", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("SQL_DATA_TYPE", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("SQL_DATETIME_SUB", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("CHAR_OCTET_LENGTH", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("ORDINAL_POSITION", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("IS_NULLABLE", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("SCOPE_CATALOG", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("SCOPE_SCHEMA", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("SCOPE_TABLE", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("SOURCE_DATA_TYPE", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("IS_AUTO_INCREMENT", (DataType)new PrimitiveType(DataType.TypeName.STRING))));
        try {
            String dbPattern = this.updatePattern(schemaPattern);
            String tblPattern = this.updatePattern(tableNamePattern);
            List tables = this.getDliClient().listTables(this.getCatalog(catalog), dbPattern, tblPattern);
            ArrayList<DliColumn> dliColumns = new ArrayList<DliColumn>();
            for (Table tbl : tables) {
                dliColumns.addAll(this.toDliColumns(tbl));
            }
            List<Object[]> rows = this.toResultRows(dliColumns, columnNamePattern);
            return new DliStaticResultSet(this.connection, rsMeta, rows.iterator());
        }
        catch (DLIException e) {
            throw new SQLException("Failed to list tables with detail:" + e.getMessage(), e);
        }
    }

    private List<Object[]> toResultRows(List<DliColumn> dliColumns, String colNamePattern) throws SQLException {
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (DliColumn column : dliColumns) {
            String regex;
            String colName = column.getColumnName();
            if (colNamePattern != null && !colNamePattern.isEmpty() && !colName.matches(regex = colNamePattern.replace("%", ".*"))) continue;
            Object[] rowVals = new Object[]{null, column.getTableSchema(), column.getTableName(), column.getColumnName(), (long)column.getType(), column.getTypeName(), null, null, (long)column.getDecimalDigits(), (long)column.getNumPercRaidx(), (long)column.getIsNullable(), column.getComment(), null, null, null, null, (long)column.getOrdinalPos(), column.getIsNullableString(), null, null, null, null, "NO"};
            rows.add(rowVals);
        }
        return rows;
    }

    private List<DliColumn> toDliColumns(Table tbl) throws DliException {
        ArrayList<DliColumn> cols = new ArrayList<DliColumn>();
        int i = 1;
        for (Column col : tbl.getColumns()) {
            cols.add(new DliColumn(col.getName(), tbl.getTableName(), tbl.getDatabase().getDatabaseName(), DliType.of(col.getType().getName()), col.getType().getName(), col.getDescription() == null ? "" : col.getDescription(), i++));
        }
        return cols;
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String primaryCatalog, String primarySchema, String primaryTable, String foreignCatalog, String foreignSchema, String foreignTable) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return PRODUCT_NAME;
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        return PRODUCT_VERSION;
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return 1;
    }

    @Override
    public int getDriverMinorVersion() {
        return 1;
    }

    @Override
    public String getDriverName() throws SQLException {
        return DRIVER_NAME;
    }

    @Override
    public String getDriverVersion() throws SQLException {
        return "1.1";
    }

    @Override
    public ResultSet getExportedKeys(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getFunctionColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public ResultSet getFunctions(String catalog, String schemaPattern, String functionNamePattern) throws SQLException {
        DliResultSetMetaData rsMeta = new DliResultSetMetaData(Arrays.asList(new Column("FUNCTION_CAT", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("FUNCTION_SCHEM", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("FUNCTION_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("REMARKS", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("FUNCTION_TYPE", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("SPECIFIC_NAME", (DataType)new PrimitiveType(DataType.TypeName.BIGINT))));
        try {
            String dbPattern = this.updatePattern(schemaPattern);
            String funcPattern = this.updatePattern(functionNamePattern);
            List functions = this.getDliClient().listFunctions(this.getCatalog(catalog), dbPattern, funcPattern).stream().map(funcIdent -> new Object[]{this.getCatalog(catalog), funcIdent.getDatabaseName(), funcIdent.getFunctionName(), null, "JAVA", funcIdent.getFunctionName()}).collect(Collectors.toList());
            return new DliStaticResultSet(this.connection, rsMeta, functions.iterator());
        }
        catch (DLIException e) {
            throw new SQLException("Failed to get functions", e);
        }
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        return " ";
    }

    @Override
    public ResultSet getImportedKeys(String catalog, String schema, String table) throws SQLException {
        DliResultSetMetaData rsMeta = new DliResultSetMetaData(Arrays.asList(new Column("PKTABLE_CAT", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("PKTABLE_SCHEM", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("PKTABLE_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("PKCOLUMN_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("FKTABLE_CAT", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("FKTABLE_SCHEM", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("FKTABLE_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("FKCOLUMN_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("KEY_SEQ", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("UPDATE_RULE", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("DELETE_RULE", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("FK_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("PK_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("DEFERRABILITY", (DataType)new PrimitiveType(DataType.TypeName.STRING))));
        return new DliStaticResultSet(this.connection, rsMeta);
    }

    @Override
    public ResultSet getIndexInfo(String catalog, String schema, String table, boolean unique, boolean approximate) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 3;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxConnections() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxStatements() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 128;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getPrimaryKeys(String catalog, String schema, String table) throws SQLException {
        DliResultSetMetaData rsMeta = new DliResultSetMetaData(Arrays.asList(new Column("TABLE_CAT", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("TABLE_SCHEM", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("TABLE_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("COLUMN_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("KEY_SEQ", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("PK_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING))));
        return new DliStaticResultSet(this.connection, rsMeta);
    }

    @Override
    public ResultSet getProcedureColumns(String catalog, String schemaPattern, String procedureNamePattern, String columnNamePattern) throws SQLException {
        DliResultSetMetaData rsMeta = new DliResultSetMetaData(Arrays.asList(new Column("STUPID_PLACEHOLDERS", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("USELESS_PLACEHOLDER", (DataType)new PrimitiveType(DataType.TypeName.STRING))));
        return new DliStaticResultSet(this.connection, rsMeta);
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        return "UDF";
    }

    @Override
    public ResultSet getProcedures(String catalog, String schemaPattern, String procedureNamePattern) throws SQLException {
        DliResultSetMetaData rsMeta = new DliResultSetMetaData(Arrays.asList(new Column("PROCEDURE_CAT", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("PROCEDURE_SCHEM", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("PROCEDURE_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("RESERVERD", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("RESERVERD", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("RESERVERD", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("REMARKS", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("PROCEDURE_TYPE", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("SPECIFIC_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING))));
        return new DliStaticResultSet(this.connection, rsMeta);
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 2;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        return "database";
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        return this.getSchemas(null, null);
    }

    /*
     * Exception decompiling
     */
    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * java.lang.UnsupportedOperationException
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.NewAnonymousArray.getDimSize(NewAnonymousArray.java:142)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.isNewArrayLambda(LambdaRewriter.java:455)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:409)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteDynamicExpression(LambdaRewriter.java:167)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:105)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.rewriters.ExpressionRewriterHelper.applyForwards(ExpressionRewriterHelper.java:12)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriterToArgs(AbstractMemberFunctionInvokation.java:101)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractMemberFunctionInvokation.applyExpressionRewriter(AbstractMemberFunctionInvokation.java:87)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewriteExpression(LambdaRewriter.java:103)
         *     at org.benf.cfr.reader.bytecode.analysis.structured.statement.StructuredAssignment.rewriteExpressions(StructuredAssignment.java:146)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.op4rewriters.LambdaRewriter.rewrite(LambdaRewriter.java:88)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.rewriteLambdas(Op04StructuredStatement.java:1137)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:912)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        return String.valueOf('\\');
    }

    @Override
    public String getStringFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        DliResultSetMetaData rsMeta = new DliResultSetMetaData(Collections.singletonList(new Column("TABLE_TYPE", (DataType)new PrimitiveType(DataType.TypeName.STRING))));
        List rows = Arrays.asList({"TABLE"}, {"VIEW"});
        return new DliStaticResultSet(this.connection, rsMeta, rows.iterator());
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        DliResultSetMetaData rsMeta = new DliResultSetMetaData(Arrays.asList(new Column("TABLE_CAT", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("TABLE_SCHEM", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("TABLE_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("TABLE_TYPE", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("REMARKS", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("TYPE_CAT", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("TYPE_SCHEM", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("TYPE_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("SELF_REFERENCING_COL_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("REF_GENERATION", (DataType)new PrimitiveType(DataType.TypeName.STRING))));
        try {
            String dbPattern = this.updatePattern(schemaPattern);
            String tblPattern = this.updatePattern(tableNamePattern);
            List tables = this.getDliClient().listTables(this.getCatalog(catalog), dbPattern, tblPattern, types).stream().map(tblIdent -> new Object[]{this.getCatalog(catalog), tblIdent.getDatabaseName(), tblIdent.getTableName(), "TABLE", tblIdent.getTableName(), null, null, null, null, "USER"}).collect(Collectors.toList());
            return new DliStaticResultSet(this.connection, rsMeta, tables.iterator());
        }
        catch (DLIException e) {
            throw new SQLException("Failed to get tables", e);
        }
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        return "";
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        DliResultSetMetaData rsMeta = new DliResultSetMetaData(Arrays.asList(new Column("STUPID_PLACEHOLDERS", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("USELESS_PLACEHOLDER", (DataType)new PrimitiveType(DataType.TypeName.STRING))));
        return new DliStaticResultSet(this.connection, rsMeta);
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        DliResultSetMetaData rsMeta = new DliResultSetMetaData(Arrays.asList(new Column("TYPE_CAT", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("TYPE_SCHEM", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("TYPE_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("CLASS_NAME", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("DATA_TYPE", (DataType)new PrimitiveType(DataType.TypeName.BIGINT)), new Column("REMARKS", (DataType)new PrimitiveType(DataType.TypeName.STRING)), new Column("BASE_TYPE", (DataType)new PrimitiveType(DataType.TypeName.BIGINT))));
        return new DliStaticResultSet(this.connection, rsMeta);
    }

    @Override
    public String getURL() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public String getUserName() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        return false;
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        return true;
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        return false;
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        return true;
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    private String updatePattern(String sqlPattern) {
        if (StringUtils.isEmpty((CharSequence)sqlPattern)) {
            return sqlPattern;
        }
        return sqlPattern.replace("%", "*");
    }

    private String getCatalog(String catalog) {
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{catalog})) {
            return catalog;
        }
        if (!StringUtils.isEmpty((CharSequence)this.connection.getConnRes().getCatalog())) {
            return this.connection.getConnRes().getCatalog();
        }
        return catalog;
    }
}

