/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.jdbc;

import com.huawei.dli.jdbc.DliConnection;
import com.huawei.dli.jdbc.utils.ConnectionResource;
import com.huawei.dli.jdbc.utils.ExceptionReporter;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.logging.Logger;

public class DliDriver
implements Driver {
    private static final boolean JDBC_COMPLIANT = false;

    public DliDriver() {
        SecurityManager security = System.getSecurityManager();
        if (security != null) {
            security.checkWrite("dli");
        }
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        return new DliConnection(info, url);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return ConnectionResource.acceptURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        ConnectionResource connRes = ConnectionResource.constructConnectionResource(info, url);
        DriverPropertyInfo projectIdProp = new DriverPropertyInfo("projectid", connRes.getProjectId());
        projectIdProp.required = true;
        projectIdProp.description = "DLI project id";
        DriverPropertyInfo hostProp = new DriverPropertyInfo("host", info.getProperty("host", connRes.getHost()));
        hostProp.required = true;
        hostProp.description = "Hostname of DLI service";
        DriverPropertyInfo portProp = new DriverPropertyInfo("port", info.getProperty("port", String.valueOf(connRes.getPort())));
        portProp.required = true;
        portProp.description = "Port number of DLI service";
        DriverPropertyInfo queueNameProp = new DriverPropertyInfo("queuename", info.getProperty("queuename", connRes.getQueueName()));
        queueNameProp.required = true;
        queueNameProp.description = "Port number of DLI service";
        DriverPropertyInfo dbProp = new DriverPropertyInfo("databasename", info.getProperty("databasename", connRes.getDatabaseName()));
        dbProp.required = false;
        dbProp.description = "Database name";
        return new DriverPropertyInfo[]{projectIdProp, hostProp, portProp, queueNameProp, dbProp};
    }

    @Override
    public int getMajorVersion() {
        return 1;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() throws SQLFeatureNotSupportedException {
        return null;
    }

    static {
        try {
            DriverManager.registerDriver(new DliDriver());
        }
        catch (SQLException e) {
            ExceptionReporter.getExceptionReporter().report(e);
        }
    }
}

