/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.jdbc;

import com.huawei.dli.jdbc.DliResultSet;
import com.huawei.dli.jdbc.DliResultSetMetaData;
import com.huawei.dli.jdbc.DliStatement;
import com.huawei.dli.sdk.SQLJob;
import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.read.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public class DliForwardResultSet
extends DliResultSet {
    private final AtomicInteger fetchNum = new AtomicInteger();
    private final ResultSet sqlResultSet;
    private final long expectNum;
    private boolean isClosed = false;
    private Object[] currentRow;

    public DliForwardResultSet(DliStatement stmt, SQLJob sqlJob, long expectNum) throws SQLException {
        super(stmt.getConnection(), stmt, new DliResultSetMetaData(sqlJob.getResultSchema()));
        try {
            this.sqlResultSet = sqlJob.getResultSet();
            this.expectNum = expectNum;
        }
        catch (DLIException e) {
            throw new SQLException("Failed to init result set", e);
        }
    }

    public DliForwardResultSet(DliStatement stmt, List<Column> resultSchema, ResultSet sqlResultSet, long expectNum) throws SQLException {
        super(stmt.getConnection(), stmt, new DliResultSetMetaData(resultSchema));
        this.sqlResultSet = sqlResultSet;
        this.expectNum = expectNum;
    }

    @Override
    public int getRow() throws SQLException {
        this.checkClosed();
        try {
            if (!this.sqlResultSet.hasNext() || this.expectNum > 0L && (long)this.fetchNum.get() >= this.expectNum) {
                return -1;
            }
            return this.fetchNum.get();
        }
        catch (DLIException e) {
            throw new SQLException("Failed to get row", e);
        }
    }

    @Override
    protected Object[] rowAtCursor() throws SQLException {
        if (this.currentRow == null) {
            throw new SQLException("the row should be not-null");
        }
        if (this.currentRow.length == 0) {
            throw new SQLException("the row should have more than 1 column");
        }
        return this.currentRow;
    }

    @Override
    public boolean next() throws SQLException {
        this.checkClosed();
        try {
            if (!this.sqlResultSet.hasNext() || this.expectNum > 0L && (long)this.fetchNum.get() >= this.expectNum) {
                this.close();
                return false;
            }
            this.currentRow = this.sqlResultSet.read().getRecord().toArray();
            this.fetchNum.incrementAndGet();
            return true;
        }
        catch (DLIException e) {
            throw new SQLException("Failed to read record", e);
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.currentRow = null;
        this.isClosed = true;
        try {
            this.sqlResultSet.close();
        }
        catch (DLIException e) {
            throw new SQLException("Failed to close result set", e);
        }
    }

    private void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("The result set has been closed");
        }
    }
}

