/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.jdbc;

import com.huawei.dli.jdbc.model.DliException;
import com.huawei.dli.jdbc.utils.type.DliType;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.meta.types.DataType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class DliResultSetMetaData
implements ResultSetMetaData {
    private String catalogName = " ";
    private String schemeName = " ";
    private String tableName = " ";
    private final List<Column> columns;
    private final List<DliType> columnTypes = new ArrayList<DliType>();
    private final Map<String, Integer> colNameIndexMap = new HashMap<String, Integer>();

    public DliResultSetMetaData(List<Column> columns) {
        this.columns = columns;
        try {
            int i = 1;
            for (Column col : columns) {
                this.columnTypes.add(DliType.of(col.getType().getName()));
                this.colNameIndexMap.put(col.getName().toLowerCase(Locale.ROOT), i++);
            }
        }
        catch (DliException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    @Override
    public String getCatalogName(int column) throws SQLException {
        return this.catalogName;
    }

    @Override
    public String getSchemaName(int column) throws SQLException {
        return this.schemeName;
    }

    @Override
    public String getTableName(int column) throws SQLException {
        return this.tableName;
    }

    @Override
    public int getColumnCount() throws SQLException {
        return this.columns.size();
    }

    @Override
    public String getColumnClassName(int column) throws SQLException {
        return this.columnTypes.get(this.toZeroIndex(column)).getSqlTypeClass().getName();
    }

    @Override
    public String getColumnLabel(int column) throws SQLException {
        return this.getColumnName(column);
    }

    @Override
    public String getColumnName(int column) throws SQLException {
        return this.columns.get(this.toZeroIndex(column)).getName();
    }

    @Override
    public int getColumnType(int column) throws SQLException {
        return this.columnTypes.get(this.toZeroIndex(column)).getSqlType();
    }

    @Override
    public String getColumnTypeName(int column) throws SQLException {
        return this.columns.get(this.toZeroIndex(column)).getType().getName();
    }

    @Override
    public int getPrecision(int column) throws SQLException {
        int zeroIdx = this.toZeroIndex(column);
        DataType dataType = this.columns.get(zeroIdx).getType();
        return this.columnTypes.get(zeroIdx).precision(dataType);
    }

    @Override
    public int getScale(int column) throws SQLException {
        int zeroIdx = this.toZeroIndex(column);
        DataType dataType = this.columns.get(zeroIdx).getType();
        return this.columnTypes.get(zeroIdx).scale(dataType);
    }

    @Override
    public int getColumnDisplaySize(int column) throws SQLException {
        int zeroIdx = this.toZeroIndex(column);
        DataType dataType = this.columns.get(zeroIdx).getType();
        return this.columnTypes.get(zeroIdx).displaySize(dataType);
    }

    @Override
    public boolean isAutoIncrement(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isCaseSensitive(int column) throws SQLException {
        return this.columnTypes.get(this.toZeroIndex(column)).caseSensitive();
    }

    @Override
    public boolean isCurrency(int column) throws SQLException {
        return false;
    }

    @Override
    public boolean isDefinitelyWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public int isNullable(int column) throws SQLException {
        return 1;
    }

    @Override
    public boolean isReadOnly(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSearchable(int column) throws SQLException {
        return true;
    }

    @Override
    public boolean isSigned(int column) throws SQLException {
        return this.columnTypes.get(this.toZeroIndex(column)).signed();
    }

    @Override
    public boolean isWritable(int column) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    private int toZeroIndex(int column) {
        if (column <= 0 || column > this.columns.size()) {
            throw new IllegalArgumentException();
        }
        return column - 1;
    }

    public int getColumnIndex(String columnLabel) {
        return this.colNameIndexMap.getOrDefault(columnLabel.toLowerCase(Locale.ROOT), -1);
    }

    public void setCatalogName(String catalogName) {
        this.catalogName = catalogName;
    }

    public void setSchemeName(String schemeName) {
        this.schemeName = schemeName;
    }

    public void setTableName(String tableName) {
        this.tableName = tableName;
    }
}

