/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.jdbc;

import com.huawei.dli.jdbc.DliConnection;
import com.huawei.dli.jdbc.DliForwardResultSet;
import com.huawei.dli.jdbc.model.DliException;
import com.huawei.dli.jdbc.utils.ErrorCode;
import com.huawei.dli.jdbc.utils.ExecutorUtils;
import com.huawei.dli.jdbc.utils.SqlUtils;
import com.huawei.dli.sdk.SQLJob;
import com.huawei.dli.sdk.common.DLIInfo;
import com.huawei.dli.sdk.util.V3ClientUtils;
import com.huaweicloud.sdk.dli.v1.DliClient;
import com.huaweicloud.sdk.dli.v1.model.CancelSqlJobRequest;
import com.huaweicloud.sdk.dli.v1.model.CancelSqlJobResponse;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.text.Normalizer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.regex.Pattern;

public class DliStatement
implements Statement {
    private DliConnection connHandle;
    private ResultSet resultSet = null;
    private boolean isClosed = false;
    private int resultSetMaxRows = Integer.MAX_VALUE;
    private long updateCount = -1L;
    private String jobId = null;
    private int queryTimeout = 0;
    private SQLWarning warning = null;
    protected Map<String, String> annotationConf = new HashMap<String, String>();
    private static final Pattern SET_PATTERN = Pattern.compile("(?i)^(SET)(\\s){1,10}(.){1,50}=(.){1,50};?(\\s){0,10}$");
    private static final Pattern USE_PATTERN = Pattern.compile("(?i)^(USE)(\\s){1,10}(.){0,200};?(\\s){0,10}$");

    public DliStatement(DliConnection conn) throws SQLException {
        this(conn, false);
    }

    DliStatement(DliConnection conn, boolean isResultSetScrollable) throws SQLException {
        this.connHandle = conn;
        this.warning = new SQLWarning("successful completion");
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        if (this.connHandle.getConnRes().isCheckNoResultQuery()) {
            SqlUtils.checkForNoResult(sql);
        }
        return this.executeQueryInternal(sql);
    }

    private ResultSet executeQueryInternal(String sql) throws SQLException {
        if (!this.execute(sql)) {
            throw new SQLException("The query did not generate a result set!");
        }
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        this.execute(sql);
        return (int)this.updateCount;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.annotationConf.clear();
        this.jobId = null;
        this.connHandle = null;
        this.isClosed = true;
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setMaxFieldSize(int max) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getMaxRows() throws SQLException {
        return this.resultSetMaxRows;
    }

    @Override
    public void setMaxRows(int max) throws SQLException {
        if (max <= 0) {
            throw new SQLException("max must be greater than 0");
        }
        this.resultSetMaxRows = max;
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.queryTimeout = seconds;
    }

    @Override
    public void cancel() throws SQLException {
        block5: {
            this.connHandle.log.debug("execute cancel");
            if (this.jobId != null) {
                try {
                    DliClient v3DliClient = V3ClientUtils.getDliClient((DLIInfo)this.connHandle.getConnRes().toDliInfo());
                    CancelSqlJobResponse resp = v3DliClient.cancelSqlJob(new CancelSqlJobRequest().withJobId(this.jobId));
                    if (resp.getIsSuccess().booleanValue()) {
                        this.connHandle.log.warn(String.format("the job : %s is cancelled because of execution timeout.", this.jobId));
                        break block5;
                    }
                    this.connHandle.log.warn(String.format("the job : %s is cancel failed, %s.", this.jobId, resp.getMessage()));
                }
                catch (Exception e) {
                    this.connHandle.log.error(String.format("Cancel failed, %s", e.getMessage()));
                }
            } else {
                this.connHandle.log.debug("jobId is null");
            }
        }
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warning;
    }

    @Override
    public void clearWarnings() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setCursorName(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    public String getCurrentDatabase() {
        String db = this.annotationConf.get("dli.sql.current.database");
        if (db != null && !db.isEmpty()) {
            return db;
        }
        db = this.connHandle.getSessConfMap().get("dli.sql.current.database");
        if (db != null && !db.isEmpty()) {
            return db;
        }
        return this.connHandle.getConnRes().getDatabaseName();
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.connHandle.log.debug("Run SQL: " + sql);
        ExecuteTask task = new ExecuteTask(sql);
        CompletableFuture<Void> future = null;
        try {
            int timeOut = this.getQueryTimeout() > 0 ? this.getQueryTimeout() : Integer.MAX_VALUE;
            future = CompletableFuture.runAsync(task, ExecutorUtils.sqlSubmitExecutor(this.connHandle.getConnRes().getSqlSubmitThreadNum()));
            future.get(timeOut, TimeUnit.SECONDS);
            if (task.executeResult.exception == null) {
                return task.executeResult.hasResultSet;
            }
            throw task.executeResult.exception;
        }
        catch (InterruptedException e) {
            throw new DliException("The sql request is interrupt", ErrorCode.JDBC_SYSTEM_ERROR.toString());
        }
        catch (TimeoutException e) {
            if (future != null) {
                boolean cancel = future.cancel(true);
                this.connHandle.log.info("Sql cancel result: " + cancel);
            }
            throw new DliException("The sql request is timeout", ErrorCode.JDBC_DLI_TIMEOUT_ERROR.toString());
        }
        catch (ExecutionException e) {
            this.connHandle.log.error("Run SQL ExecutionException ", (Throwable)e);
            throw new DliException("The sql request is execute failed", ErrorCode.JDBC_SYSTEM_ERROR.toString());
        }
    }

    public Map<String, String> getAnnotationConf() {
        return this.annotationConf;
    }

    protected ResultSet directResult(String db, String sql) {
        return null;
    }

    private void processSetConfInSql(String sql) throws SQLException {
        if (!sql.contains("@set".toUpperCase(Locale.ENGLISH)) && !sql.contains("@set")) {
            return;
        }
        ArrayList<String> lines = new ArrayList<String>(Arrays.asList(sql.split("\\r|\\n|\\r\\n")));
        if (lines.size() == 1) {
            return;
        }
        this.annotationConf.putAll(this.parseSetConfInSql(lines));
    }

    private Map<String, String> parseSetConfInSql(List<String> sqlLines) {
        HashMap<String, String> conf = new HashMap<String, String>();
        for (String item : sqlLines) {
            String[] keyValues;
            String keyValueStr;
            String setSql = item.trim().replace("\\t", "").replace(";", "");
            if (setSql.isEmpty() || !setSql.startsWith("--") || setSql.equals(keyValueStr = setSql.replaceAll("(?i)^--\\s{0,10}@set\\s{1,10}([A-Za-z0-9_\\.\\-]{1,256}?)\\s{0,10}=\\s{0,10}([\\s\\S]{1,256})$", "$1,$2")) || this.processSpecialKeys((keyValues = keyValueStr.split(","))[0].trim(), keyValues[1].trim())) continue;
            conf.put(keyValues[0].trim(), keyValues[1].trim());
        }
        return conf;
    }

    private boolean processSetClause(String sql) {
        if (SET_PATTERN.matcher(sql = Normalizer.normalize(sql, Normalizer.Form.NFKC)).matches()) {
            int i;
            String pairString;
            String[] pair;
            if (sql.contains(";")) {
                sql = sql.replace(';', ' ');
            }
            if ((pair = (pairString = sql.substring((i = sql.toLowerCase(Locale.US).indexOf("set")) + 3)).split("=")).length == 2) {
                String key = pair[0].trim();
                String value = this.getTrimedString(pair[1]);
                this.updateCount = 0L;
                if (this.validSqlConfKey(key)) {
                    this.connHandle.getSessConfMap().put(key, value);
                    this.connHandle.log.info("set statement property: " + key + "=" + value);
                } else if (key.equals("*") && value.toLowerCase(Locale.US).equals("null")) {
                    this.connHandle.getSessConfMap().clear();
                    this.connHandle.log.info("clear all the statement properties");
                } else {
                    this.connHandle.log.warn(String.format("the property name : '%s' should start with '%s'", key, "dli."));
                }
                return true;
            }
            return false;
        }
        return false;
    }

    private boolean validSqlConfKey(String key) {
        String lowerKey = key.toLowerCase(Locale.US);
        return lowerKey.startsWith("dli.") || lowerKey.startsWith("spark.");
    }

    private boolean processSpecialKeys(String key, String value) {
        if (key.equalsIgnoreCase("dli.result.line.num")) {
            this.connHandle.getConnRes().setResultDataLineNum(Integer.parseInt(value));
            return true;
        }
        return false;
    }

    private boolean processUseClause(String sql) throws SQLException {
        if (USE_PATTERN.matcher(sql = Normalizer.normalize(sql, Normalizer.Form.NFKC)).matches()) {
            int i;
            String databaseName;
            if (sql.contains(";")) {
                sql = sql.replace(';', ' ');
            }
            if ((databaseName = this.getTrimedString(sql.substring((i = sql.toLowerCase(Locale.US).indexOf("use")) + 3)).replace("`", "")).length() <= 0) {
                throw new DliException(String.format("database '%s' name can not be empty", databaseName), ErrorCode.JDBC_NO_SUCH_OBJECT_ERROR.toString());
            }
            this.connHandle.getConnRes().setDatabaseName(databaseName);
            this.connHandle.log.debug("set database to " + databaseName);
            this.updateCount = 0L;
            return true;
        }
        return false;
    }

    private String getTrimedString(String str) {
        String trimedStr = str.trim();
        if (trimedStr.startsWith("'")) {
            trimedStr = trimedStr.substring(1);
        }
        if (trimedStr.endsWith("'")) {
            trimedStr = trimedStr.substring(0, trimedStr.lastIndexOf("'"));
        }
        return trimedStr;
    }

    private void initResultSet(SQLJob sqlJob) throws SQLException {
        long expectNum = this.getExpectResultNum(sqlJob.getResultCount());
        this.resultSet = this.initResultSet(sqlJob, expectNum);
    }

    private long getExpectResultNum(long resultCount) {
        long expectNum = this.connHandle.getConnRes().getResultDataLineNum() <= 0 ? resultCount : Math.min((long)this.connHandle.getConnRes().getResultDataLineNum(), resultCount);
        return this.resultSetMaxRows > 0 ? Math.min((long)this.resultSetMaxRows, expectNum) : expectNum;
    }

    protected DliForwardResultSet initResultSet(SQLJob sqlJob, long expectNum) throws SQLException {
        return new DliForwardResultSet(this, sqlJob, expectNum);
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        return this.resultSet;
    }

    @Override
    public synchronized int getUpdateCount() throws SQLException {
        this.checkClosed();
        return (int)this.updateCount;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getFetchDirection() throws SQLException {
        return 1000;
    }

    @Override
    public void setFetchSize(int rows) throws SQLException {
        this.connHandle.log.warn("setFetchSize unsupported");
    }

    @Override
    public int getFetchSize() throws SQLException {
        return 0;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetType() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void clearBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int[] executeBatch() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public DliConnection getConnection() throws SQLException {
        this.checkClosed();
        return this.connHandle;
    }

    @Override
    public boolean getMoreResults(int current) throws SQLException {
        return false;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int executeUpdate(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean execute(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public void setPoolable(boolean poolable) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    private void beforeExecute() throws SQLException {
        if (this.resultSet != null) {
            this.resultSet.close();
            this.resultSet = null;
        }
        this.updateCount = -1L;
        this.isClosed = false;
    }

    protected void checkClosed() throws SQLException {
        if (this.isClosed) {
            throw new DliException("The statement has been closed", ErrorCode.JDBC_CONNECTION_ALREADY_CLOSED_ERROR.toString());
        }
    }

    class ExecuteTask
    implements Runnable {
        ExecuteResult executeResult;
        String sql;

        ExecuteTask(String sql) {
            this.executeResult = new ExecuteResult();
            this.sql = sql;
        }

        @Override
        public void run() {
            try {
                DliStatement.this.checkClosed();
                DliStatement.this.beforeExecute();
                if (DliStatement.this.processSetClause(this.sql)) {
                    this.executeResult.hasResultSet = false;
                    return;
                }
                if (DliStatement.this.processUseClause(this.sql)) {
                    this.executeResult.hasResultSet = false;
                    return;
                }
                DliStatement.this.processSetConfInSql(this.sql);
                ResultSet directResult = DliStatement.this.directResult(DliStatement.this.getCurrentDatabase(), this.sql);
                if (directResult != null) {
                    ((DliStatement)DliStatement.this).connHandle.log.debug("Directory fetch this query sql result");
                    this.executeResult.hasResultSet = true;
                    DliStatement.this.resultSet = directResult;
                    return;
                }
                ((DliStatement)DliStatement.this).connHandle.log.debug("submit sql request to DLI rest service.");
                DLIInfo dliInfo = DliStatement.this.connHandle.getConnRes().toDliInfo();
                SQLJob sqlJob = new SQLJob(dliInfo, DliStatement.this.getCurrentDatabase(), this.sql);
                sqlJob.setJobTimeout(DliStatement.this.connHandle.getConnRes().getJobTimeoutSeconds());
                HashMap<String, String> confMap = new HashMap<String, String>();
                confMap.putAll(DliStatement.this.connHandle.getSessConfMap());
                confMap.putAll(DliStatement.this.annotationConf);
                sqlJob.setConf(Collections.singletonList(confMap));
                sqlJob.setEngineType(DliStatement.this.connHandle.getConnRes().getEngineType());
                sqlJob.setCatalog(DliStatement.this.connHandle.getConnRes().getCatalog());
                sqlJob.submit();
                DliStatement.this.jobId = sqlJob.getJobId();
                if (SqlUtils.isQuery(sqlJob.getJobType().name(), this.sql)) {
                    DliStatement.this.initResultSet(sqlJob);
                    this.executeResult.hasResultSet = true;
                    DliStatement.this.updateCount = sqlJob.getResultCount();
                } else {
                    this.executeResult.hasResultSet = false;
                }
            }
            catch (Exception e) {
                ((DliStatement)DliStatement.this).connHandle.log.error(String.format("Fail to run sql: %s, %s", this.sql, e.getMessage()), (Throwable)e);
                DliStatement.this.jobId = null;
                this.executeResult.exception = new SQLException(e.getMessage());
            }
        }
    }

    private class ExecuteResult {
        public boolean hasResultSet;
        public SQLException exception;

        private ExecuteResult() {
        }
    }
}

