/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.jdbc;

import com.huawei.dli.jdbc.DliConnection;
import com.huawei.dli.jdbc.DliResultSet;
import com.huawei.dli.jdbc.DliResultSetMetaData;
import com.huawei.dli.jdbc.DliStatement;
import com.huawei.dli.sdk.meta.types.Column;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;

public class DliStaticResultSet
extends DliResultSet {
    private Iterator<Object[]> iterator;
    Object[] row;
    private final boolean isEmptyResultSet;

    public DliStaticResultSet(DliConnection conn, DliResultSetMetaData meta) throws SQLException {
        super(conn, null, meta);
        this.isEmptyResultSet = true;
    }

    public DliStaticResultSet(DliConnection conn, DliResultSetMetaData meta, Iterator<Object[]> iter) throws SQLException {
        super(conn, null, meta);
        this.iterator = iter;
        this.isEmptyResultSet = false;
    }

    public DliStaticResultSet(DliStatement statement, List<Column> resultSchema, Iterator<Object[]> iter) throws SQLException {
        super(statement.getConnection(), statement, new DliResultSetMetaData(resultSchema));
        this.iterator = iter;
        this.isEmptyResultSet = false;
    }

    @Override
    protected Object[] rowAtCursor() throws SQLException {
        return this.row;
    }

    @Override
    public boolean next() throws SQLException {
        if (this.isEmptyResultSet) {
            return false;
        }
        if (this.iterator.hasNext()) {
            this.row = this.iterator.next();
            return true;
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        this.iterator = null;
    }
}

