/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.jdbc.model;

import java.util.ArrayList;
import java.util.Arrays;

public enum EnumSqlJobType {
    IMPORT("IMPORT"),
    EXPORT("EXPORT"),
    QUERY("QUERY"),
    INSERT("INSERT"),
    SQL_IMPORT("SQL_IMPORT"),
    SQL_EXPORT("SQL_EXPORT"),
    SQL_QUERY("SQL_QUERY"),
    SQL_INSERT("SQL_INSERT"),
    ANALYZE("ANALYZE"),
    UPDATE("UPDATE"),
    DELETE("DELETE"),
    LIFECYCLE_CLEAN("LIFECYCLE_CLEAN");

    private String key;

    private EnumSqlJobType(String key) {
        this.key = key;
    }

    public static EnumSqlJobType of(String sqlType) {
        return Arrays.stream(EnumSqlJobType.values()).filter(p -> p.key.equalsIgnoreCase(sqlType)).findFirst().orElse(null);
    }

    public static boolean isInHasResultType(String sqlType) {
        EnumSqlJobType type = EnumSqlJobType.of(sqlType);
        ArrayList<EnumSqlJobType> types = new ArrayList<EnumSqlJobType>();
        types.add(QUERY);
        types.add(SQL_QUERY);
        return types.contains((Object)type);
    }

    public static boolean isInNoResultType(String sqlType) {
        EnumSqlJobType type = EnumSqlJobType.of(sqlType);
        ArrayList<EnumSqlJobType> types = new ArrayList<EnumSqlJobType>();
        types.add(IMPORT);
        types.add(EXPORT);
        types.add(INSERT);
        types.add(SQL_IMPORT);
        types.add(SQL_EXPORT);
        types.add(SQL_INSERT);
        types.add(ANALYZE);
        types.add(UPDATE);
        types.add(DELETE);
        types.add(LIFECYCLE_CLEAN);
        return types.contains((Object)type);
    }
}

