/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.jdbc.utils;

import com.huawei.dli.jdbc.model.DliException;
import com.huawei.dli.jdbc.utils.ErrorCode;
import com.huawei.dli.sdk.common.DLIInfo;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ConnectionResource {
    private static final Pattern KEY_VALUE_REG = Pattern.compile("([^;]*)=([^;]*)[;]?");
    public static final String ACCESS_KEY_PROP_KEY = "accesskey";
    public static final String SECRET_KEY_PROP_KEY = "secretkey";
    public static final String REGION_NAME_PROP_KEY = "regionname";
    public static final String QUEUE_NAME_PROP_KEY = "queuename";
    public static final String ENGINE_TYPE_PROP_KEY = "enginetype";
    public static final String DATABASE_NAME_PROP_KEY = "databasename";
    public static final String SQL_CURRENT_DATABASE_KEY = "dli.sql.current.database";
    public static final String MONITOR_PERIOD_PROP_KEY = "monitorperiod";
    public static final String JOB_TIMEOUT_PROP_KEY = "jobtimeout";
    public static final String PROJECT_ID_PROP_KEY = "projectid";
    public static final String TOKEN_PROP_KEY = "token";
    public static final String LOGCONFFILE_PROP_KEY = "logconffile";
    public static final String CHARSET_PROP_KEY = "charset";
    public static final String DLI_CONF_PREFIX = "dli.";
    public static final String CATALOG = "catalog";
    public static final String SPAKR_CONF_PREFIX = "spark.";
    public static final String CHECK_NO_RESULT_QUERY = "dli.sql.checkNoResultQuery";
    public static final String OBS_ENDPOINT_KEY = "obs.endpoint";
    public static final String OBS_RETRY_INTERVAL = "dli.obs.read.retry.interval.second";
    public static final String LAKEFORMATION_ENDPOINT_KEY = "lakeformation.endpoint";
    public static final String GET_ONE_OBS_RESULT_THREAD_NUM_KEY = "dli.obs.one.result.thread.num";
    public static final String GET_OBS_RESULT_TOTAL_THREAD_NUM_KEY = "dli.obs.result.total.thread.num";
    public static final String SQL_SUBMIT_THREAD_NUM_KEY = "dli.sql.submit.thread.num";
    public static final String RESULT_DATA_LINE_NUM_KEY = "dli.result.line.num";
    public static final String ONE_SQL_RESULT_CACHE_CAPACITY_KEY = "dli.result.queue.cache.capacity";
    public static final String PROXY_HOST = "dli.proxy.host";
    public static final String PROXY_PORT = "dli.proxy.port";
    public static final String PROXY_USER = "dli.proxy.user";
    public static final String PROXY_PASSWORD = "dli.proxy.password";
    public static final String CSV_READ_MAX_COLUMN_NUM = "dli.max.column.num";
    public static final String DLI_PARTITION_TABLE_FORCE_FILTER_KEY = "spark.sql.forcePartitionPredicatesOnPartitionedTable.enabled";
    public static final String DLI_SMALL_MERGE_KEY = "spark.sql.mergeSmallFiles.enabled";
    public static final String DLI_BOOL_TYPE_TO_INT_KEY = "dli.boolean.type.return.int";
    public static final String DLI_DECIMAL_TYPE_TO_STRING_KEY = "dli.decimal.type.return.string";
    public static final String DLI_DATE_TYPE_TO_STRING_KEY = "dli.date.type.return.string";
    private static final String JDBC_LUXOR_URL_PREFIX = "jdbc:luxor://";
    private static final String JDBC_UQUERY_URL_PREFIX = "jdbc:uquery://";
    private static final String JDBC_DLI_URL_PREFIX = "jdbc:dli://";
    public static final long MONITOR_PERIOD_SECOND = 1L;
    public static final long JOB_TIMEOUT_SECOND = 300L;
    public static final String SERVICE_VERSION = "v1.0";
    public static final String CHARSET_DEFAULT_VALUE = "UTF-8";
    public static final int RESULT_SET_BUFFER_SIZE = 1000;
    private String ak;
    private String sk;
    private String regionName;
    private String host;
    private int port = -1;
    private String queueName;
    private String engineType;
    private String databaseName;
    private String catalog;
    private String projectId;
    private String logConfFile;
    private long monitorPeriod = 1L;
    private long jobTimeoutSeconds = 300L;
    private String charSet = "UTF-8";
    private boolean checkNoResultQuery = false;
    private String obsEndpoint;
    private int obsRetryInterval;
    private String lakeformationEndpoint;
    private int oneObsResultThreads = 8;
    private int obsResultTotalThreads = 24;
    private int sqlSubmitThreadNum = 8;
    private int resultDataLineNum = -1;
    private int oneSqlQueuesCacheCapacity = 500000;
    private boolean boolTypeToInt = false;
    private boolean decimalTypeToString = false;
    private boolean dateTypeToString = false;
    private String proxyHost;
    private int proxyPort = 80;
    private String userName;
    private String password;
    private String token;
    private int maxColumnNum;

    public String getObsEndpoint() {
        if (this.obsEndpoint == null || this.obsEndpoint.isEmpty()) {
            return String.format("obs.%s.myhuaweicloud.com", this.regionName);
        }
        return this.obsEndpoint;
    }

    public String getLakeformationEndpoint() {
        if (this.lakeformationEndpoint == null || this.lakeformationEndpoint.isEmpty()) {
            return String.format("lakeformation.%s.myhuaweicloud.com", this.regionName);
        }
        return this.lakeformationEndpoint;
    }

    public static boolean acceptURL(String url) {
        return url != null && (url.startsWith(JDBC_UQUERY_URL_PREFIX) || url.startsWith(JDBC_LUXOR_URL_PREFIX) || url.startsWith(JDBC_DLI_URL_PREFIX));
    }

    public static boolean isCharsetName(String charsetName) {
        SortedMap<String, Charset> charsets = Charset.availableCharsets();
        for (Map.Entry<String, Charset> setEntry : charsets.entrySet()) {
            if (!setEntry.getKey().equals(charsetName) && !setEntry.getValue().aliases().contains(charsetName)) continue;
            return true;
        }
        return false;
    }

    public String getEndpoint() {
        return this.port == -1 ? this.host : this.host + ":" + this.port;
    }

    public static ConnectionResource constructConnectionResource(Properties info, String url) throws DliException {
        ConnectionResource connectionResource = ConnectionResource.extractParamsFromUrl(url);
        if (info != null) {
            connectionResource.loadPropertiesFromConf(info);
        }
        connectionResource.validateParameters();
        return connectionResource;
    }

    public static ConnectionResource extractParamsFromUrl(String url) throws DliException {
        URI jdbcURI;
        ConnectionResource connectionResource = new ConnectionResource();
        if (!ConnectionResource.acceptURL(url)) {
            throw new DliException("Bad URL format: Missing prefix jdbc:uquery://", ErrorCode.JDBC_URL_PARSE_ERROR.toString());
        }
        String uriSchema = "schema://";
        int prefixLength = url.startsWith(JDBC_LUXOR_URL_PREFIX) ? JDBC_LUXOR_URL_PREFIX.length() : (url.startsWith(JDBC_UQUERY_URL_PREFIX) ? JDBC_UQUERY_URL_PREFIX.length() : JDBC_DLI_URL_PREFIX.length());
        String uriFromUrl = url.substring(prefixLength);
        try {
            jdbcURI = URI.create(uriSchema + uriFromUrl);
        }
        catch (IllegalArgumentException ex) {
            throw new DliException(String.format("'%s' should follow the URI 'RFC 2396' standard", uriFromUrl), ErrorCode.JDBC_URL_PARSE_ERROR.toString());
        }
        connectionResource.setHost(jdbcURI.getHost());
        connectionResource.setPort(jdbcURI.getPort());
        String uriPath = jdbcURI.getPath();
        if (uriPath != null && !uriPath.isEmpty()) {
            uriPath = uriPath.substring(1);
            connectionResource.setProjectId(uriPath);
        }
        LinkedHashMap<String, String> parameters = new LinkedHashMap<String, String>();
        String confListStr = jdbcURI.getQuery();
        if (confListStr != null) {
            Matcher confMatcher = KEY_VALUE_REG.matcher(confListStr);
            while (confMatcher.find()) {
                if (parameters.put(confMatcher.group(1), confMatcher.group(2)) == null) continue;
                throw new DliException("Bad URL format: Multiple values for property " + confMatcher.group(1), ErrorCode.JDBC_URL_PARSE_ERROR.toString());
            }
        }
        connectionResource.loadPropertiesFromConf(parameters);
        return connectionResource;
    }

    public void loadPropertiesFromConf(Map map) throws DliException {
        if (this.projectId == null && map.get(PROJECT_ID_PROP_KEY) != null) {
            this.setProjectId((String)map.get(PROJECT_ID_PROP_KEY));
        }
        if (map.get(ACCESS_KEY_PROP_KEY) != null) {
            this.setAk((String)map.get(ACCESS_KEY_PROP_KEY));
        }
        if (map.get(SECRET_KEY_PROP_KEY) != null) {
            this.setSk((String)map.get(SECRET_KEY_PROP_KEY));
        }
        if (map.get(REGION_NAME_PROP_KEY) != null) {
            this.setRegionName((String)map.get(REGION_NAME_PROP_KEY));
        }
        if (map.get(QUEUE_NAME_PROP_KEY) != null) {
            this.setQueueName((String)map.get(QUEUE_NAME_PROP_KEY));
        }
        if (map.get(ENGINE_TYPE_PROP_KEY) != null) {
            this.setEngineType((String)map.get(ENGINE_TYPE_PROP_KEY));
        }
        if (map.get(DATABASE_NAME_PROP_KEY) != null) {
            this.setDatabaseName((String)map.get(DATABASE_NAME_PROP_KEY));
        }
        if (map.get(SQL_CURRENT_DATABASE_KEY) != null) {
            this.setDatabaseName((String)map.get(SQL_CURRENT_DATABASE_KEY));
        }
        if (map.get(MONITOR_PERIOD_PROP_KEY) != null) {
            try {
                long period = Long.parseLong((String)map.get(MONITOR_PERIOD_PROP_KEY));
                if (period <= 0L) {
                    throw new DliException(String.format("%s can only be an integer greater than 0", MONITOR_PERIOD_PROP_KEY), ErrorCode.JDBC_URL_PARSE_ERROR.toString());
                }
                this.setMonitorPeriod(period);
            }
            catch (NumberFormatException ex) {
                throw new DliException(String.format("%s can only be an integer greater than 0", MONITOR_PERIOD_PROP_KEY), ErrorCode.JDBC_URL_PARSE_ERROR.toString());
            }
        }
        if (map.get(JOB_TIMEOUT_PROP_KEY) != null) {
            try {
                long jobTimeOut = Long.parseLong((String)map.get(JOB_TIMEOUT_PROP_KEY));
                if (jobTimeOut <= 0L) {
                    throw new DliException(String.format("%s can only be an integer greater than 0", JOB_TIMEOUT_PROP_KEY), ErrorCode.JDBC_URL_PARSE_ERROR.toString());
                }
                this.setJobTimeoutSeconds(jobTimeOut);
            }
            catch (NumberFormatException ex) {
                throw new DliException(String.format("%s can only be an integer greater than 0", JOB_TIMEOUT_PROP_KEY), ErrorCode.JDBC_URL_PARSE_ERROR.toString());
            }
        }
        if (map.get(LOGCONFFILE_PROP_KEY) != null) {
            this.setLogConfFile((String)map.get(LOGCONFFILE_PROP_KEY));
        }
        if (map.get(CHARSET_PROP_KEY) != null) {
            String charset = (String)map.get(CHARSET_PROP_KEY);
            if (ConnectionResource.isCharsetName(charset)) {
                this.setCharSet(charset);
            } else {
                throw new DliException(String.format("The charset '%s' is not supported!", charset), ErrorCode.JDBC_URL_PARSE_ERROR.toString());
            }
        }
        if (map.get(TOKEN_PROP_KEY) != null) {
            this.setToken((String)map.get(TOKEN_PROP_KEY));
        }
        if (map.get(CHECK_NO_RESULT_QUERY) != null) {
            this.setCheckNoResultQuery(Boolean.parseBoolean((String)map.get(CHECK_NO_RESULT_QUERY)));
        }
        if (map.get(OBS_ENDPOINT_KEY) != null) {
            this.obsEndpoint = (String)map.get(OBS_ENDPOINT_KEY);
        }
        if (map.get(OBS_RETRY_INTERVAL) != null) {
            this.obsRetryInterval = Integer.parseInt((String)map.get(OBS_RETRY_INTERVAL));
        }
        if (map.get(LAKEFORMATION_ENDPOINT_KEY) != null) {
            this.lakeformationEndpoint = (String)map.get(LAKEFORMATION_ENDPOINT_KEY);
        }
        if (map.get(GET_ONE_OBS_RESULT_THREAD_NUM_KEY) != null) {
            this.oneObsResultThreads = Integer.parseInt((String)map.get(GET_ONE_OBS_RESULT_THREAD_NUM_KEY));
        }
        if (map.get(GET_OBS_RESULT_TOTAL_THREAD_NUM_KEY) != null) {
            this.obsResultTotalThreads = Integer.parseInt((String)map.get(GET_OBS_RESULT_TOTAL_THREAD_NUM_KEY));
        }
        if (map.get(SQL_SUBMIT_THREAD_NUM_KEY) != null) {
            this.sqlSubmitThreadNum = Integer.parseInt((String)map.get(SQL_SUBMIT_THREAD_NUM_KEY));
        }
        if (map.get(ONE_SQL_RESULT_CACHE_CAPACITY_KEY) != null) {
            this.oneSqlQueuesCacheCapacity = Integer.parseInt((String)map.get(ONE_SQL_RESULT_CACHE_CAPACITY_KEY));
            if (this.oneSqlQueuesCacheCapacity <= 0) {
                this.oneSqlQueuesCacheCapacity = Integer.MAX_VALUE;
            }
        }
        if (map.get(RESULT_DATA_LINE_NUM_KEY) != null) {
            this.resultDataLineNum = Integer.parseInt((String)map.get(RESULT_DATA_LINE_NUM_KEY));
        }
        if (map.get(DLI_BOOL_TYPE_TO_INT_KEY) != null) {
            this.boolTypeToInt = Boolean.parseBoolean((String)map.get(DLI_BOOL_TYPE_TO_INT_KEY));
        }
        if (map.get(DLI_DECIMAL_TYPE_TO_STRING_KEY) != null) {
            this.decimalTypeToString = Boolean.parseBoolean((String)map.get(DLI_DECIMAL_TYPE_TO_STRING_KEY));
        }
        if (map.get(DLI_DATE_TYPE_TO_STRING_KEY) != null) {
            this.dateTypeToString = Boolean.parseBoolean((String)map.get(DLI_DATE_TYPE_TO_STRING_KEY));
        }
        if (map.get(CATALOG) != null) {
            this.catalog = (String)map.get(CATALOG);
        }
        if (map.get(PROXY_HOST) != null) {
            this.proxyHost = (String)map.get(PROXY_HOST);
        }
        if (map.get(PROXY_PORT) != null) {
            this.proxyPort = Integer.valueOf((String)map.get(PROXY_PORT));
        }
        if (map.get(PROXY_USER) != null) {
            this.userName = (String)map.get(PROXY_USER);
        }
        if (map.get(PROXY_PASSWORD) != null) {
            this.password = (String)map.get(PROXY_PASSWORD);
        }
        if (map.get(CSV_READ_MAX_COLUMN_NUM) != null) {
            this.maxColumnNum = Integer.parseInt((String)map.get(CSV_READ_MAX_COLUMN_NUM));
        }
    }

    private void validateParameters() throws DliException {
        String errorMsg = "The configuration item '%s' must be set in AK/SK authentication mode";
        if (this.ak == null || this.ak.isEmpty()) {
            throw new DliException(String.format(errorMsg, ACCESS_KEY_PROP_KEY), ErrorCode.JDBC_URL_PARSE_ERROR.toString());
        }
        if (this.sk == null || this.sk.isEmpty()) {
            throw new DliException(String.format(errorMsg, SECRET_KEY_PROP_KEY), ErrorCode.JDBC_URL_PARSE_ERROR.toString());
        }
        if (this.regionName == null || this.regionName.isEmpty()) {
            throw new DliException(String.format(errorMsg, REGION_NAME_PROP_KEY), ErrorCode.JDBC_URL_PARSE_ERROR.toString());
        }
        if (this.projectId == null || this.projectId.isEmpty()) {
            throw new DliException(String.format("%s must be set", PROJECT_ID_PROP_KEY), ErrorCode.JDBC_URL_PARSE_ERROR.toString());
        }
        if (this.queueName == null || this.queueName.isEmpty()) {
            throw new DliException(String.format("%s name must be set", QUEUE_NAME_PROP_KEY), ErrorCode.JDBC_URL_PARSE_ERROR.toString());
        }
    }

    public DLIInfo toDliInfo() {
        DLIInfo dliInfo = new DLIInfo(this.getRegionName(), this.getAk(), this.getSk(), this.getProjectId());
        dliInfo.setDliEndpoint(this.getEndpoint());
        dliInfo.setLfEndpoint(this.getLakeformationEndpoint());
        dliInfo.setObsEndpoint(this.getObsEndpoint());
        dliInfo.setQueueName(this.getQueueName());
        dliInfo.setProxyHost(this.getProxyHost());
        dliInfo.setProxyPort(this.getProxyPort());
        dliInfo.setProxyUser(this.getUserName());
        dliInfo.setProxyPwd(this.getPassword());
        dliInfo.setUseRetry(true);
        dliInfo.setUseCacheReader(true);
        return dliInfo;
    }

    public String getAk() {
        return this.ak;
    }

    public String getSk() {
        return this.sk;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public String getEngineType() {
        return this.engineType;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getLogConfFile() {
        return this.logConfFile;
    }

    public long getMonitorPeriod() {
        return this.monitorPeriod;
    }

    public long getJobTimeoutSeconds() {
        return this.jobTimeoutSeconds;
    }

    public String getCharSet() {
        return this.charSet;
    }

    public boolean isCheckNoResultQuery() {
        return this.checkNoResultQuery;
    }

    public int getObsRetryInterval() {
        return this.obsRetryInterval;
    }

    public int getOneObsResultThreads() {
        return this.oneObsResultThreads;
    }

    public int getObsResultTotalThreads() {
        return this.obsResultTotalThreads;
    }

    public int getSqlSubmitThreadNum() {
        return this.sqlSubmitThreadNum;
    }

    public int getResultDataLineNum() {
        return this.resultDataLineNum;
    }

    public int getOneSqlQueuesCacheCapacity() {
        return this.oneSqlQueuesCacheCapacity;
    }

    public boolean isBoolTypeToInt() {
        return this.boolTypeToInt;
    }

    public boolean isDecimalTypeToString() {
        return this.decimalTypeToString;
    }

    public boolean isDateTypeToString() {
        return this.dateTypeToString;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getToken() {
        return this.token;
    }

    public int getMaxColumnNum() {
        return this.maxColumnNum;
    }

    public void setAk(String ak) {
        this.ak = ak;
    }

    public void setSk(String sk) {
        this.sk = sk;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setLogConfFile(String logConfFile) {
        this.logConfFile = logConfFile;
    }

    public void setMonitorPeriod(long monitorPeriod) {
        this.monitorPeriod = monitorPeriod;
    }

    public void setJobTimeoutSeconds(long jobTimeoutSeconds) {
        this.jobTimeoutSeconds = jobTimeoutSeconds;
    }

    public void setCharSet(String charSet) {
        this.charSet = charSet;
    }

    public void setCheckNoResultQuery(boolean checkNoResultQuery) {
        this.checkNoResultQuery = checkNoResultQuery;
    }

    public void setObsEndpoint(String obsEndpoint) {
        this.obsEndpoint = obsEndpoint;
    }

    public void setObsRetryInterval(int obsRetryInterval) {
        this.obsRetryInterval = obsRetryInterval;
    }

    public void setLakeformationEndpoint(String lakeformationEndpoint) {
        this.lakeformationEndpoint = lakeformationEndpoint;
    }

    public void setOneObsResultThreads(int oneObsResultThreads) {
        this.oneObsResultThreads = oneObsResultThreads;
    }

    public void setObsResultTotalThreads(int obsResultTotalThreads) {
        this.obsResultTotalThreads = obsResultTotalThreads;
    }

    public void setSqlSubmitThreadNum(int sqlSubmitThreadNum) {
        this.sqlSubmitThreadNum = sqlSubmitThreadNum;
    }

    public void setResultDataLineNum(int resultDataLineNum) {
        this.resultDataLineNum = resultDataLineNum;
    }

    public void setOneSqlQueuesCacheCapacity(int oneSqlQueuesCacheCapacity) {
        this.oneSqlQueuesCacheCapacity = oneSqlQueuesCacheCapacity;
    }

    public void setBoolTypeToInt(boolean boolTypeToInt) {
        this.boolTypeToInt = boolTypeToInt;
    }

    public void setDecimalTypeToString(boolean decimalTypeToString) {
        this.decimalTypeToString = decimalTypeToString;
    }

    public void setDateTypeToString(boolean dateTypeToString) {
        this.dateTypeToString = dateTypeToString;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public void setMaxColumnNum(int maxColumnNum) {
        this.maxColumnNum = maxColumnNum;
    }
}

