/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.jdbc.utils;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class ExecutorUtils {
    private static volatile ExecutorService sqlSubmitExecutor = null;
    private static final Object SQL_SUBMIT_LOCKER = new Object();

    private ExecutorUtils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExecutorService sqlSubmitExecutor(int threadNum) {
        if (sqlSubmitExecutor != null) {
            return sqlSubmitExecutor;
        }
        Object object = SQL_SUBMIT_LOCKER;
        synchronized (object) {
            if (sqlSubmitExecutor != null) {
                return sqlSubmitExecutor;
            }
            sqlSubmitExecutor = Executors.newFixedThreadPool(threadNum, new ThreadFactory(){
                private final AtomicInteger threadNum = new AtomicInteger(0);

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r);
                    thread.setDaemon(true);
                    thread.setName("SqlSubmitThread_" + this.threadNum.getAndIncrement());
                    return thread;
                }
            });
        }
        return sqlSubmitExecutor;
    }
}

