/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.jdbc.utils.type;

import com.huawei.dli.jdbc.model.DliException;
import com.huawei.dli.sdk.meta.types.DataType;
import com.huawei.dli.sdk.meta.types.DecimalType;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;

public enum DliType {
    BOOLEAN{

        @Override
        public Class<?> getSqlTypeClass() {
            return Boolean.class;
        }

        @Override
        public int getSqlType() {
            return 16;
        }

        @Override
        public int precision(DataType dataType) {
            return 5;
        }
    }
    ,
    TINYINT{

        @Override
        public Class<?> getSqlTypeClass() {
            return Byte.class;
        }

        @Override
        public int getSqlType() {
            return -6;
        }

        @Override
        public boolean signed() {
            return true;
        }

        @Override
        public int precision(DataType dataType) {
            return 3;
        }

        @Override
        public int displaySize(DataType dataType) {
            return 4;
        }
    }
    ,
    BYTE{

        @Override
        public Class<?> getSqlTypeClass() {
            return Byte.class;
        }

        @Override
        public int getSqlType() {
            return -6;
        }

        @Override
        public boolean signed() {
            return true;
        }

        @Override
        public int precision(DataType dataType) {
            return 3;
        }

        @Override
        public int displaySize(DataType dataType) {
            return 4;
        }
    }
    ,
    SMALLINT{

        @Override
        public Class<?> getSqlTypeClass() {
            return Short.class;
        }

        @Override
        public int getSqlType() {
            return 5;
        }

        @Override
        public boolean signed() {
            return true;
        }

        @Override
        public int precision(DataType dataType) {
            return 5;
        }

        @Override
        public int displaySize(DataType dataType) {
            return 6;
        }
    }
    ,
    SHORT{

        @Override
        public Class<?> getSqlTypeClass() {
            return Short.class;
        }

        @Override
        public int getSqlType() {
            return 5;
        }

        @Override
        public boolean signed() {
            return true;
        }

        @Override
        public int precision(DataType dataType) {
            return 5;
        }

        @Override
        public int displaySize(DataType dataType) {
            return 6;
        }
    }
    ,
    INT{

        @Override
        public Class<?> getSqlTypeClass() {
            return Integer.class;
        }

        @Override
        public int getSqlType() {
            return 4;
        }

        @Override
        public boolean signed() {
            return true;
        }

        @Override
        public int precision(DataType dataType) {
            return 10;
        }

        @Override
        public int displaySize(DataType dataType) {
            return 11;
        }
    }
    ,
    INTEGER{

        @Override
        public Class<?> getSqlTypeClass() {
            return Integer.class;
        }

        @Override
        public int getSqlType() {
            return 4;
        }

        @Override
        public boolean signed() {
            return true;
        }

        @Override
        public int precision(DataType dataType) {
            return 10;
        }

        @Override
        public int displaySize(DataType dataType) {
            return 11;
        }
    }
    ,
    BIGINT{

        @Override
        public Class<?> getSqlTypeClass() {
            return Long.class;
        }

        @Override
        public int getSqlType() {
            return -5;
        }

        @Override
        public boolean signed() {
            return true;
        }

        @Override
        public int precision(DataType dataType) {
            return 19;
        }

        @Override
        public int displaySize(DataType dataType) {
            return 20;
        }
    }
    ,
    LONG{

        @Override
        public Class<?> getSqlTypeClass() {
            return Long.class;
        }

        @Override
        public int getSqlType() {
            return -5;
        }

        @Override
        public boolean signed() {
            return true;
        }

        @Override
        public int precision(DataType dataType) {
            return 19;
        }

        @Override
        public int displaySize(DataType dataType) {
            return 20;
        }
    }
    ,
    FLOAT{

        @Override
        public Class<?> getSqlTypeClass() {
            return Float.class;
        }

        @Override
        public int getSqlType() {
            return 6;
        }

        @Override
        public boolean signed() {
            return true;
        }

        @Override
        public int precision(DataType dataType) {
            return 7;
        }

        @Override
        public int scale(DataType dataType) {
            return 7;
        }

        @Override
        public int displaySize(DataType dataType) {
            return 24;
        }
    }
    ,
    REAL{

        @Override
        public Class<?> getSqlTypeClass() {
            return Float.class;
        }

        @Override
        public int getSqlType() {
            return 7;
        }

        @Override
        public boolean signed() {
            return true;
        }

        @Override
        public int precision(DataType dataType) {
            return 7;
        }

        @Override
        public int scale(DataType dataType) {
            return 7;
        }

        @Override
        public int displaySize(DataType dataType) {
            return 24;
        }
    }
    ,
    DOUBLE{

        @Override
        public Class<?> getSqlTypeClass() {
            return Double.class;
        }

        @Override
        public int getSqlType() {
            return 8;
        }

        @Override
        public boolean signed() {
            return true;
        }

        @Override
        public int precision(DataType dataType) {
            return 15;
        }

        @Override
        public int scale(DataType dataType) {
            return 15;
        }

        @Override
        public int displaySize(DataType dataType) {
            return 25;
        }
    }
    ,
    DECIMAL{

        @Override
        public Class<?> getSqlTypeClass() {
            return BigDecimal.class;
        }

        @Override
        public int getSqlType() {
            return 3;
        }

        @Override
        public boolean signed() {
            return true;
        }

        @Override
        public int precision(DataType dataType) {
            if (dataType instanceof DecimalType) {
                return ((DecimalType)dataType).getPrecision();
            }
            throw new SQLException("Invalid DLI decimal type");
        }

        @Override
        public int scale(DataType dataType) {
            if (dataType instanceof DecimalType) {
                return ((DecimalType)dataType).getScale();
            }
            throw new SQLException("Invalid DLI decimal type");
        }

        @Override
        public int displaySize(DataType dataType) {
            return this.precision(dataType) + 2;
        }
    }
    ,
    DATE{

        @Override
        public Class<?> getSqlTypeClass() {
            return Date.class;
        }

        @Override
        public int getSqlType() {
            return 91;
        }

        @Override
        public int precision(DataType dataType) {
            return 10;
        }
    }
    ,
    TIME{

        @Override
        public Class<?> getSqlTypeClass() {
            return Time.class;
        }

        @Override
        public int getSqlType() {
            return 92;
        }

        @Override
        public int precision(DataType dataType) {
            return 12;
        }
    }
    ,
    TIMESTAMP{

        @Override
        public Class<?> getSqlTypeClass() {
            return Timestamp.class;
        }

        @Override
        public int getSqlType() {
            return 93;
        }

        @Override
        public int precision(DataType dataType) {
            return 29;
        }

        @Override
        public int scale(DataType dataType) {
            return 9;
        }
    }
    ,
    STRING{

        @Override
        public int getSqlType() {
            return 12;
        }

        @Override
        public boolean caseSensitive() {
            return true;
        }
    }
    ,
    CHAR{

        @Override
        public int getSqlType() {
            return 1;
        }

        @Override
        public boolean caseSensitive() {
            return true;
        }
    }
    ,
    VARCHAR{

        @Override
        public int getSqlType() {
            return 12;
        }

        @Override
        public boolean caseSensitive() {
            return true;
        }
    }
    ,
    BINARY{

        @Override
        public Class<?> getSqlTypeClass() {
            return byte[].class;
        }

        @Override
        public int getSqlType() {
            return -2;
        }
    }
    ,
    ARRAY{

        @Override
        public int getSqlType() {
            return 2003;
        }
    }
    ,
    MAP{

        @Override
        public int getSqlType() {
            return 12;
        }

        @Override
        public boolean caseSensitive() {
            return true;
        }
    }
    ,
    STRUCT{

        @Override
        public int getSqlType() {
            return 2002;
        }
    }
    ,
    NULL{

        @Override
        public int getSqlType() {
            return 0;
        }

        @Override
        public int precision(DataType dataType) {
            return 0;
        }

        @Override
        public int displaySize(DataType dataType) {
            return 4;
        }
    };


    public static DliType of(String typeName) throws DliException {
        return DliType.of(typeName, true);
    }

    public static DliType of(String typeName, boolean notExistException) throws DliException {
        if (typeName == null || typeName.isEmpty()) {
            return null;
        }
        if ("void".equalsIgnoreCase(typeName)) {
            return NULL;
        }
        DliType v = Arrays.stream(DliType.values()).filter(p -> p.name().equalsIgnoreCase(typeName)).findFirst().orElse(null);
        if (v != null) {
            return v;
        }
        if (typeName.trim().matches("(?i)^char\\(\\d{1,10}\\)$")) {
            return CHAR;
        }
        if (typeName.trim().matches("(?i)^varchar\\(\\d{1,10}\\)$")) {
            return VARCHAR;
        }
        if (typeName.trim().matches("(?i)^decimal\\(\\d{1,2}(,\\d{1,2})?\\)$")) {
            return DECIMAL;
        }
        if (typeName.trim().matches("(?i)^(map|array|struct)<.+$")) {
            int complexIndex = typeName.indexOf("<");
            StringBuilder type = new StringBuilder(typeName);
            if (complexIndex > 0) {
                type.substring(0, complexIndex);
            }
            return Arrays.stream(DliType.values()).filter(p -> p.name().equalsIgnoreCase(complexIndex > 0 ? typeName.substring(0, complexIndex) : typeName)).findFirst().get();
        }
        if (notExistException) {
            throw new DliException("Invalid type name: " + typeName);
        }
        return null;
    }

    public abstract int getSqlType();

    public Class<?> getSqlTypeClass() {
        return String.class;
    }

    public int precision(DataType dataType) {
        return Integer.MAX_VALUE;
    }

    public int scale(DataType dataType) {
        return 0;
    }

    public boolean caseSensitive() {
        return false;
    }

    public boolean signed() {
        return false;
    }

    public int displaySize(DataType dataType) {
        return this.precision(dataType);
    }
}

