/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.jdbc.utils.type;

import com.huawei.dli.jdbc.utils.type.DliType;
import com.huawei.dli.jdbc.utils.type.TypeUtils;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.meta.types.DataType;
import com.huawei.dli.sdk.meta.types.StructType;
import com.huaweicloud.sdk.core.utils.JsonUtils;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Struct;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class SimpleStruct
implements Struct {
    protected StructType dataType;
    protected List<Object> values;
    protected Object objValue;

    public SimpleStruct(StructType dataType, Object obj) {
        if (dataType == null) {
            throw new IllegalArgumentException("Illegal arguments for struct object.");
        }
        this.dataType = dataType;
        this.objValue = obj;
    }

    private void parseStruct() throws SQLException {
        this.values = new ArrayList<Object>();
        if (this.objValue == null || this.objValue.toString().equalsIgnoreCase("null")) {
            this.values.add(null);
            return;
        }
        assert (this.objValue instanceof Map);
        Map objMap = (Map)this.objValue;
        for (Column field : this.dataType.getFields()) {
            Object fieldObj = objMap.get(field.getName());
            DataType fieldDataType = field.getType();
            if (fieldObj == null || fieldObj.toString().equalsIgnoreCase("null")) {
                this.values.add(null);
                continue;
            }
            this.values.add(TypeUtils.getField(fieldObj, fieldDataType));
        }
    }

    public String toString() {
        if (this.objValue == null) {
            return "";
        }
        if (this.objValue instanceof String) {
            return this.objValue.toString();
        }
        return JsonUtils.toJSON((Object)this.objValue);
    }

    @Override
    public String getSQLTypeName() throws SQLException {
        return DliType.STRUCT.name();
    }

    @Override
    public Object[] getAttributes() throws SQLException {
        if (this.values == null) {
            this.parseStruct();
        }
        return this.values.toArray();
    }

    @Override
    public Object[] getAttributes(Map<String, Class<?>> map) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }
}

