/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.jdbc.utils.type;

import com.huawei.dli.jdbc.utils.type.SimpleStruct;
import com.huawei.dli.sdk.meta.types.DataType;
import com.huawei.dli.sdk.meta.types.StructType;
import com.huawei.dli.sdk.util.DateFormatUtils;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;

public class TypeUtils {
    public static int getIntField(Object fieldObj) throws SQLException {
        try {
            if (fieldObj instanceof Number) {
                return ((Number)fieldObj).intValue();
            }
            if (fieldObj instanceof String) {
                return Integer.parseInt((String)fieldObj);
            }
            if (fieldObj == null) {
                return 0;
            }
            throw new SQLException("Illegal conversion");
        }
        catch (Exception e) {
            throw new SQLException("Cannot convert the field " + e.toString(), e);
        }
    }

    public static long getLongField(Object obj) throws SQLException {
        try {
            if (obj instanceof Number) {
                return ((Number)obj).longValue();
            }
            if (obj == null) {
                return 0L;
            }
            if (obj instanceof String) {
                return Long.parseLong((String)obj);
            }
            throw new SQLException("Illegal conversion");
        }
        catch (Exception e) {
            throw new SQLException("Cannot convert field" + e.toString(), e);
        }
    }

    public static short getShortField(Object obj) throws SQLException {
        try {
            if (obj instanceof Number) {
                return ((Number)obj).shortValue();
            }
            if (obj == null) {
                return 0;
            }
            if (obj instanceof String) {
                return Short.parseShort((String)obj);
            }
            throw new SQLException("Illegal conversion");
        }
        catch (Exception e) {
            throw new SQLException("Cannot convert field" + e.toString(), e);
        }
    }

    public static double getDoubleField(Object obj) throws SQLException {
        try {
            if (obj instanceof Number) {
                return ((Number)obj).doubleValue();
            }
            if (obj == null) {
                return 0.0;
            }
            if (obj instanceof String) {
                return Double.parseDouble((String)obj);
            }
            throw new SQLException("Illegal conversion");
        }
        catch (Exception e) {
            throw new SQLException("Cannot convert field" + e.toString(), e);
        }
    }

    public static String getStringField(Object obj) throws SQLException {
        if (obj == null) {
            return null;
        }
        if (obj instanceof byte[]) {
            return new String((byte[])obj);
        }
        if (obj instanceof Date) {
            return DateFormatUtils.getDateTimeString((Date)((Date)obj));
        }
        return obj.toString();
    }

    public static boolean getBooleanField(Object obj) throws SQLException {
        if (obj instanceof Boolean) {
            return (Boolean)obj;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof Number) {
            return ((Number)obj).intValue() != 0;
        }
        if (obj instanceof String) {
            return !obj.equals("0");
        }
        throw new SQLException("Cannot convert column to boolean");
    }

    public static BigDecimal getBigDecimalField(Object obj) throws SQLException {
        return BigDecimal.valueOf(TypeUtils.getLongField(obj));
    }

    public static Object getField(Object fieldObj, DataType dataType) throws SQLException {
        switch (DataType.TypeName.fromName((String)dataType.getName())) {
            case BOOLEAN: {
                return TypeUtils.getBooleanField(fieldObj);
            }
            case TINYINT: 
            case SMALLINT: {
                return TypeUtils.getShortField(fieldObj);
            }
            case INT: {
                return TypeUtils.getIntField(fieldObj);
            }
            case BIGINT: {
                return TypeUtils.getLongField(fieldObj);
            }
            case FLOAT: 
            case DOUBLE: {
                return TypeUtils.getDoubleField(fieldObj);
            }
            case DECIMAL: {
                return TypeUtils.getBigDecimalField(fieldObj);
            }
            case STRING: 
            case CHAR: 
            case VARCHAR: {
                return TypeUtils.getStringField(fieldObj);
            }
            case STRUCT: {
                return new SimpleStruct((StructType)dataType, fieldObj);
            }
        }
        return fieldObj;
    }
}

