/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk;

import com.huawei.dli.sdk.SQLJob;
import com.huawei.dli.sdk.common.DLIInfo;
import com.huawei.dli.sdk.common.SqlDialect;
import com.huawei.dli.sdk.common.TableType;
import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.meta.Database;
import com.huawei.dli.sdk.meta.FunctionIdentifier;
import com.huawei.dli.sdk.meta.Row;
import com.huawei.dli.sdk.meta.Table;
import com.huawei.dli.sdk.meta.TableIdentifier;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.meta.types.SchemaUtils;
import com.huawei.dli.sdk.read.ResultSet;
import com.huawei.dli.sdk.util.ApiTemplate;
import com.huawei.dli.sdk.util.SqlUtils;
import com.huawei.dli.sdk.util.V3ClientUtils;
import com.huaweicloud.sdk.dli.v1.DliClient;
import com.huaweicloud.sdk.dli.v1.model.Catalog;
import com.huaweicloud.sdk.dli.v1.model.ListCatalogsRequest;
import com.huaweicloud.sdk.dli.v1.model.ListCatalogsResponse;
import com.huaweicloud.sdk.dli.v1.model.ShowCatalogRequest;
import com.huaweicloud.sdk.dli.v1.model.ShowCatalogResponse;
import com.huaweicloud.sdk.lakeformation.v1.LakeFormationClient;
import com.huaweicloud.sdk.lakeformation.v1.model.ListDatabaseNamesRequest;
import com.huaweicloud.sdk.lakeformation.v1.model.ListDatabaseNamesResponse;
import com.huaweicloud.sdk.lakeformation.v1.model.ListFunctionNamesRequest;
import com.huaweicloud.sdk.lakeformation.v1.model.ListFunctionNamesResponse;
import com.huaweicloud.sdk.lakeformation.v1.model.ListPartitionNamesRequest;
import com.huaweicloud.sdk.lakeformation.v1.model.ListPartitionNamesResponse;
import com.huaweicloud.sdk.lakeformation.v1.model.ListTableMetaRequest;
import com.huaweicloud.sdk.lakeformation.v1.model.ListTableMetaResponse;
import com.huaweicloud.sdk.lakeformation.v1.model.ListTablesRequest;
import com.huaweicloud.sdk.lakeformation.v1.model.ListTablesResponse;
import com.huaweicloud.sdk.lakeformation.v1.model.PagedInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DLIClient {
    private static final Logger log = LoggerFactory.getLogger(DLIClient.class);
    private static final int DEFAULT_PAGE_SIZE = 500;
    private static final String DEFAULT_LF_INSTANCE_ID = "default";
    private final DLIInfo dliInfo;
    private String transactionId;
    private volatile DliClient v3DliClient;
    private volatile LakeFormationClient v3LfClient;
    private SqlDialect dialect = SqlDialect.SPARK;

    public DLIClient(DLIInfo dliInfo) {
        this.dliInfo = dliInfo;
    }

    DLIClient(DLIInfo dliInfo, DliClient v3DliClient, LakeFormationClient v3LfClient) {
        this.dliInfo = dliInfo;
        this.v3DliClient = v3DliClient;
        this.v3LfClient = v3LfClient;
    }

    public synchronized DliClient getV3DliClient() {
        if (this.v3DliClient == null) {
            this.v3DliClient = V3ClientUtils.getDliClient(this.dliInfo);
        }
        return this.v3DliClient;
    }

    public synchronized LakeFormationClient getV3LfClient() {
        if (this.v3LfClient == null) {
            this.v3LfClient = V3ClientUtils.getLfClient(this.dliInfo);
        }
        return this.v3LfClient;
    }

    public void setDialect(String dialect) {
        this.dialect = SqlDialect.fromName(dialect);
        SqlUtils.setDialect(this.dialect);
    }

    public List<String> listCatalogs() throws DLIException {
        String exceptionMsg = "Failed to list catalogs";
        ListCatalogsResponse resp = (ListCatalogsResponse)ApiTemplate.invokeApi(() -> this.getV3DliClient().listCatalogsInvoker(new ListCatalogsRequest().withOffset(Integer.valueOf(0)).withLimit(Integer.valueOf(1))), exceptionMsg);
        Long totalCount = ApiTemplate.handleResponse(resp.getIsSuccess(), () -> ((ListCatalogsResponse)resp).getTotalCount(), exceptionMsg);
        ArrayList<String> catalogs = new ArrayList<String>();
        int i = 0;
        while ((long)i < totalCount) {
            int offset = i;
            ListCatalogsResponse resp2 = (ListCatalogsResponse)ApiTemplate.invokeApi(() -> this.getV3DliClient().listCatalogsInvoker(new ListCatalogsRequest().withOffset(Integer.valueOf(offset)).withLimit(Integer.valueOf(500))), exceptionMsg);
            catalogs.addAll(ApiTemplate.handleResponse(resp2.getIsSuccess(), () -> resp2.getCatalogs().stream().map(Catalog::getName).collect(Collectors.toList()), exceptionMsg));
            i += 500;
        }
        return catalogs;
    }

    public void createDatabase(String dbName, String description, String enterpriseProjectId) throws DLIException {
        this.execute(SqlUtils.genCreateDatabaseSql(dbName, description, enterpriseProjectId));
    }

    public Database getDatabase(String dbName) throws DLIException {
        ResultSet resultSet = this.executeQuery(SqlUtils.genGetDatabaseSql(dbName));
        return SqlUtils.resultSetWithClose(resultSet, rs -> {
            Database.DatabaseBuilder dbBuilder = Database.builder().dliClient(this).databaseName(dbName);
            while (rs.hasNext()) {
                Row row = rs.read();
                List<Object> record = row.getRecord();
                SqlUtils.validOrThrow(record.size(), v -> v == 2, "The expected num of data in each row is 2, but get " + record.size());
                String firstColV = row.getString(0);
                String secondColV = row.getString(1);
                if (!"Comment".equals(firstColV)) continue;
                dbBuilder.description(secondColV);
            }
            return dbBuilder.build();
        });
    }

    public List<String> listDatabases() throws DLIException {
        return this.listDatabases(null);
    }

    public List<String> listDatabases(String dbPattern) throws DLIException {
        ResultSet resultSet = this.executeQuery(SqlUtils.genListDatabasesSql(null, dbPattern));
        return SqlUtils.resultSetWithClose(resultSet, rs -> {
            ArrayList<String> dbNames = new ArrayList<String>();
            while (rs.hasNext()) {
                Row row = rs.read();
                List<Object> record = row.getRecord();
                SqlUtils.validOrThrow(record.size(), v -> v == 1, "The expected num of data in each row is 1, but get " + record.size());
                dbNames.add(row.getString(0));
            }
            return dbNames;
        });
    }

    public List<String> listDatabases(String catalogName, String dbPattern) throws DLIException {
        if (this.isDliCatalog(catalogName)) {
            return this.listDatabases(dbPattern);
        }
        Pair<Boolean, String> lfCatInfo = this.getLfCatalog(catalogName);
        if (((Boolean)lfCatInfo.getLeft()).booleanValue()) {
            ListDatabaseNamesRequest req = new ListDatabaseNamesRequest().withInstanceId(DEFAULT_LF_INSTANCE_ID).withCatalogName((String)lfCatInfo.getRight());
            if (StringUtils.isNotEmpty((CharSequence)dbPattern)) {
                req.withDatabasePattern(dbPattern);
            }
            ListDatabaseNamesResponse resp = ApiTemplate.invokeApi(() -> this.getV3LfClient().listDatabaseNames(req), "Failed to list databases");
            return ApiTemplate.handleResponse(true, () -> ((ListDatabaseNamesResponse)resp).getBody(), null);
        }
        log.warn("Currently only support dli and lakeformation catalog, ignore unknown catalog: " + catalogName);
        return Collections.emptyList();
    }

    public List<String> listTables(String dbName) throws DLIException {
        return this.listTables(dbName, null);
    }

    public List<String> listTables(String dbName, String tblPattern) throws DLIException {
        Database db = Database.builder().dliClient(this).databaseName(dbName).build();
        return db.listTables(tblPattern);
    }

    public List<TableIdentifier> listTables(String catalogName, String dbPattern, String tblPattern, String[] tblTypes) throws DLIException {
        ArrayList<TableIdentifier> tblNames = new ArrayList<TableIdentifier>();
        if (this.isDliCatalog(catalogName)) {
            for (String dbName : this.listDatabases(dbPattern)) {
                tblNames.addAll(this.listTables(dbName, tblPattern).stream().map(tblName -> new TableIdentifier(dbName, (String)tblName)).collect(Collectors.toList()));
            }
            return tblNames;
        }
        Pair<Boolean, String> lfCatInfo = this.getLfCatalog(catalogName);
        if (((Boolean)lfCatInfo.getLeft()).booleanValue()) {
            PagedInfo pagedInfo;
            boolean hasNext;
            ListTableMetaRequest req = new ListTableMetaRequest().withInstanceId(DEFAULT_LF_INSTANCE_ID).withCatalogName((String)lfCatInfo.getRight()).withDatabaseNamePattern(dbPattern).withTableNamePattern(tblPattern).withLimit(Integer.valueOf(500));
            if (tblTypes != null && tblTypes.length > 0) {
                ArrayList<ListTableMetaRequest.TableTypesEnum> tblTypesEnums = new ArrayList<ListTableMetaRequest.TableTypesEnum>();
                for (String tblType : tblTypes) {
                    if ("TABLE".equals(tblType)) {
                        tblTypesEnums.add(ListTableMetaRequest.TableTypesEnum.MANAGED_TABLE);
                        tblTypesEnums.add(ListTableMetaRequest.TableTypesEnum.EXTERNAL_TABLE);
                    }
                    if (!"VIEW".equals(tblType)) continue;
                    tblTypesEnums.add(ListTableMetaRequest.TableTypesEnum.VIRTUAL_VIEW);
                    tblTypesEnums.add(ListTableMetaRequest.TableTypesEnum.MATERIALIZED_VIEW);
                }
                req.withTableTypes(tblTypesEnums);
            }
            String nextMarker = null;
            do {
                Optional.ofNullable(nextMarker).map(arg_0 -> ((ListTableMetaRequest)req).withMarker(arg_0));
                ListTableMetaResponse resp = ApiTemplate.invokeApi(() -> this.getV3LfClient().listTableMeta(req), "Failed to list tables");
                tblNames.addAll(resp.getTableMetas().stream().map(tbl -> new TableIdentifier(tbl.getDatabaseName(), tbl.getTableName())).collect(Collectors.toList()));
                pagedInfo = resp.getPageInfo();
                nextMarker = pagedInfo.getNextMarker();
            } while (hasNext = pagedInfo.getCurrentCount() > 0 && pagedInfo.getCurrentCount() >= 500);
            return tblNames;
        }
        log.warn("Currently only support dli and lakeformation catalog, ignore unknown catalog: " + catalogName);
        return Collections.emptyList();
    }

    public List<Table> listTables(String catalogName, String dbPattern, String tblPattern) throws DLIException {
        if (this.isDliCatalog(catalogName)) {
            if (StringUtils.isNotEmpty((CharSequence)dbPattern) && !dbPattern.contains("*") && StringUtils.isNotEmpty((CharSequence)tblPattern) && !tblPattern.contains("*")) {
                Database db = Database.builder().dliClient(this).databaseName(dbPattern).build();
                return Collections.singletonList(db.getTable(tblPattern));
            }
            log.warn("List tables with detail on dli catalog has performance issues, use with caution.");
            ArrayList<Table> tables = new ArrayList<Table>();
            List<TableIdentifier> tblIdentifiers = this.listTables(catalogName, dbPattern, tblPattern, null);
            for (TableIdentifier tblIdent : tblIdentifiers) {
                Database db = Database.builder().dliClient(this).databaseName(tblIdent.getDatabaseName()).build();
                tables.add(db.getTable(tblIdent.getTableName()));
            }
            return tables;
        }
        Pair<Boolean, String> lfCatInfo = this.getLfCatalog(catalogName);
        if (((Boolean)lfCatInfo.getLeft()).booleanValue()) {
            ArrayList<Table> tables = new ArrayList<Table>();
            List<String> dbNames = this.listDatabases(catalogName, dbPattern);
            for (String dbName : dbNames) {
                PagedInfo pagedInfo;
                boolean hasNext;
                ListTablesRequest req = new ListTablesRequest().withInstanceId(DEFAULT_LF_INSTANCE_ID).withCatalogName((String)lfCatInfo.getRight()).withDatabaseName(dbName).withTableNamePattern(tblPattern).withLimit(Integer.valueOf(500));
                String nextMarker = null;
                do {
                    Optional.ofNullable(nextMarker).map(arg_0 -> ((ListTablesRequest)req).withMarker(arg_0));
                    ListTablesResponse resp = ApiTemplate.invokeApi(() -> this.getV3LfClient().listTables(req), "Failed to list tables");
                    tables.addAll(resp.getTables().stream().map(tbl -> {
                        List<Column> columns = tbl.getStorageDescriptor().getColumns().stream().map(col -> new Column(col.getColumnName(), SchemaUtils.getDataType(col.getColumnType()), col.getComment())).collect(Collectors.toList());
                        List names = columns.stream().map(Column::getName).collect(Collectors.toList());
                        ArrayList<String> ptColumns = new ArrayList<String>();
                        if (tbl.getPartitionKeys() != null && tbl.getPartitionKeys().size() > 0) {
                            tbl.getPartitionKeys().stream().filter(p -> !names.contains(p.getColumnName())).forEach(p -> {
                                Column c = new Column(p.getColumnName(), SchemaUtils.getDataType(p.getColumnType()), p.getComment());
                                c.setPartitionColumn(true);
                                columns.add(c);
                                ptColumns.add(p.getColumnName());
                            });
                        }
                        return Table.builder().database(Database.builder().databaseName(dbName).build()).tableName(tbl.getTableName()).columns(columns).partitionColumns(ptColumns.size() > 0 ? ptColumns : null).createTime(tbl.getCreateTime().toInstant().toEpochMilli()).lastAccessTime(tbl.getLastAccessTime().toInstant().toEpochMilli()).tableType(TableType.fromName(tbl.getTableType().getValue())).build();
                    }).collect(Collectors.toList()));
                    pagedInfo = resp.getPageInfo();
                    nextMarker = pagedInfo.getNextMarker();
                } while (hasNext = pagedInfo.getCurrentCount() > 0 && pagedInfo.getCurrentCount() >= 500);
            }
            return tables;
        }
        log.warn("Currently only support dli and lakeformation catalog, ignore unknown catalog: " + catalogName);
        return Collections.emptyList();
    }

    public List<String> listPartitions(String dbName, String tblName) throws DLIException {
        Database db = Database.builder().dliClient(this).databaseName(dbName).build();
        Table tbl = Table.builder().database(db).tableName(tblName).build();
        return tbl.listPartitions();
    }

    public List<String> listPartitions(String catalogName, String dbName, String tblName) throws DLIException {
        if (this.isDliCatalog(catalogName)) {
            return this.listPartitions(dbName, tblName);
        }
        Pair<Boolean, String> lfCatInfo = this.getLfCatalog(catalogName);
        if (((Boolean)lfCatInfo.getLeft()).booleanValue()) {
            PagedInfo pagedInfo;
            boolean hasNext;
            ListPartitionNamesRequest req = new ListPartitionNamesRequest().withInstanceId(DEFAULT_LF_INSTANCE_ID).withCatalogName((String)lfCatInfo.getRight()).withDatabaseName(dbName).withTableName(tblName).withLimit(Integer.valueOf(500));
            String nextMarker = null;
            ArrayList<String> partNames = new ArrayList<String>();
            do {
                Optional.ofNullable(nextMarker).map(arg_0 -> ((ListPartitionNamesRequest)req).withMarker(arg_0));
                ListPartitionNamesResponse resp = ApiTemplate.invokeApi(() -> this.getV3LfClient().listPartitionNames(req), "Failed to list partitions");
                partNames.addAll(resp.getPartitionNameList());
                pagedInfo = resp.getPageInfo();
                nextMarker = pagedInfo.getNextMarker();
            } while (hasNext = pagedInfo.getCurrentCount() > 0 && pagedInfo.getCurrentCount() >= 500);
            return partNames;
        }
        log.warn("Currently only support dli and lakeformation catalog, ignore unknown catalog: " + catalogName);
        return Collections.emptyList();
    }

    public List<String> listFunctions(String dbName, String funcPattern) throws DLIException {
        ResultSet resultSet = this.executeQuery(SqlUtils.genListFunctions(dbName, funcPattern));
        return SqlUtils.resultSetWithClose(resultSet, rs -> {
            ArrayList<String> funcNames = new ArrayList<String>();
            while (rs.hasNext()) {
                Row row = rs.read();
                List<Object> record = row.getRecord();
                SqlUtils.validOrThrow(record.size(), v -> v > 0, "The expected num of data in each row is greater than 0, but get " + record.size());
                funcNames.add(row.getString(0));
            }
            return funcNames;
        });
    }

    public List<FunctionIdentifier> listFunctions(String catalogName, String dbPattern, String funcPattern) throws DLIException {
        if (this.isDliCatalog(catalogName)) {
            ArrayList<FunctionIdentifier> funcNames = new ArrayList<FunctionIdentifier>();
            List<String> dbNames = this.listDatabases(null, dbPattern);
            for (String dbName : dbNames) {
                funcNames.addAll(this.listFunctions(dbName, funcPattern).stream().map(funcName -> this.toFuncIdentifier(dbName, (String)funcName)).collect(Collectors.toList()));
            }
            return funcNames;
        }
        Pair<Boolean, String> lfCatInfo = this.getLfCatalog(catalogName);
        if (((Boolean)lfCatInfo.getLeft()).booleanValue()) {
            ArrayList<FunctionIdentifier> funcNames = new ArrayList<FunctionIdentifier>();
            List<String> dbNames = this.listDatabases((String)lfCatInfo.getRight(), dbPattern);
            for (String dbName : dbNames) {
                ListFunctionNamesRequest req = new ListFunctionNamesRequest().withInstanceId(DEFAULT_LF_INSTANCE_ID).withCatalogName((String)lfCatInfo.getRight()).withDatabaseName(dbName);
                if (StringUtils.isNotEmpty((CharSequence)funcPattern)) {
                    req.withFunctionPattern(funcPattern);
                }
                ListFunctionNamesResponse resp = ApiTemplate.invokeApi(() -> this.getV3LfClient().listFunctionNames(req), "Failed to list functions");
                funcNames.addAll(resp.getBody().stream().map(funcName -> this.toFuncIdentifier(dbName, (String)funcName)).collect(Collectors.toList()));
            }
            return funcNames;
        }
        log.warn("Currently only support dli and lakeformation catalog, ignore unknown catalog: " + catalogName);
        return Collections.emptyList();
    }

    private FunctionIdentifier toFuncIdentifier(String dbName, String funcName) {
        String[] funNameArr = funcName.split("\\.");
        if (funNameArr.length == 2) {
            return new FunctionIdentifier(dbName != null ? dbName : funNameArr[0], funNameArr[1]);
        }
        return new FunctionIdentifier(funcName);
    }

    private boolean isDliCatalog(String catalogName) {
        return StringUtils.isEmpty((CharSequence)catalogName) || "dli".equals(catalogName.toLowerCase(Locale.ROOT));
    }

    private Pair<Boolean, String> getLfCatalog(String catalogName) throws DLIException {
        try {
            ShowCatalogResponse resp = (ShowCatalogResponse)ApiTemplate.invokeApi(() -> this.getV3DliClient().showCatalogInvoker(new ShowCatalogRequest().withCatalogName(catalogName)), "Failed to get catalog by name: " + catalogName);
            Map params = resp.getParameters();
            String catalogType = params.getOrDefault("type", "");
            if (StringUtils.isNotEmpty((CharSequence)catalogType) && "lakeformation".equals(catalogType)) {
                return ImmutablePair.of((Object)true, params.get("external_catalog_name"));
            }
            return ImmutablePair.of((Object)false, null);
        }
        catch (DLIException e) {
            if (e.getStatusCode() == 404) {
                return ImmutablePair.of((Object)false, null);
            }
            throw e;
        }
    }

    public void execute(String sql) throws DLIException {
        this.execute(sql, this.dialect.getValue());
    }

    public void execute(String sql, String dialect) throws DLIException {
        this.getSqlJob(sql, dialect).submit();
    }

    public ResultSet executeQuery(String sql) throws DLIException {
        return this.executeQuery(sql, this.dialect.getValue());
    }

    public ResultSet executeQuery(String sql, String dialect) throws DLIException {
        return this.getSqlJob(sql, dialect).submitQuery();
    }

    private SQLJob getSqlJob(String sql, String dialect) {
        SQLJob sqlJob = new SQLJob(this.dliInfo, sql);
        sqlJob.setV3DliClient(this.getV3DliClient());
        sqlJob.setEngineType(dialect);
        if (StringUtils.isNotEmpty((CharSequence)this.transactionId)) {
            sqlJob.setTransactionId(this.transactionId);
        }
        return sqlJob;
    }

    void setTransactionId4UT(String transactionId) {
        this.transactionId = transactionId;
    }

    public DLIInfo getDliInfo() {
        return this.dliInfo;
    }

    public SqlDialect getDialect() {
        return this.dialect;
    }
}

