/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk;

import com.huawei.dli.sdk.common.DLIInfo;
import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.function.ApiSupplier;
import com.huawei.dli.sdk.util.ApiTemplate;
import com.huawei.dli.sdk.util.ObsProxy;
import com.huawei.dli.sdk.util.V3ClientUtils;
import com.huaweicloud.sdk.dli.v1.DliClient;
import com.obs.services.ObsClient;
import java.util.List;
import java.util.Map;

public abstract class Job {
    protected static final long ONE_SECOND_IN_MS = 1000L;
    protected DLIInfo dliInfo;
    protected String queueName;
    protected String jobId;
    protected String jobStatus;
    protected long jobTimeout = -1L;
    private List<Map<String, Object>> conf;
    private String transactionId;
    private volatile DliClient v3DliClient;
    private ObsProxy obsProxy;

    Job(DLIInfo dliInfo) {
        this.dliInfo = dliInfo;
        this.queueName = dliInfo.getQueueName();
    }

    void setV3DliClient(DliClient v3DliClient) {
        this.v3DliClient = v3DliClient;
    }

    protected synchronized DliClient getV3DliClient() {
        if (this.v3DliClient == null) {
            this.v3DliClient = V3ClientUtils.getDliClient(this.dliInfo);
        }
        return this.v3DliClient;
    }

    void setObsProxy(ObsProxy obsProxy) {
        this.obsProxy = obsProxy;
    }

    protected synchronized ObsProxy getObsProxy() {
        if (this.obsProxy == null) {
            ObsClient obsClient = new ObsClient(this.dliInfo.getAccessKey(), this.dliInfo.getSecretKey(), this.dliInfo.getSecurityToken(), this.dliInfo.getObsEndpoint());
            this.obsProxy = new ObsProxy(obsClient);
        }
        return this.obsProxy;
    }

    public void submit() throws DLIException {
        this.asyncSubmit();
        this.cycleCheckJob(this.getJobId());
    }

    public void asyncSubmit() throws DLIException {
        if (this.getJobId() != null) {
            throw new DLIException("Job had been submitted, don't submit repeatedly");
        }
    }

    protected abstract void cycleCheckJob(String var1) throws DLIException;

    protected abstract String getTransactionKeyName();

    protected <T, R> R reliableInvokeApi(ApiSupplier<T, R> apiCall, String exceptionMsg) throws DLIException {
        if (this.dliInfo.isUseRetry()) {
            return ApiTemplate.invokeApiWithRetry(apiCall, exceptionMsg, this.dliInfo.getRetryTimes(), (long)this.dliInfo.getRetryIntervals() * 1000L);
        }
        return ApiTemplate.invokeApi(apiCall, exceptionMsg);
    }

    public DLIInfo getDliInfo() {
        return this.dliInfo;
    }

    public String getJobId() {
        return this.jobId;
    }

    public void setJobId(String jobId) {
        this.jobId = jobId;
    }

    public String getJobStatus() {
        return this.jobStatus;
    }

    public void setJobStatus(String jobStatus) {
        this.jobStatus = jobStatus;
    }

    public long getJobTimeout() {
        return this.jobTimeout;
    }

    public void setJobTimeout(long jobTimeout) {
        this.jobTimeout = jobTimeout;
    }

    public List<Map<String, Object>> getConf() {
        return this.conf;
    }

    public void setConf(List<Map<String, Object>> conf) {
        this.conf = conf;
    }

    public String getTransactionId() {
        return this.transactionId;
    }

    public void setTransactionId(String transactionId) {
        this.transactionId = transactionId;
    }
}

