/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk;

import com.google.gson.Gson;
import com.huawei.dli.sdk.SqlJobBase;
import com.huawei.dli.sdk.common.DLIInfo;
import com.huawei.dli.sdk.common.JobType;
import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.meta.Row;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.meta.types.DataType;
import com.huawei.dli.sdk.meta.types.SchemaUtils;
import com.huawei.dli.sdk.read.ResultSet;
import com.huawei.dli.sdk.read.impl.CachedResultSet;
import com.huawei.dli.sdk.read.impl.CsvObsReader;
import com.huawei.dli.sdk.read.impl.EmptyResultSet;
import com.huawei.dli.sdk.read.impl.InMemoryReader;
import com.huawei.dli.sdk.read.impl.JsonObsReader;
import com.huawei.dli.sdk.util.ApiTemplate;
import com.huawei.dli.sdk.util.ObsProxy;
import com.huaweicloud.sdk.dli.v1.model.CreateSqlJobRequest;
import com.huaweicloud.sdk.dli.v1.model.CreateSqlJobRequestBody;
import com.huaweicloud.sdk.dli.v1.model.CreateSqlJobResponse;
import com.huaweicloud.sdk.dli.v1.model.ExportSqlJobResultRequest;
import com.huaweicloud.sdk.dli.v1.model.ExportSqlJobResultRequestBody;
import com.huaweicloud.sdk.dli.v1.model.ExportSqlJobResultResponse;
import com.huaweicloud.sdk.dli.v1.model.PreviewSqlJobResultRequest;
import com.huaweicloud.sdk.dli.v1.model.PreviewSqlJobResultResponse;
import com.huaweicloud.sdk.dli.v1.model.Tag;
import com.obs.services.model.ObsObject;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SQLJob
extends SqlJobBase {
    private static final Logger log = LoggerFactory.getLogger(SQLJob.class);
    private static final String META_FILE_NAME = "metadata.json";
    private static final Gson GSON = new Gson();
    private final String sql;
    private String catalog;
    private String currentDb;
    private String jobMode;
    private JobType jobType;
    private String engineType = "spark";
    private Map<String, String> tags;

    public SQLJob(DLIInfo dliInfo, String sql) {
        super(dliInfo);
        this.sql = sql;
    }

    public SQLJob(DLIInfo dliInfo, String currentDb, String sql) {
        this(dliInfo, sql);
        this.currentDb = currentDb;
    }

    @Override
    public void asyncSubmit() throws DLIException {
        super.asyncSubmit();
        this.invokeCreateSqlJob();
    }

    public ResultSet submitQuery() throws DLIException {
        this.submit();
        return this.getResultSet();
    }

    private void invokeCreateSqlJob() throws DLIException {
        String exceptionMsg = "Failed to submit sql";
        CreateSqlJobRequestBody body = this.buildCreateSqlJobRequestBody();
        CreateSqlJobResponse resp = (CreateSqlJobResponse)this.reliableInvokeApi(() -> this.getV3DliClient().createSqlJobInvoker(new CreateSqlJobRequest().withBody(body)), exceptionMsg);
        ApiTemplate.handleResponse(resp.getIsSuccess(), () -> {
            JobType returnJobType;
            this.jobId = resp.getJobId();
            this.jobMode = resp.getJobMode();
            try {
                returnJobType = JobType.valueOf(resp.getJobType().getValue());
            }
            catch (IllegalArgumentException e) {
                returnJobType = JobType.UNKNOWN;
            }
            this.jobType = returnJobType;
            return null;
        }, exceptionMsg + ", reason: " + resp.getMessage());
    }

    private CreateSqlJobRequestBody buildCreateSqlJobRequestBody() {
        List<Object> confList;
        String transactionId;
        CreateSqlJobRequestBody body = new CreateSqlJobRequestBody().withQueueName(this.queueName).withEngineType(CreateSqlJobRequestBody.EngineTypeEnum.fromValue((String)this.engineType)).withSql(this.getSql());
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{this.catalog})) {
            body.setCurrentCatalog(this.catalog);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getCurrentDb())) {
            body.withCurrentdb(this.getCurrentDb());
        }
        List<Map<String, Object>> inputConf = this.getConf();
        String string = transactionId = StringUtils.isNotBlank((CharSequence)this.getTransactionId()) ? this.getTransactionId() : UUID.randomUUID().toString();
        if (inputConf != null) {
            confList = this.toConfList(inputConf, transactionId);
        } else {
            confList = new ArrayList();
            confList.add("dli.sql.sqlasync.enabled=true");
            confList.add(this.getTransactionKeyName() + "=" + transactionId);
        }
        body.withConf(confList);
        Map<String, String> inputTags = this.getTags();
        if (inputTags != null && !inputTags.isEmpty()) {
            body.withTags(inputTags.entrySet().stream().map(entry -> new Tag().withKey((String)entry.getKey()).withValue((String)entry.getValue())).collect(Collectors.toList()));
        }
        return body;
    }

    private List<String> toConfList(List<Map<String, Object>> confMapList, String transactionId) {
        ArrayList<String> confList = new ArrayList<String>();
        boolean isAsync = false;
        boolean hasTransactionId = false;
        for (Map<String, Object> conf : confMapList) {
            for (Map.Entry<String, Object> entry : conf.entrySet()) {
                Object value = entry.getValue();
                if ("dli.sql.sqlasync.enabled".equals(entry.getKey())) {
                    value = "true";
                    isAsync = true;
                }
                String confStr = entry.getKey() + "=" + value;
                confList.add(confStr);
                if (!this.getTransactionKeyName().equals(entry.getKey())) continue;
                hasTransactionId = true;
            }
        }
        if (!isAsync) {
            confList.add("dli.sql.sqlasync.enabled=true");
        }
        if (!hasTransactionId) {
            confList.add(this.getTransactionKeyName() + "=" + transactionId);
        }
        return confList;
    }

    public ResultSet getResultSet() throws DLIException {
        if (!this.isFinishedStatus(this.getJobStatus())) {
            throw new DLIException("Job is not finished, please check");
        }
        if (this.resultSchema == null) {
            return new EmptyResultSet();
        }
        return this.resultPath != null ? this.getJobResultFromObs("csv") : new InMemoryReader(this.previewJobResult());
    }

    private ResultSet getJobResultFromObs(String fileFormat) throws DLIException {
        ObsProxy obsProxy = this.getObsProxy();
        List<ObsObject> objects = this.getMatchedObjects(obsProxy, this.resultPath);
        ResultSet resultSet = this.getResultSet(obsProxy, objects, this.resultSchema, fileFormat, this.resultCount);
        resultSet.init();
        return resultSet;
    }

    private List<ObsObject> getMatchedObjects(ObsProxy obsProxy, String resultPath) throws DLIException {
        String bucketName = obsProxy.getBucketName(resultPath);
        String objPrefix = obsProxy.getObjectPrefix(resultPath);
        String metaObj = objPrefix + "/" + META_FILE_NAME;
        String queryId = "";
        InputStream inputStream = obsProxy.getObjectStream(bucketName, metaObj);
        if (inputStream != null) {
            try (InputStreamReader reader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);){
                Map metaMap = (Map)GSON.fromJson((Reader)reader, Map.class);
                queryId = metaMap.getOrDefault("queryId", "");
            }
            catch (IOException e) {
                throw new DLIException("Failed to read metadata file, reason: " + e.getMessage());
            }
        }
        String fQueryId = queryId;
        return obsProxy.listObjects(bucketName, objPrefix).stream().filter(obsObj -> obsObj.getMetadata().getContentLength() > 0L && this.isDataFile(obsObj.getObjectKey(), fQueryId)).sorted(Comparator.comparing(ObsObject::getObjectKey)).collect(Collectors.toList());
    }

    private boolean isDataFile(String objKey, String queryId) {
        boolean dataFile;
        boolean bl = dataFile = !objKey.endsWith(META_FILE_NAME);
        if (StringUtils.isNotBlank((CharSequence)queryId)) {
            return dataFile && objKey.contains(queryId);
        }
        return dataFile;
    }

    private ResultSet getResultSet(ObsProxy obsProxy, List<ObsObject> objects, List<Column> schema, String fileFormat, long totalCount) {
        if (this.dliInfo.isUseCacheReader() && totalCount > (long)this.dliInfo.getCacheReaderThreshold() && objects.size() > 1) {
            int realConcurrent = Math.min(this.dliInfo.getCacheReaderThreads(), objects.size());
            ArrayList<ResultSet> readers = new ArrayList<ResultSet>(realConcurrent);
            int step = (int)Math.ceil((double)objects.size() / (double)realConcurrent);
            for (int i = 0; i < objects.size(); i += step) {
                readers.add(this.createReader(obsProxy, this.copyList(objects, i, i + step), schema, fileFormat));
            }
            return new CachedResultSet(readers, totalCount);
        }
        return this.createReader(obsProxy, objects, schema, fileFormat);
    }

    private ResultSet createReader(ObsProxy obsProxy, List<ObsObject> objects, List<Column> schema, String fileFormat) {
        return "csv".equals(fileFormat) ? new CsvObsReader(obsProxy, objects, schema) : new JsonObsReader(obsProxy, objects, schema);
    }

    private List<ObsObject> copyList(List<ObsObject> originList, int start, int end) {
        ArrayList<ObsObject> newList = new ArrayList<ObsObject>(end - start);
        int fEnd = Math.min(end, originList.size());
        for (int i = start; i < fEnd; ++i) {
            newList.add(originList.get(i));
        }
        return newList;
    }

    @Deprecated
    public List<Row> previewJobResult() throws DLIException {
        String exceptionMsg = "Failed to get job result by id: " + this.getJobId();
        PreviewSqlJobResultResponse resp = (PreviewSqlJobResultResponse)this.reliableInvokeApi(() -> this.getV3DliClient().previewSqlJobResultInvoker(new PreviewSqlJobResultRequest().withQueueName(this.queueName).withJobId(this.getJobId())), exceptionMsg);
        return ApiTemplate.handleResponse(resp.getIsSuccess(), () -> {
            List columns;
            this.resultSchema = columns = resp.getSchema().stream().map(nameTypeMap -> {
                Column column;
                block0: {
                    column = null;
                    Iterator iterator = nameTypeMap.entrySet().iterator();
                    if (!iterator.hasNext()) break block0;
                    Map.Entry kv = iterator.next();
                    String colName = (String)kv.getKey();
                    DataType dataType = SchemaUtils.getDataType(kv.getValue());
                    column = new Column(colName, dataType);
                }
                return column;
            }).filter(Objects::nonNull).collect(Collectors.toList());
            return resp.getRows().stream().map(record -> {
                Row row = new Row(columns);
                row.setRecord((List<Object>)record);
                return row;
            }).collect(Collectors.toList());
        }, exceptionMsg + ", reason: " + resp.getMessage());
    }

    @Deprecated
    public ResultSet exportResult() throws DLIException {
        return this.exportResult(null);
    }

    @Deprecated
    public ResultSet exportResult(Integer limit) throws DLIException {
        if (this.resultPath == null || this.resultSchema == null) {
            throw new DLIException("Don't have result or not set result path, can not export job result");
        }
        ExportSqlJobResultRequestBody body = new ExportSqlJobResultRequestBody();
        if (!"default".equals(this.queueName)) {
            body.withQueueName(this.queueName);
        }
        body.withDataPath(this.resultPath).withDataType("json").withCompress("NONE").withExportMode(ExportSqlJobResultRequestBody.ExportModeEnum.ERRORIFEXISTS).withWithColumnHeader(Boolean.valueOf(false)).withLimitNum(limit).withEncodingType("utf-8");
        String exportJobId = this.invokeExportSqlJobResult(body);
        this.cycleCheckJob(exportJobId);
        return this.getJobResultFromObs("json");
    }

    private String invokeExportSqlJobResult(ExportSqlJobResultRequestBody body) throws DLIException {
        String exceptionMsg = "Failed to export job result by id: " + this.getJobId();
        ExportSqlJobResultResponse resp = (ExportSqlJobResultResponse)ApiTemplate.invokeApi(() -> this.getV3DliClient().exportSqlJobResultInvoker(new ExportSqlJobResultRequest().withJobId(this.getJobId()).withBody(body)), exceptionMsg);
        return ApiTemplate.handleResponse(resp.getIsSuccess(), () -> ((ExportSqlJobResultResponse)resp).getJobId(), exceptionMsg + ", reason: " + resp.getMessage());
    }

    public String getSql() {
        return this.sql;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getCurrentDb() {
        return this.currentDb;
    }

    public String getJobMode() {
        return this.jobMode;
    }

    public JobType getJobType() {
        return this.jobType;
    }

    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public void setTags(Map<String, String> tags) {
        this.tags = tags;
    }
}

