/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk;

import com.huawei.dli.sdk.Job;
import com.huawei.dli.sdk.common.DLIInfo;
import com.huawei.dli.sdk.common.JobStatus;
import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.meta.types.SchemaUtils;
import com.huawei.dli.sdk.util.ApiTemplate;
import com.huaweicloud.sdk.dli.v1.model.ShowSqlJobStatusRequest;
import com.huaweicloud.sdk.dli.v1.model.ShowSqlJobStatusResponse;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class SqlJobBase
extends Job {
    private static final Logger log = LoggerFactory.getLogger(SqlJobBase.class);
    private static final long TEN_SECOND_IN_MS = 10000L;
    private static final long FIVE_MINUTES_IN_MS = 300000L;
    protected List<Column> resultSchema;
    protected String resultPath;
    protected long resultCount;

    SqlJobBase(DLIInfo dliInfo) {
        super(dliInfo);
    }

    @Override
    protected String getTransactionKeyName() {
        return "spark.sql.dli.job.transaction.id";
    }

    @Deprecated
    protected ShowSqlJobStatusResponse getStatus(String jobId) throws DLIException {
        ShowSqlJobStatusResponse resp = (ShowSqlJobStatusResponse)this.reliableInvokeApi(() -> this.getV3DliClient().showSqlJobStatusInvoker(new ShowSqlJobStatusRequest().withJobId(jobId)), "Failed to get job status by id: " + jobId);
        this.jobStatus = resp.getStatus().getValue();
        return resp;
    }

    @Override
    protected void cycleCheckJob(String jobId) throws DLIException {
        block10: {
            ShowSqlJobStatusResponse resp;
            long startTime = System.currentTimeMillis();
            long waitTime = 1000L;
            while (true) {
                try {
                    resp = this.getStatus(jobId);
                    log.info("Current status is: {} for job id: {}", (Object)resp.getStatus(), (Object)jobId);
                    if (System.currentTimeMillis() - startTime > 300000L) {
                        waitTime = 1000L;
                    }
                }
                catch (DLIException e) {
                    if (e.getMessage().contains("APIGW.0308")) {
                        if (waitTime < 10000L) {
                            waitTime += 1000L;
                        }
                        ApiTemplate.trySleep(waitTime);
                        continue;
                    }
                    throw e;
                }
                if (this.isFinishedStatus(resp.getStatus().getValue())) {
                    boolean hasResult = StringUtils.isNotBlank((CharSequence)resp.getDetail());
                    if (hasResult) {
                        if (StringUtils.isNotBlank((CharSequence)resp.getResultPath())) {
                            this.resultPath = resp.getResultPath();
                        }
                        this.resultSchema = SchemaUtils.getSchemaFromJson(resp.getDetail());
                        this.resultCount = resp.getResultCount() != null ? (long)resp.getResultCount().intValue() : 0L;
                    }
                    break block10;
                }
                if (this.isFailedStatus(resp.getStatus().getValue())) {
                    throw new DLIException(resp.getMessage());
                }
                ApiTemplate.trySleep(waitTime);
                long endTime = System.currentTimeMillis();
                long timeout = endTime - startTime;
                if (this.getJobTimeout() != -1L && timeout >= this.getJobTimeout() * 1000L) break;
            }
            throw new DLIException("The job by id: " + jobId + " is timeout with status: " + resp.getStatus());
        }
    }

    protected boolean isFinishedStatus(String status) {
        return JobStatus.FINISHED.getName().equals(status);
    }

    private boolean isFailedStatus(String status) {
        return JobStatus.FAILED.getName().equals(status) || JobStatus.CANCELLED.getName().equals(status);
    }

    public List<Column> getResultSchema() {
        return this.resultSchema;
    }

    public void setResultSchema(List<Column> resultSchema) {
        this.resultSchema = resultSchema;
    }

    public void setResultPath(String resultPath) {
        this.resultPath = resultPath;
    }

    public long getResultCount() {
        return this.resultCount;
    }

    public void setResultCount(long resultCount) {
        this.resultCount = resultCount;
    }

    public static class TableInfo {
        private final String dbName;
        private final String tblName;
        private final LinkedHashMap<String, String> partSpec;
        private final boolean isOverwrite;

        public TableInfo(String dbName, String tblName) {
            this(dbName, tblName, null, false);
        }

        public TableInfo(String dbName, String tblName, boolean isOverwrite) {
            this(dbName, tblName, null, isOverwrite);
        }

        public TableInfo(String dbName, String tblName, LinkedHashMap<String, String> partSpec) {
            this(dbName, tblName, partSpec, false);
        }

        public String getDbName() {
            return this.dbName;
        }

        public String getTblName() {
            return this.tblName;
        }

        public LinkedHashMap<String, String> getPartSpec() {
            return this.partSpec;
        }

        public boolean isOverwrite() {
            return this.isOverwrite;
        }

        public TableInfo(String dbName, String tblName, LinkedHashMap<String, String> partSpec, boolean isOverwrite) {
            this.dbName = dbName;
            this.tblName = tblName;
            this.partSpec = partSpec;
            this.isOverwrite = isOverwrite;
        }
    }
}

