/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk;

import com.huawei.dli.sdk.SQLJob;
import com.huawei.dli.sdk.SqlJobBase;
import com.huawei.dli.sdk.common.DLIInfo;
import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.util.ObsProxy;
import com.huawei.dli.sdk.write.Writer;
import com.huawei.dli.sdk.write.impl.JsonObsWriter;
import java.util.Collections;
import java.util.Map;
import java.util.StringJoiner;
import org.apache.commons.lang3.StringUtils;

public class UploadJob
extends SqlJobBase {
    private final String uploadDataPath;
    private final SqlJobBase.TableInfo tableInfo;
    private final String loadSql;

    public UploadJob(DLIInfo dliInfo, String uploadDataPath, SqlJobBase.TableInfo tableInfo) {
        this(dliInfo, uploadDataPath, tableInfo, null);
    }

    public UploadJob(DLIInfo dliInfo, String uploadDataPath, String loadSql) {
        this(dliInfo, uploadDataPath, null, loadSql);
    }

    UploadJob(DLIInfo dliInfo, String uploadDataPath, SqlJobBase.TableInfo tableInfo, String loadSql) {
        super(dliInfo);
        this.uploadDataPath = uploadDataPath;
        this.tableInfo = tableInfo;
        this.loadSql = loadSql;
    }

    public synchronized Writer createWriter() {
        return new JsonObsWriter(this.getObsProxy(), this.uploadDataPath);
    }

    @Override
    public void asyncSubmit() throws DLIException {
        super.asyncSubmit();
        SQLJob sqlJob = new SQLJob(this.dliInfo, this.loadSql == null ? this.genLoadSql(this.uploadDataPath, this.tableInfo) : this.loadSql);
        sqlJob.setV3DliClient(this.getV3DliClient());
        if (!StringUtils.isNotBlank((CharSequence)this.getTransactionId())) {
            sqlJob.setTransactionId(this.getTransactionId());
        }
        sqlJob.setConf(Collections.singletonList(Collections.singletonMap("dli.sql.dynamicPartitionOverwrite.enabled", "true")));
        sqlJob.asyncSubmit();
        this.jobId = sqlJob.getJobId();
    }

    private String genLoadSql(String dataPath, SqlJobBase.TableInfo tblInfo) {
        String overwrite = tblInfo.isOverwrite() ? "OVERWRITE" : "";
        String partSpecClause = "";
        if (tblInfo.getPartSpec() != null && !tblInfo.getPartSpec().isEmpty()) {
            StringJoiner sj = new StringJoiner(", ");
            for (Map.Entry<String, String> entry : tblInfo.getPartSpec().entrySet()) {
                sj.add(String.format("`%s`='%s'", entry.getKey(), entry.getValue()));
            }
            partSpecClause = String.format("PARTITION (%s)", sj);
        }
        ObsProxy obsProxy = this.getObsProxy();
        return String.format("LOAD DATA INPATH 'obs://%s/%s' %s INTO TABLE `%s`.`%s` %s OPTIONS(data_type 'json')", obsProxy.getBucketName(dataPath), obsProxy.getObjectPrefix(dataPath), overwrite, tblInfo.getDbName(), tblInfo.getTblName(), partSpecClause);
    }
}

