/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.common;

public class DLIInfo {
    private static final String ENDPOINT_POSTFIX = ".myhuaweicloud.com";
    private String regionName;
    private String projectId;
    private String accessKey;
    private String secretKey;
    private String securityToken;
    private String dliEndpoint;
    private String lfEndpoint;
    private String obsEndpoint;
    private String proxyHost;
    private int proxyPort = 0;
    private String proxyUser;
    private String proxyPwd;
    private boolean useRetry = false;
    private int retryTimes = 3;
    private int retryIntervals = 30;
    private boolean useCacheReader = false;
    private int cacheReaderThreads = 3;
    private int cacheReaderThreshold = 50000;
    private String queueName = "default";

    public DLIInfo() {
    }

    public DLIInfo(String regionName, String accessKey, String secretKey, String projectId) {
        this.regionName = regionName;
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.projectId = projectId;
        this.dliEndpoint = "dli." + regionName + ENDPOINT_POSTFIX;
        this.lfEndpoint = "lakeformation." + regionName + ENDPOINT_POSTFIX;
        this.obsEndpoint = "obs." + regionName + ENDPOINT_POSTFIX;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public String getProjectId() {
        return this.projectId;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public String getSecurityToken() {
        return this.securityToken;
    }

    public String getDliEndpoint() {
        return this.dliEndpoint;
    }

    public String getLfEndpoint() {
        return this.lfEndpoint;
    }

    public String getObsEndpoint() {
        return this.obsEndpoint;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public String getProxyUser() {
        return this.proxyUser;
    }

    public String getProxyPwd() {
        return this.proxyPwd;
    }

    public boolean isUseRetry() {
        return this.useRetry;
    }

    public int getRetryTimes() {
        return this.retryTimes;
    }

    public int getRetryIntervals() {
        return this.retryIntervals;
    }

    public boolean isUseCacheReader() {
        return this.useCacheReader;
    }

    public int getCacheReaderThreads() {
        return this.cacheReaderThreads;
    }

    public int getCacheReaderThreshold() {
        return this.cacheReaderThreshold;
    }

    public String getQueueName() {
        return this.queueName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public void setSecurityToken(String securityToken) {
        this.securityToken = securityToken;
    }

    public void setDliEndpoint(String dliEndpoint) {
        this.dliEndpoint = dliEndpoint;
    }

    public void setLfEndpoint(String lfEndpoint) {
        this.lfEndpoint = lfEndpoint;
    }

    public void setObsEndpoint(String obsEndpoint) {
        this.obsEndpoint = obsEndpoint;
    }

    public void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    public void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    public void setProxyUser(String proxyUser) {
        this.proxyUser = proxyUser;
    }

    public void setProxyPwd(String proxyPwd) {
        this.proxyPwd = proxyPwd;
    }

    public void setUseRetry(boolean useRetry) {
        this.useRetry = useRetry;
    }

    public void setRetryTimes(int retryTimes) {
        this.retryTimes = retryTimes;
    }

    public void setRetryIntervals(int retryIntervals) {
        this.retryIntervals = retryIntervals;
    }

    public void setUseCacheReader(boolean useCacheReader) {
        this.useCacheReader = useCacheReader;
    }

    public void setCacheReaderThreads(int cacheReaderThreads) {
        this.cacheReaderThreads = cacheReaderThreads;
    }

    public void setCacheReaderThreshold(int cacheReaderThreshold) {
        this.cacheReaderThreshold = cacheReaderThreshold;
    }

    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }
}

