/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.common;

import java.util.Locale;

public enum StorageType {
    CSV("csv", 0),
    PARQUET("parquet", 1),
    ORC("orc", 2),
    JSON("json", 3),
    CARBON("carbon", 4),
    AVRO("avro", 5),
    UNKNOWN("UNKNOWN", 6);

    private final int value;
    private final String name;

    private StorageType(String name, int value) {
        this.name = name;
        this.value = value;
    }

    public static StorageType fromName(String name) {
        if ((name = name.toLowerCase(Locale.ENGLISH)).equals(StorageType.CSV.name)) {
            return CSV;
        }
        if (name.equals(StorageType.PARQUET.name)) {
            return PARQUET;
        }
        if (name.equals(StorageType.ORC.name)) {
            return ORC;
        }
        if (name.equals(StorageType.JSON.name)) {
            return JSON;
        }
        if (name.equals(StorageType.CARBON.name)) {
            return CARBON;
        }
        if (name.equals(StorageType.AVRO.name)) {
            return AVRO;
        }
        return UNKNOWN;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }
}

