/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.meta;

import com.huawei.dli.sdk.DLIClient;
import com.huawei.dli.sdk.common.CsvFormatInfo;
import com.huawei.dli.sdk.common.StorageType;
import com.huawei.dli.sdk.common.TableType;
import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.meta.Row;
import com.huawei.dli.sdk.meta.Table;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.meta.types.SchemaUtils;
import com.huawei.dli.sdk.read.ResultSet;
import com.huawei.dli.sdk.util.SqlUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Database {
    private static final Logger log = LoggerFactory.getLogger(Database.class);
    private final String databaseName;
    private final String description;
    private final DLIClient dliClient;

    public String toString() {
        return "Database{databaseName='" + this.databaseName + '\'' + ", description='" + this.description + '\'' + '}';
    }

    public void deleteDatabase() throws DLIException {
        this.dliClient.execute(SqlUtils.genDeleteDatabaseSql(this.databaseName));
    }

    public void createDliTable(String tableName, String description, List<Column> columns) throws DLIException {
        String sql = SqlUtils.genCreateTableSql(this.databaseName, tableName, description, columns, StorageType.PARQUET, null, null);
        this.dliClient.execute(sql);
    }

    public void createObsTable(String tableName, String description, List<Column> columns, StorageType storageType, String dataPath, CsvFormatInfo csvFormatInfo) throws DLIException {
        if (StringUtils.isEmpty((CharSequence)dataPath)) {
            throw new DLIException("Missing location define");
        }
        String sql = SqlUtils.genCreateTableSql(this.databaseName, tableName, description, columns, storageType, dataPath, csvFormatInfo);
        this.dliClient.execute(sql);
    }

    public void createTable(String tableName, String dataLocation, String description, List<Column> columns, StorageType storageType, String dataPath, CsvFormatInfo csvFormatInfo) throws DLIException {
        switch (dataLocation) {
            case "DLI": {
                this.createDliTable(tableName, description, columns);
                break;
            }
            case "OBS": {
                this.createObsTable(tableName, description, columns, storageType, dataPath, csvFormatInfo);
                break;
            }
            default: {
                throw new IllegalArgumentException("Input data location is illegal");
            }
        }
    }

    public Table getTable(String tableName) throws DLIException {
        ResultSet resultSet = this.dliClient.executeQuery(SqlUtils.genGetTableSql(this.databaseName, tableName));
        return SqlUtils.resultSetWithClose(resultSet, rs -> {
            Table.TableBuilder tblBuilder = Table.builder().database(this).tableName(tableName);
            boolean hasPartCol = Database.handleCols(rs, tblBuilder);
            if (hasPartCol) {
                Database.handlePartCols(rs, tblBuilder);
            }
            Database.handleTblInfo(rs, tblBuilder);
            Table tbl = tblBuilder.build();
            Database.updateCols(tbl.getColumns(), tbl.getPartitionColumns());
            return tbl;
        });
    }

    private static boolean handleCols(ResultSet resultSet, Table.TableBuilder tblBuilder) throws DLIException {
        boolean hasPartCol = false;
        ArrayList<Column> columns = new ArrayList<Column>();
        while (resultSet.hasNext()) {
            Row row = resultSet.read();
            List<Object> record = row.getRecord();
            SqlUtils.validOrThrow(record.size(), v -> v == 3 || v == 4, "The expected num of data in each row is 3, but get " + record.size());
            String firstColV = row.getString(0);
            if ("# Partition Information".equals(firstColV)) {
                hasPartCol = true;
                break;
            }
            if (StringUtils.isEmpty((CharSequence)firstColV)) break;
            columns.add(new Column(row.getString(0), SchemaUtils.getDataType(record.get(1)), row.getString(2)));
        }
        tblBuilder.columns(columns);
        return hasPartCol;
    }

    private static void handlePartCols(ResultSet resultSet, Table.TableBuilder tblBuilder) throws DLIException {
        ArrayList<String> partColNames = new ArrayList<String>();
        while (resultSet.hasNext()) {
            Row row = resultSet.read();
            String firstColV = row.getString(0);
            if ("# col_name".equals(firstColV)) continue;
            if (StringUtils.isEmpty((CharSequence)firstColV)) break;
            partColNames.add(firstColV);
        }
        tblBuilder.partitionColumns(partColNames);
    }

    private static void handleTblInfo(ResultSet resultSet, Table.TableBuilder tblBuilder) throws DLIException {
        String provider = null;
        String serdeLib = null;
        String inputFormat = null;
        String outputFormat = null;
        while (resultSet.hasNext()) {
            Row row = resultSet.read();
            String firstColV = row.getString(0);
            String secondColV = row.getString(1);
            switch (firstColV) {
                case "Owner": {
                    tblBuilder.owner(secondColV);
                    break;
                }
                case "Created Time": {
                    tblBuilder.createTime(SqlUtils.parseTimeStrToMills(secondColV));
                    break;
                }
                case "Last Access": {
                    tblBuilder.lastAccessTime(SqlUtils.parseTimeStrToMills(secondColV));
                    break;
                }
                case "Provider": {
                    provider = secondColV;
                    if ("hive".equals(provider)) break;
                    tblBuilder.dataType(provider);
                    break;
                }
                case "Serde Library": {
                    serdeLib = secondColV;
                    break;
                }
                case "InputFormat": {
                    inputFormat = secondColV;
                    break;
                }
                case "OutputFormat": {
                    outputFormat = secondColV;
                    break;
                }
                case "Location": {
                    tblBuilder.location(secondColV);
                    break;
                }
                case "Type": {
                    tblBuilder.tableType(TableType.fromName(secondColV));
                    break;
                }
                case "Table Properties": {
                    Map<String, String> propMap = SqlUtils.toMap(secondColV);
                    tblBuilder.totalSize(Long.parseLong(propMap.getOrDefault("dataSize", "0")));
                    break;
                }
            }
        }
        if ("hive".equals(provider)) {
            tblBuilder.dataType(SqlUtils.getDataType(serdeLib, inputFormat, outputFormat));
        }
    }

    private static void updateCols(List<Column> columns, List<String> partColNames) {
        if (partColNames == null || partColNames.isEmpty()) {
            return;
        }
        for (Column col : columns) {
            if (!partColNames.contains(col.getName())) continue;
            col.setPartitionColumn(true);
        }
    }

    public List<String> listTables(String tblPattern) throws DLIException {
        ResultSet resultSet = this.dliClient.executeQuery(SqlUtils.genListTablesSql(this.databaseName, tblPattern));
        return SqlUtils.resultSetWithClose(resultSet, rs -> {
            ArrayList<String> tblNames = new ArrayList<String>();
            while (rs.hasNext()) {
                Row row = rs.read();
                List<Object> record = row.getRecord();
                SqlUtils.validOrThrow(record.size(), v -> v == 3 || v == 1, "The expected num of data in each row is 3, but get " + record.size());
                tblNames.add(record.size() == 1 ? row.getString(0) : row.getString(1));
            }
            return tblNames;
        });
    }

    Database(String databaseName, String description, DLIClient dliClient) {
        this.databaseName = databaseName;
        this.description = description;
        this.dliClient = dliClient;
    }

    public static DatabaseBuilder builder() {
        return new DatabaseBuilder();
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public String getDescription() {
        return this.description;
    }

    public DLIClient getDliClient() {
        return this.dliClient;
    }

    public static class DatabaseBuilder {
        private String databaseName;
        private String description;
        private DLIClient dliClient;

        DatabaseBuilder() {
        }

        public DatabaseBuilder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public DatabaseBuilder description(String description) {
            this.description = description;
            return this;
        }

        public DatabaseBuilder dliClient(DLIClient dliClient) {
            this.dliClient = dliClient;
            return this;
        }

        public Database build() {
            return new Database(this.databaseName, this.description, this.dliClient);
        }

        public String toString() {
            return "Database.DatabaseBuilder(databaseName=" + this.databaseName + ", description=" + this.description + ", dliClient=" + this.dliClient + ")";
        }
    }
}

