/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.meta;

import com.huawei.dli.sdk.meta.Table;

public class Partition {
    private Table table;
    private String partitionName;
    private long createTime;
    private long lastAccessTime;
    private String location;
    private long numRows;
    private long numFiles;
    private long totalSize;

    public String toString() {
        return "Partition{partitionName='" + this.partitionName + '\'' + ", createTime=" + this.createTime + ", lastAccessTime=" + this.lastAccessTime + ", location='" + this.location + '\'' + '}';
    }

    Partition(Table table, String partitionName, long createTime, long lastAccessTime, String location, long numRows, long numFiles, long totalSize) {
        this.table = table;
        this.partitionName = partitionName;
        this.createTime = createTime;
        this.lastAccessTime = lastAccessTime;
        this.location = location;
        this.numRows = numRows;
        this.numFiles = numFiles;
        this.totalSize = totalSize;
    }

    public static PartitionBuilder builder() {
        return new PartitionBuilder();
    }

    public Table getTable() {
        return this.table;
    }

    public String getPartitionName() {
        return this.partitionName;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public String getLocation() {
        return this.location;
    }

    public long getNumRows() {
        return this.numRows;
    }

    public long getNumFiles() {
        return this.numFiles;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public static class PartitionBuilder {
        private Table table;
        private String partitionName;
        private long createTime;
        private long lastAccessTime;
        private String location;
        private long numRows;
        private long numFiles;
        private long totalSize;

        PartitionBuilder() {
        }

        public PartitionBuilder table(Table table) {
            this.table = table;
            return this;
        }

        public PartitionBuilder partitionName(String partitionName) {
            this.partitionName = partitionName;
            return this;
        }

        public PartitionBuilder createTime(long createTime) {
            this.createTime = createTime;
            return this;
        }

        public PartitionBuilder lastAccessTime(long lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
            return this;
        }

        public PartitionBuilder location(String location) {
            this.location = location;
            return this;
        }

        public PartitionBuilder numRows(long numRows) {
            this.numRows = numRows;
            return this;
        }

        public PartitionBuilder numFiles(long numFiles) {
            this.numFiles = numFiles;
            return this;
        }

        public PartitionBuilder totalSize(long totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        public Partition build() {
            return new Partition(this.table, this.partitionName, this.createTime, this.lastAccessTime, this.location, this.numRows, this.numFiles, this.totalSize);
        }

        public String toString() {
            return "Partition.PartitionBuilder(table=" + this.table + ", partitionName=" + this.partitionName + ", createTime=" + this.createTime + ", lastAccessTime=" + this.lastAccessTime + ", location=" + this.location + ", numRows=" + this.numRows + ", numFiles=" + this.numFiles + ", totalSize=" + this.totalSize + ")";
        }
    }
}

