/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.meta;

import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.meta.types.DataType;
import java.math.BigDecimal;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class Row {
    private final List<Column> schema;
    private List<Object> record;

    public Row(List<Column> schema) {
        this.schema = schema;
        this.record = new ArrayList<Object>();
        for (int i = 0; i < schema.size(); ++i) {
            this.record.add(null);
        }
    }

    public void setObject(int index, Object value, DataType.TypeName type) {
        this.validIndexAndDataType(index, type);
        this.record.set(index, value);
    }

    public void setBoolean(int index, Boolean value) {
        this.validIndexAndDataType(index, DataType.TypeName.BOOLEAN);
        this.record.set(index, value);
    }

    public Boolean getBoolean(int index) {
        this.validIndexAndDataType(index, DataType.TypeName.BOOLEAN);
        return (Boolean)this.record.get(index);
    }

    public void setTinyint(int index, Byte value) {
        this.validIndexAndDataType(index, DataType.TypeName.TINYINT);
        this.record.set(index, value);
    }

    public Byte getTinyint(int index) {
        this.validIndexAndDataType(index, DataType.TypeName.TINYINT);
        return (Byte)this.record.get(index);
    }

    public void setSmallint(int index, Short value) {
        this.validIndexAndDataType(index, DataType.TypeName.SMALLINT);
        this.record.set(index, value);
    }

    public Short getSmallint(int index) {
        this.validIndexAndDataType(index, DataType.TypeName.SMALLINT);
        return (Short)this.record.get(index);
    }

    public void setInt(int index, Integer value) {
        this.validIndexAndDataType(index, DataType.TypeName.INT);
        this.record.set(index, value);
    }

    public Integer getInt(int index) {
        this.validIndexAndDataType(index, DataType.TypeName.INT);
        return (Integer)this.record.get(index);
    }

    public void setBigint(int index, Long value) {
        this.validIndexAndDataType(index, DataType.TypeName.BIGINT);
        this.record.set(index, value);
    }

    public Long getBigint(int index) {
        this.validIndexAndDataType(index, DataType.TypeName.BIGINT);
        return (Long)this.record.get(index);
    }

    public void setFloat(int index, Float value) {
        this.validIndexAndDataType(index, DataType.TypeName.FLOAT);
        this.record.set(index, value);
    }

    public Float getFloat(int index) {
        this.validIndexAndDataType(index, DataType.TypeName.FLOAT);
        return (Float)this.record.get(index);
    }

    public void setReal(int index, Float value) {
        this.validIndexAndDataType(index, DataType.TypeName.REAL);
        this.record.set(index, value);
    }

    public Float getReal(int index) {
        this.validIndexAndDataType(index, DataType.TypeName.REAL);
        return (Float)this.record.get(index);
    }

    public void setDouble(int index, Double value) {
        this.validIndexAndDataType(index, DataType.TypeName.DOUBLE);
        this.record.set(index, value);
    }

    public Double getDouble(int index) {
        this.validIndexAndDataType(index, DataType.TypeName.DOUBLE);
        return (Double)this.record.get(index);
    }

    public void setDate(int index, java.sql.Date value) {
        this.validIndexAndDataType(index, DataType.TypeName.DATE);
        this.record.set(index, value);
    }

    public void setDate(int index, Date value) {
        this.validIndexAndDataType(index, DataType.TypeName.DATE);
        this.record.set(index, new java.sql.Date(value.getTime()));
    }

    public java.sql.Date getDate(int index) {
        this.validIndexAndDataType(index, DataType.TypeName.DATE);
        if (this.record.get(index) instanceof Date) {
            return new java.sql.Date(((Date)this.record.get(index)).getTime());
        }
        return (java.sql.Date)this.record.get(index);
    }

    public void setTime(int index, Time value) {
        this.validIndexAndDataType(index, DataType.TypeName.TIME);
        this.record.set(index, value);
    }

    public Time getTime(int index) {
        this.validIndexAndDataType(index, DataType.TypeName.TIME);
        return (Time)this.record.get(index);
    }

    public void setTimestamp(int index, Timestamp value) {
        this.validIndexAndDataType(index, DataType.TypeName.TIMESTAMP);
        this.record.set(index, value);
    }

    public Timestamp getTimestamp(int index) {
        this.validIndexAndDataType(index, DataType.TypeName.TIMESTAMP);
        return (Timestamp)this.record.get(index);
    }

    public void setString(int index, String value) {
        this.validIndexAndDataType(index, DataType.TypeName.STRING);
        this.record.set(index, value);
    }

    public String getString(int index) {
        this.validIndexAndDataType(index, DataType.TypeName.STRING);
        return (String)this.record.get(index);
    }

    public void setDecimal(int index, BigDecimal value) {
        this.validIndexAndDataType(index, DataType.TypeName.DECIMAL);
        this.record.set(index, value);
    }

    public BigDecimal getDecimal(int index) {
        this.validIndexAndDataType(index, DataType.TypeName.DECIMAL);
        return (BigDecimal)this.record.get(index);
    }

    public void setBinary(int index, byte[] value) {
        this.validIndexAndDataType(index, DataType.TypeName.BINARY);
        this.record.set(index, value);
    }

    public byte[] getBinary(int index) {
        this.validIndexAndDataType(index, DataType.TypeName.BINARY);
        return (byte[])this.record.get(index);
    }

    private void validIndexAndDataType(int index, DataType.TypeName typeName) {
        if (index > this.schema.size()) {
            throw new IllegalArgumentException("Index exceed");
        }
        if (DataType.TypeName.fromName(this.schema.get(index).getType().getName()) != typeName) {
            throw new IllegalArgumentException("Incorrect data type");
        }
    }

    public List<Column> getSchema() {
        return this.schema;
    }

    public List<Object> getRecord() {
        return this.record;
    }

    public void setRecord(List<Object> record) {
        this.record = record;
    }
}

