/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.meta;

import com.huawei.dli.sdk.common.PartitionSpec;
import com.huawei.dli.sdk.common.TableType;
import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.meta.Database;
import com.huawei.dli.sdk.meta.Partition;
import com.huawei.dli.sdk.meta.Row;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.read.ResultSet;
import com.huawei.dli.sdk.util.SqlUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Table {
    private static final Logger log = LoggerFactory.getLogger(Table.class);
    private Database database;
    private String tableName;
    private List<Column> columns;
    private List<String> partitionColumns;
    private String owner;
    private long createTime;
    private long lastAccessTime;
    private String location;
    private TableType tableType;
    private String dataType;
    private long totalSize;

    public String toString() {
        return "Table{tableName='" + this.tableName + '\'' + ", createTime=" + this.createTime + ", lastAccessTime=" + this.lastAccessTime + ", location='" + this.location + '\'' + '}';
    }

    public void deleteTable() throws DLIException {
        this.database.getDliClient().execute(SqlUtils.genDeleteTableSql(this.database.getDatabaseName(), this.tableName));
    }

    public Partition getPartition(PartitionSpec partSpec) throws DLIException {
        ResultSet resultSet = this.database.getDliClient().executeQuery(SqlUtils.genGetPartitionSql(this.database.getDatabaseName(), this.tableName, partSpec));
        return SqlUtils.resultSetWithClose(resultSet, rs -> {
            String firstColV;
            while (rs.hasNext()) {
                Row row = resultSet.read();
                List<Object> record = row.getRecord();
                SqlUtils.validOrThrow(record.size(), v -> v == 3, "The expected num of data in each row is 3, but get " + record.size());
                firstColV = row.getString(0);
                if (!"# Detailed Partition Information".equals(firstColV)) continue;
                break;
            }
            Partition.PartitionBuilder partBuilder = Partition.builder().table(this).partitionName(partSpec.toString(false, true));
            while (rs.hasNext()) {
                Row row = resultSet.read();
                firstColV = row.getString(0);
                String secondColV = row.getString(1);
                if (StringUtils.isEmpty((CharSequence)firstColV)) break;
                switch (firstColV) {
                    case "Created Time": {
                        partBuilder.createTime(SqlUtils.parseTimeStrToMills(secondColV));
                        break;
                    }
                    case "Last Access": {
                        partBuilder.lastAccessTime(SqlUtils.parseTimeStrToMills(secondColV));
                        break;
                    }
                    case "Location": {
                        partBuilder.location(secondColV);
                        break;
                    }
                    case "Partition Parameters": {
                        Map<String, String> paramMap = SqlUtils.toMap(secondColV);
                        partBuilder.totalSize(Long.parseLong(paramMap.getOrDefault("totalSize", "0")));
                        partBuilder.numFiles(Long.parseLong(paramMap.getOrDefault("numFiles", "0")));
                        partBuilder.numRows(Long.parseLong(paramMap.getOrDefault("numRows", "-1")));
                        break;
                    }
                }
            }
            return partBuilder.build();
        });
    }

    public List<String> listPartitions() throws DLIException {
        ResultSet resultSet = this.database.getDliClient().executeQuery(SqlUtils.genListPartitionsSql(this.database.getDatabaseName(), this.tableName));
        return SqlUtils.resultSetWithClose(resultSet, rs -> {
            ArrayList<String> partNames = new ArrayList<String>();
            while (rs.hasNext()) {
                Row row = resultSet.read();
                List<Object> record = row.getRecord();
                SqlUtils.validOrThrow(record.size(), v -> v == 1, "The expected num of data in each row is 1, but get " + record.size());
                String[] firstColVArr = row.getString(0).split(" : ");
                partNames.add(firstColVArr[0].trim());
            }
            return partNames;
        });
    }

    Table(Database database, String tableName, List<Column> columns, List<String> partitionColumns, String owner, long createTime, long lastAccessTime, String location, TableType tableType, String dataType, long totalSize) {
        this.database = database;
        this.tableName = tableName;
        this.columns = columns;
        this.partitionColumns = partitionColumns;
        this.owner = owner;
        this.createTime = createTime;
        this.lastAccessTime = lastAccessTime;
        this.location = location;
        this.tableType = tableType;
        this.dataType = dataType;
        this.totalSize = totalSize;
    }

    public static TableBuilder builder() {
        return new TableBuilder();
    }

    public Database getDatabase() {
        return this.database;
    }

    public String getTableName() {
        return this.tableName;
    }

    public List<Column> getColumns() {
        return this.columns;
    }

    public List<String> getPartitionColumns() {
        return this.partitionColumns;
    }

    public String getOwner() {
        return this.owner;
    }

    public long getCreateTime() {
        return this.createTime;
    }

    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    public String getLocation() {
        return this.location;
    }

    public TableType getTableType() {
        return this.tableType;
    }

    public String getDataType() {
        return this.dataType;
    }

    public long getTotalSize() {
        return this.totalSize;
    }

    public static class TableBuilder {
        private Database database;
        private String tableName;
        private List<Column> columns;
        private List<String> partitionColumns;
        private String owner;
        private long createTime;
        private long lastAccessTime;
        private String location;
        private TableType tableType;
        private String dataType;
        private long totalSize;

        TableBuilder() {
        }

        public TableBuilder database(Database database) {
            this.database = database;
            return this;
        }

        public TableBuilder tableName(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public TableBuilder columns(List<Column> columns) {
            this.columns = columns;
            return this;
        }

        public TableBuilder partitionColumns(List<String> partitionColumns) {
            this.partitionColumns = partitionColumns;
            return this;
        }

        public TableBuilder owner(String owner) {
            this.owner = owner;
            return this;
        }

        public TableBuilder createTime(long createTime) {
            this.createTime = createTime;
            return this;
        }

        public TableBuilder lastAccessTime(long lastAccessTime) {
            this.lastAccessTime = lastAccessTime;
            return this;
        }

        public TableBuilder location(String location) {
            this.location = location;
            return this;
        }

        public TableBuilder tableType(TableType tableType) {
            this.tableType = tableType;
            return this;
        }

        public TableBuilder dataType(String dataType) {
            this.dataType = dataType;
            return this;
        }

        public TableBuilder totalSize(long totalSize) {
            this.totalSize = totalSize;
            return this;
        }

        public Table build() {
            return new Table(this.database, this.tableName, this.columns, this.partitionColumns, this.owner, this.createTime, this.lastAccessTime, this.location, this.tableType, this.dataType, this.totalSize);
        }

        public String toString() {
            return "Table.TableBuilder(database=" + this.database + ", tableName=" + this.tableName + ", columns=" + this.columns + ", partitionColumns=" + this.partitionColumns + ", owner=" + this.owner + ", createTime=" + this.createTime + ", lastAccessTime=" + this.lastAccessTime + ", location=" + this.location + ", tableType=" + (Object)((Object)this.tableType) + ", dataType=" + this.dataType + ", totalSize=" + this.totalSize + ")";
        }
    }

    public static class HiveSerDe {
        private String serde;
        private String inputFormat;
        private String outputFormat;

        public HiveSerDe(String serde, String inputFormat, String outputFormat) {
            this.serde = serde;
            this.inputFormat = inputFormat;
            this.outputFormat = outputFormat;
        }

        public String getSerde() {
            return this.serde;
        }

        public String getInputFormat() {
            return this.inputFormat;
        }

        public String getOutputFormat() {
            return this.outputFormat;
        }
    }
}

