/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.meta.types;

import java.util.Locale;

public abstract class DataType {
    protected String name;

    public abstract String getName();

    public static enum TypeName {
        BOOLEAN,
        TINYINT,
        SMALLINT,
        INT,
        BIGINT,
        FLOAT,
        REAL,
        DOUBLE,
        DECIMAL,
        DATE,
        TIME,
        TIMESTAMP,
        STRING,
        CHAR,
        VARCHAR,
        BINARY,
        ARRAY,
        MAP,
        STRUCT,
        VOID;


        public static TypeName fromName(String name) {
            if ((name = name.toLowerCase(Locale.ROOT)).equals("boolean")) {
                return BOOLEAN;
            }
            if (name.equals("tinyint") || name.equals("byte")) {
                return TINYINT;
            }
            if (name.equals("smallint") || name.equals("short")) {
                return SMALLINT;
            }
            if (name.equals("int") || name.equals("integer")) {
                return INT;
            }
            if (name.equals("bigint") || name.equals("long")) {
                return BIGINT;
            }
            if (name.equals("float")) {
                return FLOAT;
            }
            if (name.equals("real")) {
                return REAL;
            }
            if (name.equals("double")) {
                return DOUBLE;
            }
            if (name.startsWith("decimal")) {
                return DECIMAL;
            }
            if (name.equals("date")) {
                return DATE;
            }
            if (name.equals("time")) {
                return TIME;
            }
            if (name.equals("timestamp")) {
                return TIMESTAMP;
            }
            if (name.equals("string")) {
                return STRING;
            }
            if (name.startsWith("char")) {
                return CHAR;
            }
            if (name.startsWith("varchar")) {
                return VARCHAR;
            }
            if (name.equals("binary") || name.equals("varbinary")) {
                return BINARY;
            }
            if (name.startsWith("array")) {
                return ARRAY;
            }
            if (name.startsWith("map")) {
                return MAP;
            }
            if (name.startsWith("struct") || name.startsWith("row")) {
                return STRUCT;
            }
            if (name.equals("void") || name.equals("null")) {
                return VOID;
            }
            throw new IllegalArgumentException("Unsupported data type: " + name);
        }
    }
}

