/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.meta.types;

import com.huawei.dli.sdk.meta.types.ArrayType;
import com.huawei.dli.sdk.meta.types.CharType;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.meta.types.DataType;
import com.huawei.dli.sdk.meta.types.DecimalType;
import com.huawei.dli.sdk.meta.types.MapType;
import com.huawei.dli.sdk.meta.types.PrimitiveType;
import com.huawei.dli.sdk.meta.types.StructType;
import com.huawei.dli.sdk.meta.types.VarcharType;
import com.huawei.dli.sdk.util.SqlUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Objects;
import java.util.Queue;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DataTypeParser {
    private static final Pattern IDENTIFIER_CHAR_PATTERN = Pattern.compile("(\\w|\\.|`)");
    private final Queue<String> tokenQueue = new LinkedList<String>();

    public DataType parseDataType(String sql) {
        this.tokenize(sql);
        return this.parseDataTypeInternal(this.tokenQueue.poll());
    }

    private void tokenize(String str) {
        int index = 0;
        for (int stop = 1; stop <= str.length(); ++stop) {
            if (stop != str.length() && !this.notIdentChar(str.charAt(stop)) && !this.notIdentChar(str.charAt(stop - 1))) continue;
            String token = str.substring(index, stop).trim();
            if (!token.isEmpty()) {
                this.tokenQueue.offer(token);
            }
            index = stop;
        }
    }

    private boolean notIdentChar(char c) {
        return !IDENTIFIER_CHAR_PATTERN.matcher(String.valueOf(c)).find();
    }

    private DataType parseDataTypeInternal(String token) {
        DataType.TypeName typeName = DataType.TypeName.fromName(Objects.requireNonNull(token));
        switch (typeName) {
            case DECIMAL: {
                return this.parseDecimalType();
            }
            case CHAR: {
                return this.parseCharVarcharType(DataType.TypeName.CHAR);
            }
            case VARCHAR: {
                return this.parseCharVarcharType(DataType.TypeName.VARCHAR);
            }
            case ARRAY: {
                return this.parseArrayType();
            }
            case MAP: {
                return this.parseMapType();
            }
            case STRUCT: {
                return this.parseStructType();
            }
        }
        return new PrimitiveType(typeName);
    }

    private DecimalType parseDecimalType() {
        int precision = 10;
        int scale = 0;
        if ("(".equals(this.tokenQueue.peek())) {
            SqlUtils.validOrThrow(this.tokenQueue.poll(), "("::equals, "Expect char is '(', but got others.");
            precision = Integer.parseInt(Objects.requireNonNull(this.tokenQueue.poll()));
            if (",".equals(this.tokenQueue.peek())) {
                SqlUtils.validOrThrow(this.tokenQueue.poll(), ","::equals, "Expect char is '(', but got others.");
                scale = Integer.parseInt(Objects.requireNonNull(this.tokenQueue.poll()));
            }
            SqlUtils.validOrThrow(this.tokenQueue.poll(), ")"::equals, "Expect char is ',', but got others.");
        }
        return new DecimalType(precision, scale);
    }

    private DataType parseCharVarcharType(DataType.TypeName typeName) {
        if ("(".equals(this.tokenQueue.peek())) {
            SqlUtils.validOrThrow(this.tokenQueue.poll(), "("::equals, "Expect char is '(', but got others.");
            StringBuilder size = new StringBuilder(Objects.requireNonNull(this.tokenQueue.poll()));
            String next = Objects.requireNonNull(this.tokenQueue.poll());
            while (StringUtils.isNumeric((CharSequence)next)) {
                size.append(next);
                next = Objects.requireNonNull(this.tokenQueue.poll());
            }
            SqlUtils.validOrThrow(next, ")"::equals, "Expect char is ',', but got others.");
            if (typeName == DataType.TypeName.CHAR) {
                return new CharType(Integer.parseInt(size.toString()));
            }
            return new VarcharType(Integer.parseInt(size.toString()));
        }
        return typeName == DataType.TypeName.CHAR ? new CharType(10) : new VarcharType(10);
    }

    private DataType parseArrayType() {
        SqlUtils.validOrThrow(this.tokenQueue.poll(), Arrays.asList("<", "(")::contains, "Expect char is '<' or '(', but got others.");
        DataType elemDataType = this.parseDataTypeInternal(this.tokenQueue.poll());
        SqlUtils.validOrThrow(this.tokenQueue.poll(), Arrays.asList(">", ")")::contains, "Expect char is '>' or ')', but got others.");
        return new ArrayType(elemDataType);
    }

    private DataType parseMapType() {
        SqlUtils.validOrThrow(this.tokenQueue.poll(), Arrays.asList("<", "(")::contains, "Expect char is '<' or '(', but got others.");
        DataType keyDataType = this.parseDataTypeInternal(this.tokenQueue.poll());
        SqlUtils.validOrThrow(this.tokenQueue.poll(), ","::equals, "Expect char is ',', but got others.");
        DataType valueDataType = this.parseDataTypeInternal(this.tokenQueue.poll());
        SqlUtils.validOrThrow(this.tokenQueue.poll(), Arrays.asList(">", ")")::contains, "Expect char is '>' or ')', but got others.");
        return new MapType(keyDataType, valueDataType);
    }

    private DataType parseStructType() {
        ArrayList<Column> fields = new ArrayList<Column>();
        SqlUtils.validOrThrow(this.tokenQueue.poll(), Arrays.asList("<", "(")::contains, "Expect char is '<' or '(', but got others.");
        boolean stop = false;
        do {
            String fieldName = Objects.requireNonNull(this.tokenQueue.poll());
            String nextToken = this.tokenQueue.poll();
            if (nextToken.equals(":")) {
                nextToken = this.tokenQueue.poll();
            }
            DataType fieldDataType = this.parseDataTypeInternal(nextToken);
            nextToken = Objects.requireNonNull(this.tokenQueue.poll());
            fields.add(new Column(fieldName, fieldDataType));
            if (!Arrays.asList(">", ")").contains(nextToken)) continue;
            stop = true;
        } while (!stop);
        return new StructType(fields);
    }
}

