/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.meta.types;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.huawei.dli.sdk.meta.types.ArrayType;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.meta.types.DataType;
import com.huawei.dli.sdk.meta.types.DataTypeParser;
import com.huawei.dli.sdk.meta.types.MapType;
import com.huawei.dli.sdk.meta.types.StructType;
import com.huaweicloud.sdk.core.utils.JsonUtils;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;

public class SchemaUtils {
    public static List<Column> getSchemaFromJson(String jsonStr) {
        ResultSchema resultSchema = (ResultSchema)JsonUtils.toObject((String)jsonStr, ResultSchema.class);
        if (resultSchema.getFields() == null) {
            return null;
        }
        return resultSchema.getFields().stream().map(resultField -> new Column(resultField.getName(), SchemaUtils.getDataType(resultField.getType()))).collect(Collectors.toList());
    }

    public static DataType getDataType(Object inType) {
        if (inType instanceof String) {
            DataTypeParser parser = new DataTypeParser();
            return parser.parseDataType((String)inType);
        }
        if (inType instanceof Map) {
            Map ctMap = (Map)inType;
            String ctName = ((String)ctMap.get("type")).toLowerCase(Locale.ROOT);
            if (ctName.equals("array")) {
                return new ArrayType(SchemaUtils.getDataType(ctMap.get("elementType")));
            }
            if (ctName.equals("map")) {
                return new MapType(SchemaUtils.getDataType(ctMap.get("keyType")), SchemaUtils.getDataType(ctMap.get("valueType")));
            }
            if (ctName.equals("struct")) {
                return new StructType(SchemaUtils.getSchemaFromJson(JsonUtils.toJSON((Object)inType)));
            }
        }
        throw new IllegalArgumentException("Unsupported data type");
    }

    @JsonIgnoreProperties(ignoreUnknown=true)
    static class ResultSchema {
        private List<ResultField> fields;

        ResultSchema() {
        }

        public List<ResultField> getFields() {
            return this.fields;
        }

        public void setFields(List<ResultField> fields) {
            this.fields = fields;
        }

        @JsonIgnoreProperties(ignoreUnknown=true)
        static class ResultField {
            private String name;
            private Object type;

            ResultField() {
            }

            public String getName() {
                return this.name;
            }

            public Object getType() {
                return this.type;
            }

            public void setName(String name) {
                this.name = name;
            }

            public void setType(Object type) {
                this.type = type;
            }
        }
    }
}

