/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.read.impl;

import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.meta.Row;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.meta.types.DataType;
import com.huawei.dli.sdk.read.impl.ReaderBase;
import com.huawei.dli.sdk.util.DateFormatUtils;
import com.huawei.dli.sdk.util.ObsProxy;
import com.huaweicloud.sdk.core.utils.JsonUtils;
import com.obs.services.model.ObsObject;
import com.univocity.parsers.common.ParsingContext;
import com.univocity.parsers.common.ResultIterator;
import com.univocity.parsers.csv.CsvFormat;
import com.univocity.parsers.csv.CsvParser;
import com.univocity.parsers.csv.CsvParserSettings;
import com.univocity.parsers.csv.UnescapedQuoteHandling;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CsvObsReader
extends ReaderBase<ResultIterator<String[], ParsingContext>> {
    private static final Logger log = LoggerFactory.getLogger(CsvObsReader.class);
    private static final String NULL_VALUE_FOR_CSV = "\u00a0\b\ufeff";

    public CsvObsReader(ObsProxy obsProxy, List<ObsObject> objects, List<Column> resultSchema) {
        super(obsProxy, resultSchema, objects);
        CsvParserSettings parserSettings = new CsvParserSettings();
        ((CsvFormat)parserSettings.getFormat()).setDelimiter(',');
        ((CsvFormat)parserSettings.getFormat()).setQuote('\"');
        ((CsvFormat)parserSettings.getFormat()).setQuoteEscape('\\');
        ((CsvFormat)parserSettings.getFormat()).setComment('\u0000');
        ((CsvFormat)parserSettings.getFormat()).setLineSeparator("\n");
        parserSettings.setIgnoreLeadingWhitespaces(false);
        parserSettings.setIgnoreTrailingWhitespaces(false);
        parserSettings.setReadInputOnSeparateThread(false);
        parserSettings.setSkipEmptyLines(true);
        parserSettings.setNullValue(NULL_VALUE_FOR_CSV);
        parserSettings.setEmptyValue("");
        parserSettings.setMaxCharsPerColumn(-1);
        parserSettings.setUnescapedQuoteHandling(UnescapedQuoteHandling.STOP_AT_DELIMITER);
        this.toIterFunc = inputStream -> new CsvParser(parserSettings).iterate(inputStream, StandardCharsets.UTF_8).iterator();
    }

    @Override
    public Row read() throws DLIException {
        if (this.closed) {
            throw new IllegalStateException("The reader state is closed");
        }
        if (!((ResultIterator)this.iterator).hasNext()) {
            log.info("Read {} records from pre iterator", (Object)this.readRecordsPerIter);
            if (this.nextIterIdx < this.totalIter) {
                this.iterator = this.getNextIterator();
            }
        }
        if (this.iterator != null && ((ResultIterator)this.iterator).hasNext()) {
            String[] values = this.readWithRetry();
            Row row = new Row(this.resultSchema);
            this.updateRow(values, row);
            return row;
        }
        return null;
    }

    private String[] readWithRetry() throws DLIException {
        for (int times = 0; times < 5; ++times) {
            try {
                String[] values = (String[])((ResultIterator)this.iterator).next();
                ++this.readRecordsPerIter;
                return values;
            }
            catch (Exception e) {
                log.warn("Get record failed, may be connection closed by obs, so reconnect it!!!", (Throwable)e);
                this.reconnectAndSkipHandled();
                continue;
            }
        }
        throw new DLIException("Failed to read value with retry");
    }

    private void updateRow(String[] values, Row row) throws DLIException {
        if (values.length != row.getSchema().size()) {
            String msg = String.format("Data value size: %s not match column size: %s", values.length, row.getSchema().size());
            log.error("{}, and data after parse details:", (Object)msg);
            for (String data : values) {
                log.error("\t{}", (Object)data);
            }
            throw new DLIException(msg);
        }
        List<Column> columns = row.getSchema();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            this.updateCol(row, i, column.getType(), values[i]);
        }
    }

    private void updateCol(Row row, int i, DataType dataType, String data) throws DLIException {
        DataType.TypeName typeName = DataType.TypeName.fromName(dataType.getName());
        switch (typeName) {
            case VOID: {
                row.setObject(i, null, DataType.TypeName.VOID);
                break;
            }
            case BOOLEAN: {
                row.setBoolean(i, this.isNull(data) ? null : Boolean.valueOf(data));
                break;
            }
            case TINYINT: {
                row.setTinyint(i, this.isNull(data) ? null : Byte.valueOf(data));
                break;
            }
            case SMALLINT: {
                row.setSmallint(i, this.isNull(data) ? null : Short.valueOf(data));
                break;
            }
            case INT: {
                row.setInt(i, this.isNull(data) ? null : Integer.valueOf(data));
                break;
            }
            case BIGINT: {
                row.setBigint(i, this.isNull(data) ? null : Long.valueOf(data));
                break;
            }
            case FLOAT: {
                row.setFloat(i, this.isNull(data) ? null : Float.valueOf(data));
                break;
            }
            case REAL: {
                row.setReal(i, this.isNull(data) ? null : Float.valueOf(data));
                break;
            }
            case DOUBLE: {
                row.setDouble(i, this.isNull(data) ? null : Double.valueOf(data));
                break;
            }
            case DECIMAL: {
                row.setDecimal(i, this.isNull(data) ? null : new BigDecimal(data));
                break;
            }
            case STRING: {
                row.setString(i, this.isNull(data) ? null : data);
                break;
            }
            case DATE: {
                row.setDate(i, this.isNull(data) ? null : DateFormatUtils.getDate(data, null, null));
                break;
            }
            case TIME: {
                row.setTime(i, this.isNull(data) ? null : DateFormatUtils.getTime(data, null, null));
                break;
            }
            case TIMESTAMP: {
                row.setTimestamp(i, this.isNull(data) ? null : DateFormatUtils.getTimestamp(data, null, null));
                break;
            }
            case BINARY: {
                row.setBinary(i, this.isNull(data) ? null : Base64.getDecoder().decode(data));
                break;
            }
            case ARRAY: {
                row.getRecord().set(i, this.isNull(data) ? null : JsonUtils.toObject((String)data, List.class));
                break;
            }
            case MAP: 
            case STRUCT: {
                row.getRecord().set(i, this.isNull(data) ? null : JsonUtils.toObject((String)data, Map.class));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type: " + dataType.getName());
            }
        }
    }

    private boolean isNull(String data) {
        return data == null || data.equals(NULL_VALUE_FOR_CSV);
    }

    @Override
    public boolean hasNext() throws DLIException {
        return this.iterator != null && ((ResultIterator)this.iterator).hasNext() || this.nextIterIdx < this.totalIter;
    }
}

