/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.read.impl;

import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.meta.Row;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.read.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.LinkedBlockingDeque;

public class InMemoryReader
implements ResultSet {
    private LinkedBlockingDeque<Row> rows;
    private boolean closed = false;

    public InMemoryReader(List<Row> rows) {
        this.rows = new LinkedBlockingDeque<Row>(rows);
    }

    public InMemoryReader(List<Column> schema, LinkedBlockingDeque<Object[]> rows) {
        this.rows = new LinkedBlockingDeque();
        for (Object[] item : rows) {
            Row row = new Row(schema);
            row.setRecord(new ArrayList<Object>(Arrays.asList(item)));
            this.rows.add(row);
        }
    }

    public InMemoryReader(List<Column> schema, List<Object[]> rows) {
        this.rows = new LinkedBlockingDeque();
        for (Object[] item : rows) {
            Row row = new Row(schema);
            row.setRecord(new ArrayList<Object>(Arrays.asList(item)));
            this.rows.add(row);
        }
    }

    @Override
    public void init() {
    }

    @Override
    public Row read() throws DLIException {
        return this.rows.poll();
    }

    @Override
    public void close() throws DLIException {
        if (this.closed) {
            throw new IllegalStateException("The reader state is closed");
        }
        this.closed = true;
    }

    @Override
    public boolean hasNext() throws DLIException {
        return !this.rows.isEmpty();
    }
}

