/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.read.impl;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.meta.Row;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.meta.types.DataType;
import com.huawei.dli.sdk.read.impl.ReaderBase;
import com.huawei.dli.sdk.util.DateFormatUtils;
import com.huawei.dli.sdk.util.ObsProxy;
import com.obs.services.model.ObsObject;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.LineIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonObsReader
extends ReaderBase<LineIterator> {
    private static final Logger log = LoggerFactory.getLogger(JsonObsReader.class);
    private static final Gson GSON = new Gson();

    public JsonObsReader(ObsProxy obsProxy, List<ObsObject> objects, List<Column> resultSchema) {
        super(obsProxy, resultSchema, objects);
        this.toIterFunc = inputStream -> IOUtils.lineIterator((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
    }

    @Override
    public Row read() throws DLIException {
        if (this.closed) {
            throw new IllegalStateException("The reader state is closed");
        }
        for (int times = 0; times < 5; ++times) {
            try {
                if (!((LineIterator)this.iterator).hasNext()) {
                    log.info("Read {} records from pre iterator", (Object)this.readRecordsPerIter);
                    if (this.nextIterIdx < this.totalIter) {
                        this.iterator = this.getNextIterator();
                    }
                }
                if (this.iterator != null && ((LineIterator)this.iterator).hasNext()) {
                    String values = ((LineIterator)this.iterator).next();
                    Row row = new Row(this.resultSchema);
                    this.updateRow(values, row);
                    ++this.readRecordsPerIter;
                    return row;
                }
                return null;
            }
            catch (Exception e) {
                log.warn("Get record failed, may be connection closed by obs, so reconnect it!!!", (Throwable)e);
                this.reconnectAndSkipHandled();
                continue;
            }
        }
        throw new DLIException("Failed to read value with retry");
    }

    private void updateRow(String jsonStr, Row row) throws DLIException {
        JsonObject jsonObject = JsonParser.parseString((String)jsonStr).getAsJsonObject();
        List<Column> columns = row.getSchema();
        for (int i = 0; i < columns.size(); ++i) {
            Column column = columns.get(i);
            String colNameInFile = column.getName();
            JsonElement jsonElement = null;
            if (jsonObject.has(colNameInFile)) {
                jsonElement = jsonObject.get(colNameInFile);
            } else {
                log.debug("Missing data for column: {}", (Object)column.getName());
            }
            this.updateCol(row, i, column.getType(), jsonElement);
        }
    }

    private void updateCol(Row row, int i, DataType dataType, JsonElement element) throws DLIException {
        DataType.TypeName typeName = DataType.TypeName.fromName(dataType.getName());
        switch (typeName) {
            case VOID: {
                row.setObject(i, null, DataType.TypeName.VOID);
                break;
            }
            case BOOLEAN: {
                row.setBoolean(i, this.isNull(element) ? null : Boolean.valueOf(element.getAsBoolean()));
                break;
            }
            case TINYINT: {
                row.setTinyint(i, this.isNull(element) ? null : Byte.valueOf(element.getAsByte()));
                break;
            }
            case SMALLINT: {
                row.setSmallint(i, this.isNull(element) ? null : Short.valueOf(element.getAsShort()));
                break;
            }
            case INT: {
                row.setInt(i, this.isNull(element) ? null : Integer.valueOf(element.getAsInt()));
                break;
            }
            case BIGINT: {
                row.setBigint(i, this.isNull(element) ? null : Long.valueOf(element.getAsLong()));
                break;
            }
            case FLOAT: {
                row.setFloat(i, this.isNull(element) ? null : Float.valueOf(element.getAsFloat()));
                break;
            }
            case REAL: {
                row.setReal(i, this.isNull(element) ? null : Float.valueOf(element.getAsFloat()));
                break;
            }
            case DOUBLE: {
                row.setDouble(i, this.isNull(element) ? null : Double.valueOf(element.getAsDouble()));
                break;
            }
            case DECIMAL: {
                row.setDecimal(i, this.isNull(element) ? null : element.getAsBigDecimal());
                break;
            }
            case STRING: {
                row.setString(i, this.isNull(element) ? null : element.getAsString());
                break;
            }
            case DATE: {
                row.setDate(i, this.isNull(element) ? null : DateFormatUtils.getDate(element.getAsString(), null, null));
                break;
            }
            case TIME: {
                row.setTime(i, this.isNull(element) ? null : DateFormatUtils.getTime(element.getAsString(), null, null));
                break;
            }
            case TIMESTAMP: {
                row.setTimestamp(i, this.isNull(element) ? null : DateFormatUtils.getTimestamp(element.getAsString(), null, null));
                break;
            }
            case BINARY: {
                row.setBinary(i, this.isNull(element) ? null : Base64.getDecoder().decode(element.getAsString()));
                break;
            }
            case ARRAY: {
                row.getRecord().set(i, this.isNull(element) ? null : GSON.fromJson((JsonElement)element.getAsJsonArray(), List.class));
                break;
            }
            case MAP: 
            case STRUCT: {
                row.getRecord().set(i, this.isNull(element) ? null : GSON.fromJson((JsonElement)element.getAsJsonObject(), Map.class));
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported data type: " + dataType.getName());
            }
        }
    }

    private boolean isNull(JsonElement element) {
        return element == null || element.isJsonNull();
    }

    @Override
    public boolean hasNext() throws DLIException {
        for (int times = 0; times < 5; ++times) {
            try {
                return this.iterator != null && ((LineIterator)this.iterator).hasNext() || this.nextIterIdx < this.totalIter;
            }
            catch (Exception e) {
                log.warn("Get record failed, may be connection closed by obs, so reconnect it!!!", (Throwable)e);
                this.reconnectAndSkipHandled();
                continue;
            }
        }
        throw new IllegalStateException("Should not reach this");
    }
}

