/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.read.impl;

import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.read.ResultSet;
import com.huawei.dli.sdk.util.ObsProxy;
import com.obs.services.model.ObsObject;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ReaderBase<T extends Iterator<?>>
implements ResultSet {
    private static final Logger log = LoggerFactory.getLogger(ReaderBase.class);
    static final int MAX_RECONNECT_NUM = 5;
    final ObsProxy obsProxy;
    final List<Column> resultSchema;
    final List<ObsObject> objects;
    int totalIter = 0;
    int nextIterIdx = 0;
    T iterator;
    int readRecordsPerIter = 0;
    Function<InputStream, T> toIterFunc;
    boolean closed = false;

    ReaderBase(ObsProxy obsProxy, List<Column> resultSchema, List<ObsObject> objects) {
        this.obsProxy = obsProxy;
        this.resultSchema = resultSchema;
        this.objects = objects;
    }

    @Override
    public void init() throws DLIException {
        this.totalIter = this.objects.size();
        log.info("Object size: {}", (Object)this.totalIter);
        this.iterator = this.getNextIterator();
    }

    protected T getNextIterator() throws DLIException {
        if (this.totalIter > 0 && this.nextIterIdx < this.totalIter) {
            this.readRecordsPerIter = 0;
            return this.createIterator(false);
        }
        return null;
    }

    protected T createIterator(boolean recreate) throws DLIException {
        int n;
        if (recreate) {
            n = this.nextIterIdx - 1;
        } else {
            int n2 = this.nextIterIdx;
            n = n2;
            this.nextIterIdx = n2 + 1;
        }
        int currIterIdx = n;
        ObsObject object = this.objects.get(currIterIdx);
        log.info("{} iterator for object: {}", (Object)(recreate ? "Recreate" : "Create"), (Object)object.getObjectKey());
        return (T)((Iterator)this.toIterFunc.apply(this.obsProxy.getObjectStream(object.getBucketName(), object.getObjectKey())));
    }

    protected void reconnectAndSkipHandled() throws DLIException {
        int retryTime = 0;
        while (true) {
            try {
                this.iterator = this.createIterator(true);
                log.warn("Reconnect, and skip records: {}", (Object)this.readRecordsPerIter);
                long startTime = System.currentTimeMillis();
                for (int i = 0; i < this.readRecordsPerIter; ++i) {
                    if (!this.iterator.hasNext()) {
                        throw new DLIException(String.format(Locale.ROOT, "Unexpected error, pre read records: %d, but now only read records: %d", this.readRecordsPerIter, i + 1));
                    }
                    this.iterator.next();
                }
                long endTime = System.currentTimeMillis();
                log.info("Skip records cost: {}ms", (Object)(endTime - startTime));
            }
            catch (Exception e) {
                log.warn("Reconnect failed " + ++retryTime + " times", (Throwable)e);
                if (retryTime < 5) continue;
                throw new DLIException("Reconnect failed over max retry times", e);
            }
            break;
        }
    }

    @Override
    public void close() throws DLIException {
        if (this.closed) {
            throw new IllegalStateException("The reader state is closed");
        }
        log.info("Close reader.");
        this.closed = true;
    }
}

