/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.util;

import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.function.ApiSupplier;
import com.huawei.dli.sdk.function.DliSupplier;
import com.huaweicloud.sdk.core.exception.ServiceResponseException;
import com.huaweicloud.sdk.core.invoker.SyncInvoker;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class ApiTemplate {
    private static final List<String> SERVER_ERR_CODES = Arrays.asList("DLI.0999", "APIGW.0201", "APIGW.0202", "APIGW.0203", "APIGW.0401", "APIGW.0402", "APIGW.0404");
    private static String version = "dli-sdk-java/2.1.1";

    public static void setVersion(String version) {
        ApiTemplate.version = version;
    }

    public static <T> T invokeApi(DliSupplier<T> apiCall, String exceptionMsg) throws DLIException {
        try {
            return apiCall.get();
        }
        catch (ServiceResponseException e) {
            throw new DLIException(e.getHttpStatusCode(), ApiTemplate.toThrowMsg(e, exceptionMsg));
        }
    }

    public static <T, R> R invokeApi(ApiSupplier<T, R> apiCall, String exceptionMsg) throws DLIException {
        try {
            return (R)((SyncInvoker)apiCall.get().addHeader("X-User-Agent", version)).invoke();
        }
        catch (ServiceResponseException e) {
            throw new DLIException(e.getHttpStatusCode(), ApiTemplate.toThrowMsg(e, exceptionMsg));
        }
    }

    public static <T, R> R invokeApiWithRetry(ApiSupplier<T, R> apiCall, String exceptionMsg, int retryTimes, long sleepMs) throws DLIException {
        for (int i = 0; i < retryTimes; ++i) {
            try {
                return (R)((SyncInvoker)apiCall.get().addHeader("X-User-Agent", version)).invoke();
            }
            catch (ServiceResponseException e) {
                if (!ApiTemplate.isServerError(e.getHttpStatusCode(), e.getErrorCode())) {
                    throw new DLIException(e.getHttpStatusCode(), ApiTemplate.toThrowMsg(e, exceptionMsg));
                }
                if (i >= retryTimes - 1) {
                    throw new DLIException(e.getHttpStatusCode(), ApiTemplate.toThrowMsg(e, exceptionMsg));
                }
                ApiTemplate.trySleep(sleepMs);
                continue;
            }
        }
        return null;
    }

    private static boolean isServerError(int httpCode, String errCode) {
        if (httpCode / 100 == 5) {
            return true;
        }
        for (String serverErrCode : SERVER_ERR_CODES) {
            if (httpCode / 100 != 4 || !errCode.toUpperCase(Locale.ROOT).contains(serverErrCode)) continue;
            return true;
        }
        return false;
    }

    private static String toThrowMsg(ServiceResponseException e, String exceptionMsg) {
        return exceptionMsg + ", httCode: " + e.getHttpStatusCode() + ", requestId: " + e.getRequestId() + ", errorCode: " + e.getErrorCode() + ", errorMsg: " + e.getErrorMsg();
    }

    public static void trySleep(long mills) throws DLIException {
        try {
            Thread.sleep(mills);
        }
        catch (InterruptedException e) {
            throw new DLIException("Interrupted when sleeping", e);
        }
    }

    public static <T> T handleResponse(boolean isSuccess, DliSupplier<T> successFunc, String exceptionMsg) throws DLIException {
        if (isSuccess) {
            return successFunc.get();
        }
        throw new DLIException(exceptionMsg);
    }
}

