/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.util;

import com.huawei.dli.sdk.exception.DLIException;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQueries;
import java.util.Calendar;

public class DateFormatUtils {
    public static final ThreadLocal<SimpleDateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));
    public static final ThreadLocal<SimpleDateFormat> DATE_TIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    public static final ThreadLocal<SimpleDateFormat> TIMESTAMP_FORMAT_ZONE = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSXXX"));
    public static final ThreadLocal<SimpleDateFormat> TIMESTAMP_FORMAT_ZONE_ZZ = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZZ"));
    private static final DateTimeFormatter SQL_DATE_PATTERN = DateTimeFormatter.ofPattern("yyyy-MM-dd[ HH:mm:ss[.SSSSSS][.SSS][ VV][ zzzz]]");
    private static final DateTimeFormatter SQL_TIME_PATTERN = DateTimeFormatter.ofPattern("[yyyy-MM-dd ]HH:mm:ss[.SSSSSS][.SSS][ VV][ zzzz]");
    private static final DateTimeFormatter SQL_TIMESTAMP_PATTERN = DateTimeFormatter.ofPattern("[yyyy-MM-dd HH:mm:ss[.SSSSSS][.SSS][ VV][ zzzz]][yyyy-MM-dd][HH:mm:ss[.SSSSSS][.SSS][ VV][ zzzz]]");

    private DateFormatUtils() {
    }

    public static String getDateTimeString(java.util.Date date) {
        return DATE_TIME_FORMAT.get().format(date);
    }

    public static String getDateString(Date date) {
        return DATE_FORMAT.get().format(new Date(date.getTime()));
    }

    private static Timestamp timestampOf(String data, Calendar calendar, ZoneId localTimeZoneId) {
        try {
            if (localTimeZoneId == null) {
                localTimeZoneId = ZoneId.systemDefault();
            }
            ZoneId targetZone = calendar == null ? localTimeZoneId : calendar.getTimeZone().toZoneId();
            LocalDateTime localTime = Timestamp.valueOf(data).toLocalDateTime();
            ZonedDateTime zonedTimestamp = localTime.atZone(targetZone);
            return new Timestamp(zonedTimestamp.toInstant().toEpochMilli());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static Timestamp getTimestampList(ToTimestamp ... lists) {
        for (ToTimestamp get : lists) {
            try {
                Timestamp timestamp = get.get();
                if (timestamp == null) continue;
                return timestamp;
            }
            catch (NumberFormatException | ParseException | DateTimeParseException exception) {
                // empty catch block
            }
        }
        return null;
    }

    private static Timestamp getTimestampFromDateTimeFormatter(String data, Calendar calendar, ZoneId localTimeZoneId, DateTimeFormatter dateTimeFormatter) {
        ZonedDateTime zonedTimestamp = DateFormatUtils.getZonedTimestamp(data, calendar, localTimeZoneId, dateTimeFormatter);
        return new Timestamp(zonedTimestamp.toInstant().toEpochMilli());
    }

    private static ZonedDateTime getZonedTimestamp(String data, Calendar calendar, ZoneId localTimeZoneId, DateTimeFormatter dateTimeFormatter) {
        if (localTimeZoneId == null) {
            localTimeZoneId = ZoneId.systemDefault();
        }
        ZoneId targetZone = calendar == null ? localTimeZoneId : calendar.getTimeZone().toZoneId();
        TemporalAccessor parsedTimestamp = dateTimeFormatter.parseBest(data, ZonedDateTime::from, LocalDateTime::from, LocalTime::from, LocalDate::from);
        ZonedDateTime zonedTimestamp = parsedTimestamp instanceof ZonedDateTime ? (ZonedDateTime)parsedTimestamp : (parsedTimestamp instanceof LocalDateTime ? ((LocalDateTime)parsedTimestamp).atZone(targetZone) : (parsedTimestamp instanceof LocalTime ? LocalDateTime.of(LocalDate.ofEpochDay(0L), (LocalTime)parsedTimestamp).atZone(targetZone) : LocalDateTime.of((LocalDate)parsedTimestamp, LocalTime.of(0, 0)).atZone(targetZone)));
        return zonedTimestamp;
    }

    public static Timestamp getTimestamp(String data, Calendar calendar, ZoneId localTimeZoneId) throws DLIException {
        Timestamp timestamp = DateFormatUtils.timestampOf(data, calendar, localTimeZoneId);
        if (timestamp != null) {
            return timestamp;
        }
        timestamp = DateFormatUtils.getTimestampList(() -> new Timestamp(Long.parseLong(data)), () -> new Timestamp(TIMESTAMP_FORMAT_ZONE.get().parse(data).getTime()), () -> new Timestamp(TIMESTAMP_FORMAT_ZONE_ZZ.get().parse(data).getTime()), () -> DateFormatUtils.getTimestampFromDateTimeFormatter(data, calendar, localTimeZoneId, SQL_TIMESTAMP_PATTERN), () -> DateFormatUtils.getTimestampFromDateTimeFormatter(data, calendar, localTimeZoneId, DateTimeFormatter.ISO_LOCAL_DATE_TIME), () -> DateFormatUtils.getTimestampFromDateTimeFormatter(data, calendar, localTimeZoneId, DateTimeFormatter.ISO_OFFSET_DATE_TIME), () -> DateFormatUtils.getTimestampFromDateTimeFormatter(data, calendar, localTimeZoneId, DateTimeFormatter.ISO_ZONED_DATE_TIME), () -> DateFormatUtils.getTimestampFromDateTimeFormatter(data, calendar, localTimeZoneId, DateTimeFormatter.ISO_DATE_TIME), () -> DateFormatUtils.getTimestampFromDateTimeFormatter(data, calendar, localTimeZoneId, DateTimeFormatter.ISO_INSTANT), () -> DateFormatUtils.getTimestampFromDateTimeFormatter(data, calendar, localTimeZoneId, DateTimeFormatter.RFC_1123_DATE_TIME));
        if (timestamp != null) {
            return timestamp;
        }
        throw new DLIException("Failed to parse Timestamp data: " + data);
    }

    private static Time getTimeList(String data, Calendar calendar, ZoneId localTimeZoneId, DateTimeFormatter ... dateTimeFormatters) {
        for (DateTimeFormatter dateTimeFormatter : dateTimeFormatters) {
            try {
                if (localTimeZoneId == null) {
                    localTimeZoneId = ZoneId.systemDefault();
                }
                ZoneId targetZone = calendar == null ? localTimeZoneId : calendar.getTimeZone().toZoneId();
                LocalTime time = dateTimeFormatter.parse((CharSequence)data, TemporalQueries.localTime());
                ZoneId zone = dateTimeFormatter.parse((CharSequence)data, TemporalQueries.zone());
                ZonedDateTime zonedTimestamp = zone != null ? ZonedDateTime.of(LocalDate.now(zone), time, zone) : ZonedDateTime.of(LocalDate.now(targetZone), time, targetZone);
                zonedTimestamp = zonedTimestamp.withZoneSameInstant(localTimeZoneId);
                return Time.valueOf(zonedTimestamp.toLocalTime());
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    private static Time timeOf(String data, Calendar calendar, ZoneId localTimeZoneId) {
        try {
            if (localTimeZoneId == null) {
                localTimeZoneId = ZoneId.systemDefault();
            }
            ZoneId targetZone = calendar == null ? localTimeZoneId : calendar.getTimeZone().toZoneId();
            LocalTime localTime = Time.valueOf(data).toLocalTime();
            ZonedDateTime zonedTimestamp = LocalDateTime.of(LocalDate.ofEpochDay(0L), localTime).atZone(targetZone);
            return new Time(zonedTimestamp.toInstant().toEpochMilli());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public static Time getTime(String data, Calendar calendar, ZoneId localTimeZoneId) throws DLIException {
        Time time = DateFormatUtils.timeOf(data, calendar, localTimeZoneId);
        if (time != null) {
            return time;
        }
        time = DateFormatUtils.getTimeList(data, calendar, localTimeZoneId, SQL_TIME_PATTERN, DateTimeFormatter.ISO_TIME);
        if (time != null) {
            return time;
        }
        throw new DLIException("Failed to parse Time data: " + data);
    }

    private static Date dateOf(String data, Calendar calendar, ZoneId localTimeZoneId) {
        try {
            if (localTimeZoneId == null) {
                localTimeZoneId = ZoneId.systemDefault();
            }
            ZoneId targetZone = calendar == null ? localTimeZoneId : calendar.getTimeZone().toZoneId();
            LocalDate localDate = Date.valueOf(data).toLocalDate();
            ZonedDateTime zonedTimestamp = LocalDateTime.of(localDate, LocalTime.of(0, 0)).atZone(targetZone);
            return new Date(zonedTimestamp.toInstant().toEpochMilli());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static Date getDateList(String data, Calendar calendar, ZoneId localTimeZoneId, DateTimeFormatter ... dateTimeFormatters) {
        for (DateTimeFormatter dateTimeFormatter : dateTimeFormatters) {
            try {
                if (localTimeZoneId == null) {
                    localTimeZoneId = ZoneId.systemDefault();
                }
                ZoneId targetZone = calendar == null ? localTimeZoneId : calendar.getTimeZone().toZoneId();
                LocalDate date = dateTimeFormatter.parse((CharSequence)data.trim(), TemporalQueries.localDate());
                ZonedDateTime zonedTimestamp = ZonedDateTime.of(date, LocalTime.of(0, 0), targetZone);
                zonedTimestamp = zonedTimestamp.withZoneSameInstant(localTimeZoneId);
                return Date.valueOf(zonedTimestamp.toLocalDate());
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        return null;
    }

    public static Date getDate(String data, Calendar calendar, ZoneId localTimeZoneId) throws DLIException {
        Date date = DateFormatUtils.dateOf(data, calendar, localTimeZoneId);
        if (date != null) {
            return date;
        }
        date = DateFormatUtils.getDateList(data, calendar, localTimeZoneId, SQL_DATE_PATTERN, DateTimeFormatter.ISO_DATE, DateTimeFormatter.BASIC_ISO_DATE, DateTimeFormatter.ISO_ORDINAL_DATE, DateTimeFormatter.ISO_WEEK_DATE);
        if (date != null) {
            return date;
        }
        throw new DLIException("Failed to parse Date data: " + data);
    }

    @FunctionalInterface
    private static interface ToTimestamp {
        public Timestamp get() throws NumberFormatException, DateTimeParseException, ParseException;
    }
}

