/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.util;

import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.write.DataBlock;
import com.huawei.dli.sdk.write.IterableInputStream;
import com.obs.services.ObsClient;
import com.obs.services.exception.ObsException;
import com.obs.services.model.AppendObjectRequest;
import com.obs.services.model.AppendObjectResult;
import com.obs.services.model.GetObjectRequest;
import com.obs.services.model.ListObjectsRequest;
import com.obs.services.model.ObjectListing;
import com.obs.services.model.ObsObject;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ObsProxy {
    private static final Logger log = LoggerFactory.getLogger(ObsProxy.class);
    private static final int MAX_RETRY_TIMES = 3;
    private final ObsClient client;

    public ObsProxy(ObsClient client) {
        this.client = client;
    }

    public String getBucketName(String fullPath) {
        try {
            URI url = new URI(fullPath);
            return url.getHost();
        }
        catch (URISyntaxException e) {
            log.error("Failed to get bucket name from full path");
            return null;
        }
    }

    public String getObjectPrefix(String fullPath) {
        try {
            URI url = new URI(fullPath);
            return url.getPath().substring(1);
        }
        catch (URISyntaxException e) {
            log.error("Failed to get object key from full path");
            return null;
        }
    }

    public List<ObsObject> listObjects(String bucketName, String objPrefix) {
        ObjectListing objListing;
        ListObjectsRequest listObjReq = new ListObjectsRequest();
        listObjReq.setBucketName(bucketName);
        listObjReq.setPrefix(objPrefix);
        listObjReq.setMaxKeys(1000);
        ArrayList<ObsObject> obsObjList = new ArrayList<ObsObject>();
        long startTime = System.currentTimeMillis();
        do {
            objListing = this.client.listObjects(listObjReq);
            obsObjList.addAll(objListing.getObjects().stream().filter(object -> object.getMetadata().getContentLength() > 0L).collect(Collectors.toList()));
            listObjReq.setMarker(objListing.getNextMarker());
        } while (objListing.isTruncated());
        long endTime = System.currentTimeMillis();
        log.info("Get objects total cost: {}ms", (Object)(endTime - startTime));
        return obsObjList;
    }

    public InputStream getObjectStream(String bucketName, String objKey) throws DLIException {
        GetObjectRequest getObjReq = new GetObjectRequest(bucketName, objKey);
        try {
            return this.client.getObject(getObjReq).getObjectContent();
        }
        catch (ObsException e) {
            if (e.getResponseCode() == 404) {
                log.warn("The obs object({}) to get is not fount", (Object)objKey);
                return null;
            }
            throw new DLIException("Failed to get obs object(" + objKey + ") content", e);
        }
    }

    public AppendObjectResult appendObject(String bucketName, String objKey, List<DataBlock> dataBlocks) {
        return this.appendObject(bucketName, objKey, -1L, dataBlocks);
    }

    public AppendObjectResult appendObject(String bucketName, String objKey, long position, List<DataBlock> dataBlocks) {
        AppendObjectRequest appendObjReq = new AppendObjectRequest();
        appendObjReq.setBucketName(bucketName);
        appendObjReq.setObjectKey(objKey);
        if (position != -1L) {
            appendObjReq.setPosition(position);
        }
        for (int i = 0; i < 3; ++i) {
            Iterator<DataBlock> iterator = dataBlocks.iterator();
            IterableInputStream<DataBlock> inputStream = null;
            try {
                inputStream = new IterableInputStream<DataBlock>(iterator, DataBlock::getData, DataBlock::getLength);
                appendObjReq.setInput(inputStream);
                AppendObjectResult appendObjectResult = this.client.appendObject(appendObjReq);
                return appendObjectResult;
            }
            catch (ObsException e) {
                String exceptionMsg = ExceptionUtils.getStackTrace((Throwable)e);
                if (exceptionMsg.contains("Connection reset") || exceptionMsg.contains("Broken pipe")) {
                    log.warn("Append object failed, may be connection closed by obs, so reconnect it!", (Throwable)e);
                    continue;
                }
                throw e;
            }
            finally {
                IOUtils.closeQuietly(inputStream, c -> {});
            }
        }
        return null;
    }
}

