/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.util;

import com.huawei.dli.sdk.common.CsvFormatInfo;
import com.huawei.dli.sdk.common.PartitionSpec;
import com.huawei.dli.sdk.common.SqlDialect;
import com.huawei.dli.sdk.common.StorageType;
import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.function.DliFunction;
import com.huawei.dli.sdk.meta.Table;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.read.ResultSet;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public class SqlUtils {
    private static final DateTimeFormatter JAVA_DEFAULT_TS_FORMAT = DateTimeFormatter.ofPattern("EEE MMM dd HH:mm:ss zzz yyyy", Locale.ENGLISH);
    private static final Map<String, Table.HiveSerDe> HIVE_SER_DE_MAP = new HashMap<String, Table.HiveSerDe>(){
        {
            this.put("parquet", new Table.HiveSerDe("org.apache.hadoop.hive.ql.io.parquet.serde.ParquetHiveSerDe", "org.apache.hadoop.hive.ql.io.parquet.MapredParquetInputFormat", "org.apache.hadoop.hive.ql.io.parquet.MapredParquetOutputFormat"));
            this.put("avro", new Table.HiveSerDe("org.apache.hadoop.hive.serde2.avro.AvroSerDe", "org.apache.hadoop.hive.ql.io.avro.AvroContainerInputFormat", "org.apache.hadoop.hive.ql.io.avro.AvroContainerOutputFormat"));
            this.put("orc", new Table.HiveSerDe("org.apache.hadoop.hive.ql.io.orc.OrcSerde", "org.apache.hadoop.hive.ql.io.orc.OrcInputFormat", "org.apache.hadoop.hive.ql.io.orc.OrcOutputFormat"));
            this.put("rcfile", new Table.HiveSerDe("org.apache.hadoop.hive.serde2.columnar.LazyBinaryColumnarSerDe", "org.apache.hadoop.hive.ql.io.RCFileOutputFormat", "org.apache.hadoop.hive.ql.io.RCFileOutputFormat"));
            this.put("sequencefile", new Table.HiveSerDe("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", "org.apache.hadoop.mapred.SequenceFileInputFormat", "org.apache.hadoop.mapred.SequenceFileOutputFormat"));
            this.put("textfile", new Table.HiveSerDe("org.apache.hadoop.hive.serde2.lazy.LazySimpleSerDe", "org.apache.hadoop.mapred.TextInputFormat", "org.apache.hadoop.hive.ql.io.HiveIgnoreKeyTextOutputFormat"));
        }
    };
    private static SqlDialect dialect = SqlDialect.SPARK;

    public static void setDialect(SqlDialect dialect) {
        SqlUtils.dialect = dialect;
    }

    private static String genSql(Supplier<String> genSparkSql, Supplier<String> genHetuEngineSql) {
        switch (dialect) {
            case SPARK: {
                return genSparkSql.get();
            }
            case HETU_ENGINE: {
                return genHetuEngineSql.get();
            }
        }
        throw new UnsupportedOperationException("Unsupported dialect: " + (Object)((Object)dialect));
    }

    public static String genCreateDatabaseSql(String dbName, String comment, String enterpriseProjectId) {
        return SqlUtils.genSql(() -> SqlUtils.genSparkCreateDbSql(dbName, comment, enterpriseProjectId), () -> {
            throw new UnsupportedOperationException("Currently generate hetuEngine create database sql is unsupported");
        });
    }

    private static String genSparkCreateDbSql(String dbName, String comment, String enterpriseProjectId) {
        if (StringUtils.isEmpty((CharSequence)dbName)) {
            throw new IllegalArgumentException("Missing database name define");
        }
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append("CREATE DATABASE IF NOT EXISTS `").append(dbName).append("`");
        Optional.ofNullable(comment).map(c -> sqlBuilder.append(" COMMENT '").append((String)c).append("'"));
        Optional.ofNullable(enterpriseProjectId).map(epId -> sqlBuilder.append(" WITH DBPROPERTIES('ENTERPRISE_PROJECT_ID'='").append((String)epId).append("')"));
        return sqlBuilder.toString();
    }

    public static String genDeleteDatabaseSql(String dbName) {
        return SqlUtils.genSql(() -> "DROP DATABASE IF EXISTS " + SqlUtils.withQuote(dbName, "`"), () -> "DROP SCHEMA IF EXISTS " + SqlUtils.withQuote(dbName, "\""));
    }

    public static String genGetDatabaseSql(String dbName) {
        return SqlUtils.genSql(() -> "DESCRIBE DATABASE EXTENDED `" + dbName + "`", () -> {
            throw new UnsupportedOperationException("Currently generate hetuEngine get database sql is unsupported");
        });
    }

    public static String genListDatabasesSql(String catalogName, String dbPattern) {
        return SqlUtils.genSql(() -> {
            String sql = "SHOW DATABASES";
            if (StringUtils.isNotEmpty((CharSequence)dbPattern)) {
                sql = sql + " LIKE '" + dbPattern + "'";
            }
            return sql;
        }, () -> {
            String sql = "SHOW SCHEMAS";
            if (StringUtils.isNotEmpty((CharSequence)catalogName)) {
                sql = sql + " FROM " + SqlUtils.withQuote(catalogName, "\"");
            }
            if (StringUtils.isNotEmpty((CharSequence)dbPattern)) {
                sql = sql + " LIKE '" + dbPattern + "'";
            }
            return sql;
        });
    }

    public static String genCreateTableSql(String dbName, String tblName, String comment, List<Column> columns, StorageType storageType, String location, CsvFormatInfo csvFormatInfo) {
        return SqlUtils.genSql(() -> SqlUtils.genSparkCreateTblSql(dbName, tblName, comment, columns, storageType, location, csvFormatInfo), () -> {
            throw new UnsupportedOperationException("Currently generate hetuEngine create table sql is unsupported");
        });
    }

    private static String genSparkCreateTblSql(String dbName, String tblName, String comment, List<Column> columns, StorageType storageType, String location, CsvFormatInfo csvFormatInfo) {
        StringBuilder sqlBuilder = new StringBuilder();
        sqlBuilder.append(SqlUtils.genTblHeaderDefStr(dbName, tblName)).append(SqlUtils.genColsDefStr(columns)).append(SqlUtils.genUsingDefStr(storageType.getName()));
        Optional.ofNullable(SqlUtils.genOptionDefStr(storageType, location, csvFormatInfo)).map(sqlBuilder::append);
        Optional.ofNullable(SqlUtils.genPartColsDefStr(columns)).map(sqlBuilder::append);
        Optional.ofNullable(comment).map(c -> sqlBuilder.append(" COMMENT '").append((String)c).append("'"));
        return sqlBuilder.toString();
    }

    private static String genTblHeaderDefStr(String dbName, String tblName) {
        if (StringUtils.isEmpty((CharSequence)dbName) || StringUtils.isEmpty((CharSequence)tblName)) {
            throw new IllegalArgumentException("Missing table name define");
        }
        return "CREATE TABLE IF NOT EXISTS `" + dbName + "`.`" + tblName + "`";
    }

    private static String genColsDefStr(List<Column> columns) {
        if (columns == null || columns.isEmpty()) {
            throw new IllegalArgumentException("Missing columns define");
        }
        return columns.stream().map(col -> {
            String colDefStr = "`" + col.getName() + "` " + col.getType().getName();
            if (StringUtils.isNotEmpty((CharSequence)col.getDescription())) {
                colDefStr = colDefStr + " COMMENT '" + col.getDescription() + "'";
            }
            return colDefStr;
        }).collect(Collectors.joining(", ", " (", ")"));
    }

    private static String genUsingDefStr(String fileFormat) {
        return " USING " + fileFormat;
    }

    private static String genOptionDefStr(StorageType storageType, String dataPath, CsvFormatInfo csvFormatInfo) {
        String pathKV = null;
        if (StringUtils.isNotEmpty((CharSequence)dataPath)) {
            pathKV = "path '" + dataPath + "'";
        }
        if (storageType == StorageType.CSV || storageType == StorageType.JSON) {
            StringJoiner joiner = new StringJoiner(", ");
            SqlUtils.optionalJoin(joiner, pathKV);
            SqlUtils.optionalJoin(joiner, SqlUtils.genOpKVStr("header", String.valueOf(csvFormatInfo.isWithColumnHeader())));
            SqlUtils.optionalJoin(joiner, SqlUtils.genOpKVStr("delimiter", csvFormatInfo.getDelimiter()));
            SqlUtils.optionalJoin(joiner, SqlUtils.genOpKVStr("quote", csvFormatInfo.getQuoteChar()));
            SqlUtils.optionalJoin(joiner, SqlUtils.genOpKVStr("escape", csvFormatInfo.getEscapeChar()));
            SqlUtils.optionalJoin(joiner, SqlUtils.genOpKVStr("dateformat", csvFormatInfo.getDateFormat()));
            SqlUtils.optionalJoin(joiner, SqlUtils.genOpKVStr("timestampformat", csvFormatInfo.getTimestampFormat()));
            String kvsStr = joiner.toString();
            if (StringUtils.isNotEmpty((CharSequence)kvsStr)) {
                return " OPTIONS (" + kvsStr + ")";
            }
        }
        if (StringUtils.isNotEmpty(pathKV)) {
            return " OPTIONS (" + pathKV + ")";
        }
        return null;
    }

    private static void optionalJoin(StringJoiner joiner, String v) {
        Optional.ofNullable(v).map(joiner::add);
    }

    private static String genOpKVStr(String k, String v) {
        if (StringUtils.isEmpty((CharSequence)v)) {
            return null;
        }
        return k + "='" + v + "'";
    }

    private static String genPartColsDefStr(List<Column> columns) {
        List partColNames = columns.stream().filter(Column::isPartitionColumn).map(Column::getName).collect(Collectors.toList());
        if (!partColNames.isEmpty()) {
            return " PARTITIONED BY (" + String.join((CharSequence)", ", partColNames) + ")";
        }
        return null;
    }

    public static String genDeleteTableSql(String dbName, String tblName) {
        return SqlUtils.genSql(() -> "DROP TABLE IF EXISTS " + SqlUtils.withQuote(dbName, "`") + "." + SqlUtils.withQuote(tblName, "`"), () -> "DROP TABLE IF EXISTS " + SqlUtils.withQuote(dbName, "\"") + "." + SqlUtils.withQuote(tblName, "\""));
    }

    public static String genGetTableSql(String dbName, String tblName) {
        return SqlUtils.genSql(() -> "DESCRIBE EXTENDED " + SqlUtils.withQuote(dbName, "`") + "." + SqlUtils.withQuote(tblName, "`"), () -> "DESCRIBE " + SqlUtils.withQuote(dbName, "\"") + "." + SqlUtils.withQuote(tblName, "\""));
    }

    public static String genListTablesSql(String dbName, String tblPattern) {
        Function<String, String> func = x -> {
            String sql = "SHOW TABLES FROM " + SqlUtils.withQuote(dbName, x);
            if (StringUtils.isNotEmpty((CharSequence)tblPattern)) {
                sql = sql + " LIKE '" + tblPattern + "'";
            }
            return sql;
        };
        return SqlUtils.genSql(() -> (String)func.apply("`"), () -> (String)func.apply("\""));
    }

    public static String genGetPartitionSql(String dbName, String tblName, PartitionSpec partSpec) {
        return SqlUtils.genSql(() -> "DESCRIBE EXTENDED `" + dbName + "`.`" + tblName + "` PARTITION(" + partSpec.toString() + ")", () -> {
            throw new UnsupportedOperationException("Currently generate hetuEngine get partition sql is unsupported");
        });
    }

    public static String genListPartitionsSql(String dbName, String tblName) {
        return SqlUtils.genSql(() -> "SHOW PARTITIONS `" + dbName + "`.`" + tblName + "`", () -> {
            throw new UnsupportedOperationException("Currently generate hetuEngine list partitions sql is unsupported");
        });
    }

    public static String genListFunctions(String dbName, String funcPattern) {
        BiFunction<String, String, String> func = (x, y) -> {
            String sql = "SHOW" + (StringUtils.isNotEmpty((CharSequence)x) ? " " + x : "") + " FUNCTIONS";
            if (StringUtils.isNotEmpty((CharSequence)dbName)) {
                sql = sql + " FROM " + SqlUtils.withQuote(dbName, y);
            }
            if (StringUtils.isNotEmpty((CharSequence)funcPattern)) {
                sql = sql + " LIKE '" + funcPattern + "'";
            }
            return sql;
        };
        return SqlUtils.genSql(() -> (String)func.apply("USER", "`"), () -> (String)func.apply(null, "\""));
    }

    private static String withQuote(String name, String quoteChar) {
        return quoteChar + name + quoteChar;
    }

    public static <T> T resultSetWithClose(ResultSet resultSet, DliFunction<ResultSet, T> func) throws DLIException {
        try {
            T t = func.apply(resultSet);
            return t;
        }
        finally {
            if (resultSet != null) {
                resultSet.close();
            }
        }
    }

    public static <T> void validOrThrow(T input, Predicate<T> predicate, String message) {
        if (!predicate.test(input)) {
            throw new IllegalArgumentException(message);
        }
    }

    public static String getDataType(String serde, String inputFormat, String outputFormat) {
        for (Map.Entry<String, Table.HiveSerDe> entry : HIVE_SER_DE_MAP.entrySet()) {
            Table.HiveSerDe hiveSerDe = entry.getValue();
            if (!hiveSerDe.getSerde().equals(serde) || !hiveSerDe.getInputFormat().equals(inputFormat) || !hiveSerDe.getOutputFormat().equals(outputFormat)) continue;
            return entry.getKey();
        }
        return "Unknown";
    }

    public static Map<String, String> toMap(String str) {
        if (StringUtils.isEmpty((CharSequence)str) || !SqlUtils.hasSpecifyPrefixAndSuffix(str)) {
            throw new IllegalArgumentException("Expected input should be link '[k1=v1, k2=v2]' or '{k1=v1, k2=v2}'");
        }
        return Arrays.stream(str.substring(1, str.length() - 1).split(",")).map(kv -> kv.trim().split("=")).filter(arr -> ((String[])arr).length == 2).collect(Collectors.toMap(arr -> arr[0], arr -> arr[1]));
    }

    private static boolean hasSpecifyPrefixAndSuffix(String str) {
        return str.startsWith("[") || str.startsWith("{") || str.endsWith("]") || str.endsWith("}");
    }

    public static long parseTimeStrToMills(String str) {
        return LocalDateTime.parse(str, JAVA_DEFAULT_TS_FORMAT).toInstant(ZoneOffset.UTC).toEpochMilli();
    }
}

