/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.util;

import com.huawei.dli.sdk.common.DLIInfo;
import com.huaweicloud.sdk.core.auth.BasicCredentials;
import com.huaweicloud.sdk.core.auth.ICredential;
import com.huaweicloud.sdk.core.http.HttpConfig;
import com.huaweicloud.sdk.dli.v1.DliClient;
import com.huaweicloud.sdk.lakeformation.v1.LakeFormationClient;
import java.util.ArrayList;

public class V3ClientUtils {
    public static DliClient getDliClient(DLIInfo dliInfo) {
        ArrayList<String> dliEPs = new ArrayList<String>();
        dliEPs.add(dliInfo.getDliEndpoint());
        return (DliClient)DliClient.newBuilder().withCredential((ICredential)V3ClientUtils.getBasicCredentials(dliInfo)).withEndpoints(dliEPs).withHttpConfig(V3ClientUtils.getHttpConfig(dliInfo)).build();
    }

    public static LakeFormationClient getLfClient(DLIInfo dliInfo) {
        ArrayList<String> lfEPs = new ArrayList<String>();
        lfEPs.add(dliInfo.getLfEndpoint());
        return (LakeFormationClient)LakeFormationClient.newBuilder().withCredential((ICredential)V3ClientUtils.getBasicCredentials(dliInfo)).withEndpoints(lfEPs).withHttpConfig(V3ClientUtils.getHttpConfig(dliInfo)).build();
    }

    private static BasicCredentials getBasicCredentials(DLIInfo dliInfo) {
        BasicCredentials credentials = (BasicCredentials)((BasicCredentials)new BasicCredentials().withProjectId(dliInfo.getProjectId()).withAk(dliInfo.getAccessKey())).withSk(dliInfo.getSecretKey());
        if (dliInfo.getSecurityToken() != null && !dliInfo.getSecurityToken().isEmpty()) {
            credentials.withSecurityToken(dliInfo.getSecurityToken());
        }
        return credentials;
    }

    private static HttpConfig getHttpConfig(DLIInfo dliInfo) {
        HttpConfig httpConfig = HttpConfig.getDefaultHttpConfig();
        if (dliInfo.getProxyHost() != null && !dliInfo.getProxyHost().trim().isEmpty()) {
            httpConfig.withProxyHost(dliInfo.getProxyHost()).withProxyPort(dliInfo.getProxyPort()).withProxyUsername(dliInfo.getProxyUser()).withProxyPassword(dliInfo.getProxyPwd());
        }
        return httpConfig;
    }
}

