/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.write;

public class DataBlock {
    private final int size;
    private final byte[] data;
    private int length;
    private boolean fulled = false;

    public DataBlock(int size) {
        this.size = size;
        this.data = new byte[size];
        this.length = 0;
    }

    public void appendData(DataBlock dataBlock) {
        if (dataBlock.length <= 0) {
            return;
        }
        if (dataBlock.getLength() + this.length > this.size) {
            this.fulled = true;
            throw new NegativeArraySizeException();
        }
        System.arraycopy(dataBlock.getData(), 0, this.data, this.length, dataBlock.getLength());
        this.length += dataBlock.getLength();
        if (this.length == this.size) {
            this.fulled = true;
        }
    }

    public void appendData(byte[] data) {
        if (data.length == 0) {
            return;
        }
        if (data.length + this.length > this.size) {
            this.fulled = true;
            throw new NegativeArraySizeException();
        }
        System.arraycopy(data, 0, this.data, this.length, data.length);
        this.length += data.length;
        if (this.length == this.size) {
            this.fulled = true;
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public int getLength() {
        return this.length;
    }

    public boolean isFulled() {
        return this.fulled;
    }
}

