/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.write;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.function.Function;

public class IterableInputStream<T>
extends InputStream {
    public static final int EOF = -1;
    private static final InputStream EOF_INPUT_STREAM = new InputStream(){

        @Override
        public int read() throws IOException {
            return -1;
        }
    };
    private final Iterator<T> iterator;
    private final Function<T, byte[]> dataMapper;
    private final Function<T, Integer> lenMappper;
    private InputStream current;

    public IterableInputStream(Iterator<T> iterator, Function<T, byte[]> dataMapper, Function<T, Integer> lenMapper) {
        this.iterator = iterator;
        this.dataMapper = dataMapper;
        this.lenMappper = lenMapper;
        this.next();
    }

    @Override
    public int read() throws IOException {
        int n = this.current.read();
        while (n == -1 && this.current != EOF_INPUT_STREAM) {
            this.next();
            n = this.current.read();
        }
        return n;
    }

    private void next() {
        if (this.iterator.hasNext()) {
            T data = this.iterator.next();
            this.current = new ByteArrayInputStream(this.dataMapper.apply(data), 0, this.lenMappper.apply(data));
        } else {
            this.current = EOF_INPUT_STREAM;
        }
    }

    @Override
    public void close() {
    }
}

