/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.dli.sdk.write.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.huawei.dli.sdk.exception.DLIException;
import com.huawei.dli.sdk.meta.Row;
import com.huawei.dli.sdk.meta.types.Column;
import com.huawei.dli.sdk.meta.types.DataType;
import com.huawei.dli.sdk.util.ObsProxy;
import com.huawei.dli.sdk.write.DataBlock;
import com.huawei.dli.sdk.write.Writer;
import com.huaweicloud.sdk.core.utils.JsonUtils;
import com.obs.services.model.AppendObjectResult;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonObsWriter
implements Writer {
    private static final Logger log = LoggerFactory.getLogger(JsonObsWriter.class);
    private static final ThreadLocal<DateFormat> DATE_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));
    private static final ThreadLocal<DateFormat> TIMESTAMP_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZZ"));
    private static final ThreadLocal<DateFormat> TIME_FORMAT = ThreadLocal.withInitial(() -> new SimpleDateFormat("HH:mm:ss.SSSZZ"));
    private static final int DATA_BLOCK_SIZE = 0x800000;
    private static final long MAX_SIZE_PER_FILE = 0x8000000L;
    private final ObsProxy obsProxy;
    private final String bucketName;
    private final String objectPrefix;
    private final ArrayList<DataBlock> dataBlocks = new ArrayList();
    private DataBlock dataBlock = null;
    private AppendObjectResult appendObjResult;
    private boolean closed = false;

    public JsonObsWriter(ObsProxy obsProxy, String dataPath) {
        this.obsProxy = obsProxy;
        this.bucketName = obsProxy.getBucketName(dataPath);
        this.objectPrefix = obsProxy.getObjectPrefix(dataPath);
    }

    @Override
    public void write(Row row) throws DLIException {
        if (this.closed) {
            throw new IllegalStateException("The writer state is closed");
        }
        String rowStr = this.toJsonString(row);
        byte[] rowByteArr = rowStr.getBytes(StandardCharsets.UTF_8);
        if (rowByteArr.length > 0x800000) {
            log.info("Create new data block as row length: {} exceed data block size: {}", (Object)rowByteArr.length, (Object)0x800000);
            DataBlock dataBlockInfo = new DataBlock(rowByteArr.length);
            dataBlockInfo.appendData(rowByteArr);
            this.dataBlocks.add(dataBlockInfo);
            this.flush();
            return;
        }
        if (this.dataBlock == null) {
            log.info("Create new data block as data block not init");
            this.dataBlock = new DataBlock(0x800000);
            this.dataBlocks.add(this.dataBlock);
        }
        try {
            this.dataBlock.appendData(rowByteArr);
        }
        catch (NegativeArraySizeException e) {
            log.info("Create new data block as current data block is overflows");
            this.dataBlock = new DataBlock(0x800000);
            this.dataBlocks.add(this.dataBlock);
            this.dataBlock.appendData(rowByteArr);
            this.flush();
        }
    }

    private String toJsonString(Row row) {
        JsonObject jsonObj = new JsonObject();
        List<Column> schema = row.getSchema();
        block17: for (int i = 0; i < schema.size(); ++i) {
            if (schema.get(i).isPartitionColumn()) continue;
            String colName = schema.get(i).getName();
            DataType dataType = schema.get(i).getType();
            DataType.TypeName typeName = DataType.TypeName.fromName(dataType.getName());
            switch (typeName) {
                case BOOLEAN: {
                    jsonObj.addProperty(colName, row.getBoolean(i));
                    continue block17;
                }
                case TINYINT: {
                    jsonObj.addProperty(colName, (Number)row.getTinyint(i));
                    continue block17;
                }
                case SMALLINT: {
                    jsonObj.addProperty(colName, (Number)row.getSmallint(i));
                    continue block17;
                }
                case INT: {
                    jsonObj.addProperty(colName, (Number)row.getInt(i));
                    continue block17;
                }
                case BIGINT: {
                    jsonObj.addProperty(colName, (Number)row.getBigint(i));
                    continue block17;
                }
                case FLOAT: {
                    jsonObj.addProperty(colName, (Number)row.getFloat(i));
                    continue block17;
                }
                case REAL: {
                    jsonObj.addProperty(colName, (Number)row.getReal(i));
                    continue block17;
                }
                case DOUBLE: {
                    jsonObj.addProperty(colName, (Number)row.getDouble(i));
                    continue block17;
                }
                case DECIMAL: {
                    jsonObj.addProperty(colName, (Number)row.getDecimal(i));
                    continue block17;
                }
                case STRING: {
                    jsonObj.addProperty(colName, row.getString(i));
                    continue block17;
                }
                case DATE: {
                    Date dtV = row.getDate(i);
                    jsonObj.addProperty(colName, dtV == null ? null : DATE_FORMAT.get().format(dtV));
                    continue block17;
                }
                case TIME: {
                    Time tV = row.getTime(i);
                    jsonObj.addProperty(colName, tV == null ? null : TIME_FORMAT.get().format(tV));
                    continue block17;
                }
                case TIMESTAMP: {
                    Timestamp tsV = row.getTimestamp(i);
                    jsonObj.addProperty(colName, tsV == null ? null : TIMESTAMP_FORMAT.get().format(tsV));
                    continue block17;
                }
                case BINARY: {
                    byte[] binaryV = row.getBinary(i);
                    jsonObj.addProperty(colName, binaryV == null ? null : Base64.getEncoder().encodeToString(binaryV));
                    continue block17;
                }
                case ARRAY: 
                case MAP: 
                case STRUCT: {
                    JsonElement elem = JsonParser.parseString((String)JsonUtils.toJSON((Object)row.getRecord().get(i)));
                    jsonObj.add(colName, elem);
                    continue block17;
                }
                default: {
                    throw new IllegalArgumentException("Unsupported data type: " + dataType.getName());
                }
            }
        }
        return jsonObj + "\n";
    }

    @Override
    public void flush() throws DLIException {
        if (this.closed) {
            throw new IllegalStateException("The writer state is closed");
        }
        if (this.dataBlocks.size() > 1) {
            this.writeDataBlocks();
        } else {
            log.info("No need to flush data as not full");
        }
    }

    @Override
    public void close() throws DLIException {
        if (this.closed) {
            throw new IllegalStateException("The writer state is closed");
        }
        this.writeDataBlocks();
        this.closed = true;
    }

    private void writeDataBlocks() {
        if (this.dataBlocks.isEmpty()) {
            log.info("There is not data blocks to write");
            return;
        }
        if (this.appendObjResult == null) {
            String objKey = this.objectPrefix + String.format("/part-%s.json", UUID.randomUUID());
            log.info("Flush {} data blocks to {}", (Object)this.dataBlocks.size(), (Object)objKey);
            this.appendObjResult = this.obsProxy.appendObject(this.bucketName, objKey, this.dataBlocks);
        } else {
            log.info("Append {} data blocks to {}", (Object)this.dataBlocks.size(), (Object)this.appendObjResult.getObjectKey());
            this.appendObjResult = this.obsProxy.appendObject(this.bucketName, this.appendObjResult.getObjectKey(), this.appendObjResult.getNextPosition(), this.dataBlocks);
            if (this.appendObjResult.getNextPosition() > 0x8000000L) {
                log.info("Current file size has reached the excepted value");
                this.appendObjResult = null;
            }
        }
        this.dataBlock = null;
        this.dataBlocks.clear();
    }
}

