/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.api.types;

public enum ServiceType {
    IDENTITY("keystone", "identity"),
    APP_CATALOG("murano", "application-catalog"),
    COMPUTE("nova", "compute"),
    IMAGE("glance", "image"),
    BLOCK_STORAGE("cinder", "volume"),
    OBJECT_STORAGE("object-store", "object-store"),
    NETWORK("neutron", "network"),
    EC2("ec2", "ec2"),
    TELEMETRY("ceilometer", "metering"),
    TELEMETRY_AODH("aodh", "alarming"),
    ORCHESTRATION("heat", "orchestration"),
    CLUSTERING("senlin", "clustering"),
    MAP_REDUCE("MRS", "mrsv1.1"),
    SHARE("manila", "share"),
    DATABASE("trove", "database"),
    BARBICAN("barbican", "key-manager"),
    TACKER("tacker", "nfv-orchestration"),
    ARTIFACT("glare", "artifact"),
    MAGNUM("magnum", "container"),
    DNS("designate", "dns"),
    WORKFLOW("mistral", "workflow"),
    VOLUME_BACKUP("VBS", "vbsv2"),
    AUTO_SCALING("AS", "asv1"),
    LOAD_BALANCER("ELB", "elbv1"),
    CLOUD_EYE("CES", "cesv1"),
    TAG_MANAGEMENT("TMS", "tag-management"),
    VPC("VPC", "vpc"),
    VPC2("VPC", "vpcv2.0"),
    EVS("EVS", "evs"),
    EVS2_1("EVS", "evsv2.1"),
    DSS("DSS", "dss"),
    ECS("ECS", "ecs"),
    ECS1_1("ECS", "ecsv1.1"),
    KEY_MANAGEMENT("KMS", "key-management"),
    CLOUD_TRACE("CTS", "cloud-trace"),
    ANTI_DDOS("antiddos", "anti-ddos"),
    Notification("SMN", "smnv2"),
    MessageQueue("DMS", "distributed-message"),
    MAAS("MaaS", "MaaS"),
    NAT("NAT", "nat"),
    BMS("BMS", "bms"),
    DEH("DEH", "deh"),
    CSBS("csbs", "data-protect"),
    CDN("cdn", "cdn"),
    FGS("fgs", "fgs"),
    FGS2_0("fgsv2", "fgsv2"),
    IAM("IAM", "iam"),
    UNKNOWN("NA", "NA");

    private final String serviceName;
    private final String type;

    private ServiceType(String serviceName, String type) {
        this.serviceName = serviceName;
        this.type = type;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public String getType() {
        return this.type;
    }

    public static ServiceType forName(String name) {
        for (ServiceType s : ServiceType.values()) {
            if (s.getServiceName().equalsIgnoreCase(name)) {
                return s;
            }
            if (s.name().equalsIgnoreCase(name)) {
                return s;
            }
            if (!s.type.equalsIgnoreCase(name)) continue;
            return s;
        }
        return UNKNOWN;
    }
}

