/*
 * Decompiled with CFR 0.152.
 */
package com.huawei.openstack4j.core.transport;

import com.google.common.base.Strings;
import com.huawei.openstack4j.api.identity.EndpointURLResolver;
import com.huawei.openstack4j.core.transport.ProxyHost;
import com.huawei.openstack4j.model.common.resolvers.ServiceVersionResolver;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;

public final class Config {
    public static final String DEFAULT_LANGUAGE = "en-us";
    public static final Config DEFAULT = new Config();
    private String language = "en-us";
    private int connectTimeout;
    private int readTimeout;
    private SSLContext sslContext;
    private HostnameVerifier hostNameVerifier;
    private boolean ignoreSSLVerification;
    private String natHostOrIP;
    private int maxConnections;
    private int maxConnectionsPerRoute;
    private ProxyHost proxy;
    private ServiceVersionResolver resolver;
    private EndpointURLResolver endpointURLResolver;
    private ExecutorService executorService;
    private Map<String, Double> microversions = new HashMap<String, Double>();

    private Config() {
    }

    public static Config newConfig() {
        return new Config();
    }

    public Config withLanguage(String language) {
        this.language = language;
        return this;
    }

    public Config withResolver(ServiceVersionResolver resolver) {
        this.resolver = resolver;
        return this;
    }

    public Config withEndpointURLResolver(EndpointURLResolver endpointURLResolver) {
        this.endpointURLResolver = endpointURLResolver;
        return this;
    }

    public Config withConnectionTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public Config withReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public Config withSSLContext(SSLContext sslContext) {
        this.sslContext = sslContext;
        return this;
    }

    public Config withMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
        return this;
    }

    public Config withMaxConnectionsPerRoute(int maxConnectionsPerRoute) {
        this.maxConnectionsPerRoute = maxConnectionsPerRoute;
        return this;
    }

    public Config withProxy(ProxyHost proxy) {
        this.proxy = proxy;
        return this;
    }

    public Config withEndpointNATResolution(String natHostOrIP) {
        this.natHostOrIP = natHostOrIP;
        return this;
    }

    public Config withHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostNameVerifier = hostnameVerifier;
        return this;
    }

    public Config withSSLVerificationDisabled() {
        this.ignoreSSLVerification = Boolean.TRUE;
        return this;
    }

    public Config withExecutor(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public Config setMicroversion(String serviceType, Double microversion) {
        this.microversions.put(serviceType, microversion);
        return this;
    }

    public Map<String, Double> getMicroversions() {
        return this.microversions;
    }

    public Config unsetMicroversion(String serviceType) {
        if (Strings.isNullOrEmpty((String)serviceType)) {
            return this;
        }
        Iterator<Map.Entry<String, Double>> it = this.microversions.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, Double> item = it.next();
            if (!serviceType.equalsIgnoreCase(item.getKey())) continue;
            it.remove();
        }
        return this;
    }

    public Config clearMicroversions() {
        this.microversions.clear();
        return this;
    }

    public String getLanguage() {
        return this.language;
    }

    public ServiceVersionResolver getResolver() {
        return this.resolver;
    }

    public ServiceVersionResolver getV2Resolver() {
        return this.resolver;
    }

    public EndpointURLResolver getEndpointURLResolver() {
        return this.endpointURLResolver;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public int getReadTimeout() {
        return this.readTimeout;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public HostnameVerifier getHostNameVerifier() {
        return this.hostNameVerifier;
    }

    public boolean isIgnoreSSLVerification() {
        return this.ignoreSSLVerification;
    }

    public String getEndpointNATResolution() {
        return this.natHostOrIP;
    }

    public boolean isBehindNAT() {
        return this.natHostOrIP != null;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public int getMaxConnectionsPerRoute() {
        return this.maxConnectionsPerRoute;
    }

    public ProxyHost getProxy() {
        return this.proxy;
    }

    public ExecutorService getExecutor() {
        return this.executorService;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.connectTimeout;
        result = 31 * result + this.maxConnections;
        result = 31 * result + this.maxConnectionsPerRoute;
        result = 31 * result + (this.ignoreSSLVerification ? 1231 : 1237);
        result = 31 * result + (this.natHostOrIP == null ? 0 : this.natHostOrIP.hashCode());
        result = 31 * result + this.readTimeout;
        result = 31 * result + (this.proxy == null ? 0 : this.proxy.hashCode());
        result = 31 * result + (this.sslContext == null ? 0 : this.sslContext.hashCode());
        result = 31 * result + (this.hostNameVerifier == null ? 0 : this.hostNameVerifier.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Config other = (Config)obj;
        if (this.connectTimeout != other.connectTimeout) {
            return false;
        }
        if (this.maxConnections != other.maxConnections) {
            return false;
        }
        if (this.maxConnectionsPerRoute != other.maxConnectionsPerRoute) {
            return false;
        }
        if (this.ignoreSSLVerification != other.ignoreSSLVerification) {
            return false;
        }
        if (this.natHostOrIP == null ? other.natHostOrIP != null : !this.natHostOrIP.equals(other.natHostOrIP)) {
            return false;
        }
        if (this.readTimeout != other.readTimeout) {
            return false;
        }
        if (this.proxy == null ? other.proxy != null : !this.proxy.equals(other.proxy)) {
            return false;
        }
        if (this.sslContext == null ? other.getSslContext() != null : !this.sslContext.equals(other.getSslContext())) {
            return false;
        }
        return !(this.hostNameVerifier == null ? other.getHostNameVerifier() != null : !this.hostNameVerifier.equals(other.getHostNameVerifier()));
    }
}

